/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.migration;

import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.spi.files.IRenamingPersistence;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.migration.Migrator;
import com.nomagic.ci.persistence.local.spi.migration.ResourcePersistenceContext;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ProjectUsagesRemover
implements Migrator {
    private static final Logger LOGGER = Logger.getLogger(ProjectUsagesRemover.class);
    private static final String PROJECT_USAGE_START = "<projectUsages ";
    private static final String PROJECT_USAGE_END = "</projectUsages>";
    private static final String IMMEDIATE_END = "/>";
    private static final String USED_PROJECT_URI_ATTRIBUTE = "usedProjectURI=\"";

    @Override
    public void migrateResources(IRenamingPersistence iRenamingPersistence, ResourcePersistenceContext resourcePersistenceContext) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isStreamMigrationNeeded(IResourcePersistence iResourcePersistence, String string, ResourcePersistenceContext resourcePersistenceContext) {
        IResourceInfoDecoder iResourceInfoDecoder = resourcePersistenceContext.getDecoder();
        ResourceInfo resourceInfo = iResourceInfoDecoder.getResourceInfo(string);
        if (resourceInfo != null) {
            String string2 = resourceInfo.getNamespace();
            String string3 = resourceInfo.getResourceName();
            if ("proxy".equals(string2) && string3 != null && string3.contains("com.nomagic.ci.metamodel") || "com.nomagic.ci.metamodel".equals(string2) && "project".equals(string3)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public InputStream migrateInputStream(IResourcePersistence iResourcePersistence, InputStream inputStream, String string, ResourcePersistenceContext resourcePersistenceContext) {
        try {
            StringBuilder stringBuilder = FileUtil.readText(inputStream);
            this.processProjectUsages(iResourcePersistence, string, stringBuilder);
            return new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            throw new PersistenceRuntimeException((Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processProjectUsages(IResourcePersistence iResourcePersistence, String string, StringBuilder stringBuilder) {
        int n2;
        int n3;
        ArrayList<ProjectUsageLocator> arrayList = new ArrayList<ProjectUsageLocator>();
        int n4 = stringBuilder.indexOf(PROJECT_USAGE_START);
        while (n4 != -1) {
            int n5 = stringBuilder.indexOf(PROJECT_USAGE_START, n4 + 1);
            n3 = stringBuilder.indexOf(IMMEDIATE_END, n4);
            int n6 = stringBuilder.indexOf(PROJECT_USAGE_END, n4);
            if (n3 == -1 && n6 == -1) {
                throw new IllegalStateException("project usage without end, at: />");
            }
            n2 = n3 != -1 && (n6 == -1 || n5 != -1 && n6 > n5) ? 1 : 0;
            int n7 = n2 != 0 ? n3 + IMMEDIATE_END.length() : n6 + PROJECT_USAGE_END.length();
            ProjectUsageLocator projectUsageLocator = this.createUsageLocator(stringBuilder, n4, n7);
            if (projectUsageLocator != null) {
                arrayList.add(projectUsageLocator);
            }
            n4 = n5;
        }
        if (arrayList.isEmpty()) return;
        List<ProjectUsageLocator> list = this.getUsagesToRemove(iResourcePersistence, string, arrayList);
        n3 = list.size();
        if (n3 <= 0) return;
        if (n3 > 1) {
            Collections.sort(list);
            Collections.reverse(list);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(this.getPrintableName()).append(" removed ").append(n3).append(" usages (persistence: ").append(iResourcePersistence.getLocationURI()).append(", stream ID: ").append(string).append("):");
        n2 = 0;
        while (n2 < n3) {
            ProjectUsageLocator projectUsageLocator = list.get(n2);
            stringBuilder.replace(projectUsageLocator.start, projectUsageLocator.end, "");
            stringBuilder2.append("\n\t").append(projectUsageLocator.usedProjectURI);
            ++n2;
        }
        LOGGER.warn((Object)stringBuilder2.toString());
    }

    protected abstract List<ProjectUsageLocator> getUsagesToRemove(IResourcePersistence var1, String var2, List<ProjectUsageLocator> var3);

    private ProjectUsageLocator createUsageLocator(StringBuilder stringBuilder, int n2, int n3) {
        String string = stringBuilder.substring(n2, n3);
        int n4 = string.indexOf(USED_PROJECT_URI_ATTRIBUTE);
        if (n4 != -1) {
            int n5 = n4 + USED_PROJECT_URI_ATTRIBUTE.length();
            int n6 = string.indexOf(34, n5);
            String string2 = string.substring(n5, n6);
            if (!string2.isEmpty()) {
                return new ProjectUsageLocator(n2, n3, string2, string);
            }
        }
        return null;
    }

    protected static class ProjectUsageLocator
    implements Comparable<ProjectUsageLocator> {
        int start;
        int end;
        public String usedProjectURI;
        String usageContents;

        public ProjectUsageLocator(int n2, int n3, String string, String string2) {
            this.start = n2;
            this.end = n3;
            this.usedProjectURI = string;
            this.usageContents = string2;
        }

        @Override
        public int compareTo(ProjectUsageLocator projectUsageLocator) {
            return Integer.valueOf(this.start).compareTo(projectUsageLocator.start);
        }
    }
}

