/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.migration;

import com.nomagic.ci.persistence.local.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PersonalDataMigrator {
    private static final String PROJECT_USERS_START = "<projectUsers";
    private static final String DEFAULT_USER_XMI_ID = EcoreUtil.generateUUID();
    private static final String DEFAULT_USER = "<projectUsers xmi:id=\"" + DEFAULT_USER_XMI_ID + "\" userId=\"" + "default" + "\"/>";
    private static final String PROJECT_END = "</project:Project>";
    private static final String USER_REF_START = "user=\"";
    private static final String SECTION_REF_START = "sections=\"";
    private static final String DEFAULT_USER_REF = " user=\"" + DEFAULT_USER_XMI_ID + "\" ";

    public static InputStream migrate(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = FileUtil.readText(inputStream);
        CharSequence charSequence = PersonalDataMigrator.migrate(stringBuilder);
        return new ByteArrayInputStream(charSequence.toString().getBytes("UTF-8"));
    }

    public static CharSequence migrate(StringBuilder stringBuilder) {
        int n2;
        if (stringBuilder.indexOf(PROJECT_USERS_START) == -1 && (n2 = stringBuilder.indexOf(PROJECT_END)) != -1) {
            stringBuilder.insert(n2, DEFAULT_USER);
            StringBuffer stringBuffer = new StringBuffer();
            Pattern pattern = Pattern.compile("<userParts.*?/>");
            Matcher matcher = pattern.matcher(stringBuilder);
            while (matcher.find()) {
                String string = matcher.group();
                if (string.contains(USER_REF_START)) continue;
                int n3 = string.indexOf(SECTION_REF_START);
                if (n3 == -1) {
                    n3 = string.length() - 2;
                }
                if (n3 <= -1) continue;
                String string2 = String.valueOf(string.substring(0, n3 - 1)) + DEFAULT_USER_REF + string.substring(n3);
                matcher.appendReplacement(stringBuffer, string2);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer;
        }
        return stringBuilder;
    }
}

