/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.migration;

import com.nomagic.ci.persistence.local.spi.DirectResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.DirectStreamHandle;
import com.nomagic.ci.persistence.local.spi.files.DirectStreamHandleCompat;
import com.nomagic.ci.persistence.local.spi.files.IRenamingPersistence;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoEncoder;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.RenamingPersistenceCompat;
import com.nomagic.ci.persistence.local.spi.migration.BinaryResourcesMigrator;
import com.nomagic.ci.persistence.local.spi.migration.CombinedPreBinaryMigrator;
import com.nomagic.ci.persistence.local.spi.migration.CorruptedMountedSharePointMigrator;
import com.nomagic.ci.persistence.local.spi.migration.DuplicateProjectUsagesMigrator;
import com.nomagic.ci.persistence.local.spi.migration.Migrator;
import com.nomagic.ci.persistence.local.spi.migration.ProxyResourceNameMigrator;
import com.nomagic.ci.persistence.local.spi.migration.ResourcePersistenceContext;
import com.nomagic.ci.persistence.local.spi.migration.ResourcePersistenceListener;
import com.nomagic.ci.persistence.local.spi.util.MonitorUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class MigratingResourcePersistence
implements IResourcePersistence,
DirectResourcePersistence,
ResourcePersistenceContext {
    private static final Logger LOGGER = Logger.getLogger(MigratingResourcePersistence.class);
    private final List<Migrator> migrators = new ArrayList<Migrator>();
    private final List<ResourcePersistenceListener> listeners = new ArrayList<ResourcePersistenceListener>();
    private final IResourcePersistence persistence;
    private final IResourceInfoDecoder decoder;
    private final IResourceInfoEncoder encoder;

    public MigratingResourcePersistence(IResourcePersistence iResourcePersistence, IResourceInfoDecoder iResourceInfoDecoder, IResourceInfoEncoder iResourceInfoEncoder) {
        this.initMigrators();
        this.persistence = iResourcePersistence;
        this.decoder = iResourceInfoDecoder;
        this.encoder = iResourceInfoEncoder;
        this.migrate(null);
    }

    protected void initMigrators() {
        this.addMigrator(new ProxyResourceNameMigrator());
        this.addMigrator(new CombinedPreBinaryMigrator());
        this.addMigrator(new BinaryResourcesMigrator());
        this.addMigrator(new CorruptedMountedSharePointMigrator());
        this.addMigrator(new DuplicateProjectUsagesMigrator());
    }

    protected void addMigrator(Migrator migrator) {
        this.migrators.add(migrator);
        if (migrator instanceof ResourcePersistenceListener) {
            this.listeners.add((ResourcePersistenceListener)((Object)migrator));
        }
    }

    public static IResourcePersistence migrate(IResourcePersistence iResourcePersistence, IResourceInfoDecoder iResourceInfoDecoder, IResourceInfoEncoder iResourceInfoEncoder) {
        return new MigratingResourcePersistence(iResourcePersistence, iResourceInfoDecoder, iResourceInfoEncoder);
    }

    private static IRenamingPersistence getRenamingPersistence(IResourcePersistence iResourcePersistence) {
        if (iResourcePersistence instanceof IRenamingPersistence) {
            IRenamingPersistence iRenamingPersistence = (IRenamingPersistence)iResourcePersistence;
            return iRenamingPersistence;
        }
        return new RenamingPersistenceCompat(iResourcePersistence);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrate(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = 10000;
        iProgressMonitor.beginTask("Updating persisted data...", n2);
        try {
            if (this.migrators.isEmpty()) return;
            IRenamingPersistence iRenamingPersistence = MigratingResourcePersistence.getRenamingPersistence(this.persistence);
            int n3 = n2 / this.migrators.size();
            for (Migrator migrator : this.migrators) {
                LOGGER.debug((Object)("Running migrator: " + migrator.getPrintableName()));
                try {
                    migrator.migrateResources(iRenamingPersistence, this);
                }
                catch (RuntimeException runtimeException) {
                    LOGGER.error((Object)("Resources migration failed. Persistence: " + this.persistence.getLocationURI() + ", migrator: " + migrator.getPrintableName()));
                    throw runtimeException;
                }
                iProgressMonitor.worked(n3);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    public void update(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 1000);
        try {
            this.persistence.update((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
            this.migrate((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    public DirectStreamHandle getResourceAsDirectStreamHandle(String string) {
        return DirectStreamHandleCompat.getResourceAsDirectStreamHandle(this.persistence, string);
    }

    @Override
    public InputStream getResourceAsInputStream(String string) {
        InputStream inputStream;
        block5: {
            inputStream = this.persistence.getResourceAsInputStream(string);
            if (inputStream == null || this.migrators.isEmpty()) break block5;
            for (Migrator migrator : this.migrators) {
                if (!migrator.isStreamMigrationNeeded(this, string, this)) continue;
                try {
                    inputStream = migrator.migrateInputStream(this, inputStream, string, this);
                }
                catch (RuntimeException runtimeException) {
                    LOGGER.error((Object)("Stream migration failed. Persistence: " + this.persistence.getLocationURI() + ", stream ID: " + string + ", migrator: " + migrator.getPrintableName()));
                    throw runtimeException;
                }
                if (inputStream != null) continue;
                throw new IllegalStateException("After stream migration by " + migrator + " the stream became null");
            }
        }
        return inputStream;
    }

    @Override
    public OutputStream getResourceAsOutputStream(String string) {
        this.notifyWritingResource(string);
        return this.persistence.getResourceAsOutputStream(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyWritingResource(String string) {
        if (!this.listeners.isEmpty()) {
            for (ResourcePersistenceListener resourcePersistenceListener : this.listeners) {
                resourcePersistenceListener.writingResource(this.persistence, string, this);
            }
        }
    }

    @Override
    public boolean deleteResource(String string) {
        this.notifyDeletingResource(string);
        return this.persistence.deleteResource(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyDeletingResource(String string) {
        if (!this.listeners.isEmpty()) {
            for (ResourcePersistenceListener resourcePersistenceListener : this.listeners) {
                resourcePersistenceListener.deletingResource(this.persistence, string, this);
            }
        }
    }

    @Override
    public void commit(IProgressMonitor iProgressMonitor) {
        iProgressMonitor = MonitorUtil.getNonNullMonitor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1000);
            this.notifyCommittingPersistence();
            iProgressMonitor.worked(100);
            this.persistence.commit((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 900));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyCommittingPersistence() {
        if (!this.listeners.isEmpty()) {
            for (ResourcePersistenceListener resourcePersistenceListener : this.listeners) {
                resourcePersistenceListener.committingPersistence(this.persistence, this);
            }
        }
    }

    @Override
    public URI getLocationURI() {
        return this.persistence.getLocationURI();
    }

    @Override
    public void setLocationURI(URI uRI) {
        this.persistence.setLocationURI(uRI);
    }

    @Override
    public boolean isResourcePresent(String string) {
        return this.persistence.isResourcePresent(string);
    }

    @Override
    public Set<String> getResources() {
        return this.persistence.getResources();
    }

    @Override
    public boolean isClosed() {
        return this.persistence.isClosed();
    }

    @Override
    public void close(IProgressMonitor iProgressMonitor) {
        this.persistence.close(iProgressMonitor);
    }

    @Override
    public IResourceInfoDecoder getDecoder() {
        return this.decoder;
    }

    @Override
    public IResourceInfoEncoder getEncoder() {
        return this.encoder;
    }
}

