/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.migration;

import com.nomagic.ci.persistence.local.spi.files.ReadableByteArrayOutputStream;
import com.nomagic.ci.persistence.local.spi.migration.StreamLocatorMigrator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InternalBinaryObjectMigrator {
    private static final int SIZE = 2032;
    private static String NS_PATTERN_STRING = "xmlns:binary.internal=['\"][^'\"]+['\"]";
    private static String BO_PATTERN_STRING = "<binaryObject[^/>]+xsi:type=['\"]binary\\.internal:InternalBinaryObject['\"][^/>]*/>";
    private static String FULL_BO_PATTERN_STRING = "<binaryObject[^/>]+xsi:type=['\"]binary\\.internal:InternalBinaryObject['\"](.*?)</binaryObject>";
    private final Pattern internalBoPattern = Pattern.compile(String.valueOf(NS_PATTERN_STRING) + "|" + BO_PATTERN_STRING + "|" + FULL_BO_PATTERN_STRING, 42);
    private final Pattern xmiIDPattern = Pattern.compile("<binaryObject[^/>]+xmi.id=['\"]([^'\"]+)['\"]", 42);
    private final Pattern locatorIDPattern = Pattern.compile("<locator[^/>]+href=['\"][^#'\"/>]+#([^'\"/>]+)['\"]", 42);

    public InputStream migrate(InputStream inputStream) {
        return new MigrationInputStream(inputStream, 2032);
    }

    private int migrate(CharSequence charSequence, StringBuffer stringBuffer) {
        Matcher matcher = this.internalBoPattern.matcher(charSequence);
        int n2 = 0;
        while (matcher.find()) {
            String string = matcher.group();
            if (string.startsWith("<binaryObject")) {
                String string2;
                String string3 = null;
                Matcher matcher2 = this.locatorIDPattern.matcher(string);
                if (matcher2.find()) {
                    string2 = matcher2.group(1);
                    string3 = StreamLocatorMigrator.migrateBinaryStreamID(string2);
                }
                string2 = null;
                Matcher matcher3 = this.xmiIDPattern.matcher(string);
                if (matcher3.find()) {
                    string2 = matcher3.group(1);
                }
                if (string2 != null) {
                    StringBuilder stringBuilder = new StringBuilder("<binaryObject");
                    stringBuilder.append(" xmi:id='").append(string2).append("' xsi:type='").append("binary:StreamIdentityBinaryObject").append("'");
                    if (string3 != null) {
                        stringBuilder.append(" streamContentID='").append(string3).append("'");
                    }
                    stringBuilder.append("/>");
                    matcher.appendReplacement(stringBuffer, stringBuilder.toString());
                } else {
                    matcher.appendReplacement(stringBuffer, string);
                }
            } else {
                matcher.appendReplacement(stringBuffer, "xmlns:binary='http://www.nomagic.com/ns/cameo/client/binary/1.0'");
            }
            n2 = matcher.end();
        }
        return n2;
    }

    public class MigrationInputStream
    extends InputStream {
        private final Charset CHARSET = Charset.forName("UTF-8");
        private final int stepSize;
        private final InputStream in;
        private final Reader reader;
        private final StringBuffer inBuf;
        private final ReadableByteArrayOutputStream out;
        private final OutputStreamWriter writer;
        private final StringBuffer outBuf;

        public MigrationInputStream(InputStream inputStream, int n2) {
            this.stepSize = n2;
            this.in = inputStream;
            this.reader = new BufferedReader(new InputStreamReader(inputStream, this.CHARSET), this.stepSize * 3);
            this.inBuf = new StringBuffer(this.stepSize * 2);
            this.out = new ReadableByteArrayOutputStream(this.stepSize * 2);
            this.writer = new OutputStreamWriter((OutputStream)this.out, this.CHARSET);
            this.outBuf = new StringBuffer(this.stepSize * 2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n2 < 0) throw new IndexOutOfBoundsException();
            if (n3 < 0) throw new IndexOutOfBoundsException();
            if (n3 > byArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            int n4 = 0;
            do {
                int n5 = 0;
                while ((n5 = this.out.read(byArray, n2 + n4, n3 - n4)) > 0) {
                    n4 += n5;
                }
                if (this.out.getUnreadSize() != 0) continue;
                this.refill();
            } while (n4 < n3 && this.out.getUnreadSize() > 0);
            if (n4 <= 0) return -1;
            int n6 = n4;
            return n6;
        }

        @Override
        public int read() throws IOException {
            if (this.out.getUnreadSize() <= 0) {
                this.refill();
            }
            if (this.out.getUnreadSize() <= 0) {
                return -1;
            }
            return this.out.read();
        }

        @Override
        public int available() throws IOException {
            return this.in.available() + this.out.getUnreadSize();
        }

        private void refill() throws IOException {
            block5: {
                block4: {
                    this.inBuf.setLength(0);
                    this.outBuf.setLength(0);
                    this.reader.mark(this.stepSize * 2 + 1);
                    this.read(this.reader, this.stepSize * 2, this.inBuf);
                    this.reader.reset();
                    int n2 = InternalBinaryObjectMigrator.this.migrate(this.inBuf, this.outBuf);
                    Reader reader = this.reader;
                    int n3 = n2 > 0 ? n2 : this.stepSize;
                    reader.skip(n3);
                    if (n2 <= 0) break block4;
                    this.write(this.outBuf, 0, this.outBuf.length(), this.writer);
                    break block5;
                }
                this.write(this.inBuf, 0, this.stepSize, this.writer);
            }
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            try {
                this.reader.close();
            }
            finally {
                this.in.close();
            }
        }

        private void read(Reader reader, int n2, StringBuffer stringBuffer) throws IOException {
            char[] cArray = new char[n2];
            int n3 = reader.read(cArray);
            if (n3 > 0) {
                stringBuffer.append(cArray, 0, n3);
            }
        }

        private void write(StringBuffer stringBuffer, int n2, int n3, Writer writer) throws IOException {
            block2: {
                block3: {
                    if (n2 >= stringBuffer.length()) break block2;
                    if (n3 <= stringBuffer.length()) break block3;
                    n3 = stringBuffer.length();
                }
                writer.append(stringBuffer, n2, n3);
            }
        }
    }
}

