/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.migration;

import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.spi.files.IRenamingPersistence;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.migration.Migrator;
import com.nomagic.ci.persistence.local.spi.migration.ResourcePersistenceContext;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CorruptedMountedSharePointMigrator
implements Migrator {
    private static final String MOUNT_POINT_START = "<mountPoints ";
    private static final String MOUNT_POINT_END = "</mountPoints>";
    private static final String IMMEDIATE_END = "/>";
    private static final String MOUNTED_SHARE_POINT_ATTRIBUTE = "mountedSharePoint=\"";
    private static final String MOUNTED_POINT_ATTRIBUTE = "mountedPoint=\"";

    @Override
    public String getPrintableName() {
        return "Corrupted Mounted Share Points Migrator";
    }

    @Override
    public void migrateResources(IRenamingPersistence iRenamingPersistence, ResourcePersistenceContext resourcePersistenceContext) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isStreamMigrationNeeded(IResourcePersistence iResourcePersistence, String string, ResourcePersistenceContext resourcePersistenceContext) {
        IResourceInfoDecoder iResourceInfoDecoder = resourcePersistenceContext.getDecoder();
        ResourceInfo resourceInfo = iResourceInfoDecoder.getResourceInfo(string);
        if (resourceInfo != null) {
            String string2 = resourceInfo.getNamespace();
            String string3 = resourceInfo.getResourceName();
            if ("proxy".equals(string2) && string3 != null && string3.contains("com.nomagic.ci.metamodel") || "com.nomagic.ci.metamodel".equals(string2) && "project".equals(string3)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public InputStream migrateInputStream(IResourcePersistence iResourcePersistence, InputStream inputStream, String string, ResourcePersistenceContext resourcePersistenceContext) {
        try {
            StringBuilder stringBuilder = FileUtil.readText(inputStream);
            this.processMountPoints(stringBuilder);
            return new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            throw new PersistenceRuntimeException((Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processMountPoints(StringBuilder stringBuilder) {
        int n2 = stringBuilder.indexOf(MOUNT_POINT_START);
        while (n2 != -1) {
            int n3 = stringBuilder.indexOf(MOUNT_POINT_START, n2 + 1);
            int n4 = stringBuilder.indexOf(IMMEDIATE_END, n2);
            int n5 = stringBuilder.indexOf(MOUNT_POINT_END, n2);
            if (n4 == -1 && n5 == -1) {
                throw new IllegalStateException("mount point without end");
            }
            boolean bl = n4 != -1 && (n5 == -1 || n3 != -1 && n5 > n3);
            int n6 = bl ? n4 + IMMEDIATE_END.length() : n5 + MOUNT_POINT_END.length();
            if (this.isMountPointCurrupted(stringBuilder, n2, n6)) {
                stringBuilder.replace(n2, n6, "");
                if (n3 != -1) {
                    n3 -= n6 - n2;
                }
            }
            n2 = n3;
        }
    }

    private boolean isMountPointCurrupted(StringBuilder stringBuilder, int n2, int n3) {
        String string = stringBuilder.substring(n2, n3);
        int n4 = string.indexOf(MOUNTED_SHARE_POINT_ATTRIBUTE);
        if (n4 != -1) {
            return true;
        }
        int n5 = string.indexOf(MOUNTED_POINT_ATTRIBUTE);
        if (n5 != -1) {
            return true;
        }
        return false;
    }
}

