/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.migration;

import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.spi.files.BinaryStreamContainer;
import com.nomagic.ci.persistence.local.spi.files.IRenamingPersistence;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoEncoder;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.migration.AbstractStaticDecompositionMigrator;
import com.nomagic.ci.persistence.local.spi.migration.InternalBinaryObjectMigrator;
import com.nomagic.ci.persistence.local.spi.migration.ResourcePersistenceContext;
import com.nomagic.ci.persistence.local.spi.migration.ResourcePersistenceListener;
import com.nomagic.ci.persistence.local.spi.migration.StreamLocatorMigrator;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BinaryResourcesMigrator
extends AbstractStaticDecompositionMigrator
implements ResourcePersistenceListener {
    private static final String MIGRATION_STATE = "BinaryMigrationState.properties";
    private final InternalBinaryObjectMigrator migrator = new InternalBinaryObjectMigrator();
    private final Properties binaryMigrationState = new Properties();
    private StreamLocatorMigrator loMigrator = null;

    public BinaryResourcesMigrator() {
        super("Binary Resources Migrator");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void migrateResources(IRenamingPersistence var1_1, ResourcePersistenceContext var2_2) {
        block10: {
            try {
                block11: {
                    var3_3 = var2_2.getDecoder();
                    var4_5 = var2_2.getEncoder();
                    this.binaryMigrationState.clear();
                    var5_6 = var1_1.getResources();
                    if (var5_6.contains("Binaries.properties")) break block11;
                    this.loMigrator = new StreamLocatorMigrator();
                    super.migrateResources(var1_1, var2_2);
                    this.renameBinaryResources(var1_1);
                    this.buildIndex(var1_1, var4_5);
                    var7_7 = var5_6.iterator();
                    if (true) ** GOTO lbl28
                }
                if (var5_6.contains("BinaryMigrationState.properties")) {
                    this.binaryMigrationState.load(var1_1.getResourceAsInputStream("BinaryMigrationState.properties"));
                    for (String var6_10 : new ArrayList<String>(this.binaryMigrationState.stringPropertyNames())) {
                        if (var5_6.contains(var6_10)) continue;
                        this.binaryMigrationState.remove(var6_10);
                    }
                }
                break block10;
            }
            catch (IOException var3_4) {
                throw new PersistenceRuntimeException((Throwable)var3_4);
            }
            do {
                if ((var8_11 = var3_3.getResourceInfo(var6_9 = var7_7.next())) == null || !this.needsStreamLocatorMigration(var8_11) && !this.needsInternalBoMigration(var8_11)) continue;
                this.binaryMigrationState.setProperty(var6_9, Boolean.FALSE.toString());
lbl28:
                // 3 sources

            } while (var7_7.hasNext());
        }
        this.storeBinaryMigrationState(var1_1);
    }

    @Override
    protected InputStream doMigrate(InputStream inputStream) {
        try {
            return this.loMigrator.migrate(inputStream);
        }
        catch (IOException iOException) {
            throw new PersistenceRuntimeException((Throwable)iOException);
        }
    }

    @Override
    protected boolean needsMigration(IRenamingPersistence iRenamingPersistence, ResourcePersistenceContext resourcePersistenceContext) {
        return true;
    }

    @Override
    public boolean isStreamMigrationNeeded(IResourcePersistence iResourcePersistence, String string, ResourcePersistenceContext resourcePersistenceContext) {
        return this.isBinaryMigrationRequired(string);
    }

    @Override
    public InputStream migrateInputStream(IResourcePersistence iResourcePersistence, InputStream inputStream, String string, ResourcePersistenceContext resourcePersistenceContext) {
        block3: {
            ResourceInfo resourceInfo;
            block4: {
                IResourceInfoDecoder iResourceInfoDecoder = resourcePersistenceContext.getDecoder();
                resourceInfo = iResourceInfoDecoder.getResourceInfo(string);
                if (resourceInfo == null) break block3;
                if (!this.needsStreamLocatorMigration(resourceInfo)) break block4;
                inputStream = this.migrateStreamLocator(inputStream);
                break block3;
            }
            if (this.needsInternalBoMigration(resourceInfo)) {
                inputStream = this.migrateInternalBo(inputStream);
            }
        }
        return inputStream;
    }

    @Override
    public void writingResource(IResourcePersistence iResourcePersistence, String string, ResourcePersistenceContext resourcePersistenceContext) {
        this.setBinaryMigrationNotRequired(iResourcePersistence, string);
    }

    @Override
    public void deletingResource(IResourcePersistence iResourcePersistence, String string, ResourcePersistenceContext resourcePersistenceContext) {
        this.setBinaryMigrationNotRequired(iResourcePersistence, string);
    }

    @Override
    public void committingPersistence(IResourcePersistence iResourcePersistence, ResourcePersistenceContext resourcePersistenceContext) {
        this.storeBinaryMigrationState(iResourcePersistence);
    }

    private void setBinaryMigrationNotRequired(IResourcePersistence iResourcePersistence, String string) {
        if (this.binaryMigrationState.remove(string) != null) {
            this.storeBinaryMigrationState(iResourcePersistence);
        }
    }

    private InputStream migrateInternalBo(InputStream inputStream) {
        return this.migrator.migrate(inputStream);
    }

    private InputStream migrateStreamLocator(InputStream inputStream) {
        try {
            return new StreamLocatorMigrator().migrate(inputStream);
        }
        catch (IOException iOException) {
            throw new PersistenceRuntimeException((Throwable)iOException);
        }
    }

    private boolean isBinaryMigrationRequired(String string) {
        return this.binaryMigrationState.containsKey(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean needsStreamLocatorMigration(ResourceInfo resourceInfo) {
        String string = resourceInfo.getNamespace();
        String string2 = resourceInfo.getResourceName();
        return string.equals("proxy") && string2.contains("com.nomagic.ci.metamodel");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildIndex(IResourcePersistence iResourcePersistence, IResourceInfoEncoder iResourceInfoEncoder) throws IOException {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        Map<ResourceInfo, Set<String>> map = this.loMigrator.getStreamsLocation();
        for (Map.Entry<ResourceInfo, Set<String>> entry : map.entrySet()) {
            Set<String> set = entry.getValue();
            ResourceInfo resourceInfo = entry.getKey();
            String string = iResourceInfoEncoder.getStreamId(resourceInfo);
            hashMap.put(string, set);
        }
        BinaryStreamContainer.writeIndex(hashMap, iResourcePersistence);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean needsInternalBoMigration(ResourceInfo resourceInfo) {
        String string = resourceInfo.getNamespace();
        if (!string.equals("proxy")) {
            if (!string.startsWith("com.nomagic.")) return false;
            if ("com.nomagic.ci.metamodel".equals(string)) return false;
            return true;
        }
        String string2 = resourceInfo.getResourceName();
        if (!string2.contains("com.nomagic.ci.metamodel")) return true;
        return false;
    }

    private void storeBinaryMigrationState(IResourcePersistence iResourcePersistence) {
        block8: {
            try {
                iResourcePersistence.deleteResource(MIGRATION_STATE);
                if (this.binaryMigrationState.isEmpty()) break block8;
                OutputStream outputStream = null;
                try {
                    outputStream = iResourcePersistence.getResourceAsOutputStream(MIGRATION_STATE);
                    this.binaryMigrationState.store(outputStream, null);
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new PersistenceRuntimeException((Throwable)iOException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renameBinaryResources(IRenamingPersistence iRenamingPersistence) throws IOException {
        Set<Map.Entry<String, String>> set = this.loMigrator.getStreamsToRename().entrySet();
        for (Map.Entry<String, String> entry : set) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            iRenamingPersistence.renameResource(string, string2);
        }
    }
}

