/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.migration;

import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.spi.files.IRenamingPersistence;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoEncoder;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.migration.Migrator;
import com.nomagic.ci.persistence.local.spi.migration.ResourcePersistenceContext;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public abstract class AbstractStaticDecompositionMigrator
implements Migrator {
    private String printableName;

    public AbstractStaticDecompositionMigrator(String string) {
        this.printableName = string;
    }

    @Override
    public String getPrintableName() {
        return this.printableName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void migrateResources(IRenamingPersistence iRenamingPersistence, ResourcePersistenceContext resourcePersistenceContext) {
        IResourceInfoEncoder iResourceInfoEncoder = resourcePersistenceContext.getEncoder();
        String string = this.getDecompositionModelStreamID(iResourceInfoEncoder);
        if (!iRenamingPersistence.getResources().contains(string) || !this.needsMigration(iRenamingPersistence, resourcePersistenceContext)) return;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                InputStream inputStream = iRenamingPersistence.getResourceAsInputStream(string);
                try {
                    this.migrateDecomposition(iRenamingPersistence, string, inputStream);
                    if (inputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (inputStream == null) throw throwable2;
                    inputStream.close();
                    throw throwable2;
                }
                inputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new PersistenceRuntimeException((Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateDecomposition(IRenamingPersistence iRenamingPersistence, String string, InputStream inputStream) throws IOException {
        if (inputStream == null) return;
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            InputStream inputStream2 = this.doMigrate(inputStream);
            try {
                try (OutputStream outputStream = iRenamingPersistence.getResourceAsOutputStream(string);){
                    if (inputStream2 == null) {
                        throw new IllegalStateException("After decomposition stream migration by " + this + " the stream became null");
                    }
                    FileUtil.copy(inputStream2, outputStream, -1L);
                }
                if (inputStream2 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream2 == null) throw throwable;
                inputStream2.close();
                throw throwable;
            }
            inputStream2.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    protected abstract boolean needsMigration(IRenamingPersistence var1, ResourcePersistenceContext var2);

    @Nonnull
    protected abstract InputStream doMigrate(InputStream var1);

    private String getDecompositionModelStreamID(IResourceInfoEncoder iResourceInfoEncoder) {
        return iResourceInfoEncoder.getStreamId(new ResourceInfo(null, "com.nomagic.ci.metamodel", "project"));
    }

    @Override
    public boolean isStreamMigrationNeeded(IResourcePersistence iResourcePersistence, String string, ResourcePersistenceContext resourcePersistenceContext) {
        return false;
    }

    @Override
    public InputStream migrateInputStream(IResourcePersistence iResourcePersistence, InputStream inputStream, String string, ResourcePersistenceContext resourcePersistenceContext) {
        return null;
    }
}

