/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.lock;

import com.nomagic.ci.metamodel.local.project.LocalDataSection;
import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.local.internal.r;
import com.nomagic.ci.persistence.local.sharing.ResharingType;
import com.nomagic.ci.persistence.local.sharing.Share;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusSupport;
import com.nomagic.ci.persistence.local.spi.util.MonitorUtil;
import com.nomagic.ci.persistence.spi.lock.DecompositionLockHelper;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class ProjectSharingManagerWithLockingSupport
extends r {
    public ProjectSharingManagerWithLockingSupport(AbstractProject abstractProject, ServiceBusSupport serviceBusSupport) {
        super(abstractProject, serviceBusSupport);
    }

    @Override
    protected void interceptShare(@Nonnull Share share, @CheckForNull IProgressMonitor iProgressMonitor) {
        if (!this.isPersonalResource(share.getResource())) {
            DecompositionLockHelper.checkDecompositionLock((IProject)this.getProject(), (boolean)true);
        }
    }

    @Override
    protected void interceptUnhare(@Nonnull URI uRI, @CheckForNull IProgressMonitor iProgressMonitor) {
        if (!this.isPersonalResource(uRI)) {
            DecompositionLockHelper.checkDecompositionLock((IProject)this.getProject(), (boolean)true);
        }
    }

    @Override
    protected void interceptUpdateShare(@Nonnull URI uRI, @Nonnull Map<String, String> map, @CheckForNull IProgressMonitor iProgressMonitor) {
        if (!this.isPersonalResource(uRI)) {
            DecompositionLockHelper.checkDecompositionLock((IProject)this.getProject(), (boolean)true);
        }
    }

    @Override
    protected void interceptReshare(ProjectUsage projectUsage, boolean bl, IProgressMonitor iProgressMonitor) {
        iProgressMonitor = MonitorUtil.getNonNullMonitor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1000);
            if (!projectUsage.isAutomatic() && !bl) {
                DecompositionLockHelper.checkDecompositionLock((IProject)this.getProject(), (boolean)true);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    protected void interceptUnreshare(ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) {
        iProgressMonitor = MonitorUtil.getNonNullMonitor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1000);
            if (!projectUsage.isAutomatic() && !projectUsage.isResharedAutomatically()) {
                DecompositionLockHelper.checkDecompositionLock((IProject)this.getProject(), (boolean)true);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    protected void interceptSetResharingType(ProjectUsage projectUsage, ResharingType resharingType, @CheckForNull IProgressMonitor iProgressMonitor) {
        iProgressMonitor = MonitorUtil.getNonNullMonitor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1000);
            if (!projectUsage.isAutomatic()) {
                DecompositionLockHelper.checkDecompositionLock((IProject)this.getProject(), (boolean)true);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private boolean isPersonalResource(URI uRI) {
        LocalDataSection localDataSection = this.a(uRI);
        return localDataSection.getBelongsTo() != null;
    }
}

