/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.lock;

import com.nomagic.ci.metamodel.local.project.SharePoint;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.LockAcquisitionException;
import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.importers.SharePointData;
import com.nomagic.ci.persistence.local.internal.m.b;
import com.nomagic.ci.persistence.local.internal.p;
import com.nomagic.ci.persistence.local.lock.ILocalLockFailureHandler;
import com.nomagic.ci.persistence.local.mounting.IMountingProjectFeatureHandler;
import com.nomagic.ci.persistence.local.proxy.LocalProxyService;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IProjectAccessModeContributor;
import com.nomagic.ci.persistence.local.spi.IProjectAccessModeController;
import com.nomagic.ci.persistence.local.spi.InvalidProjectObjectException;
import com.nomagic.ci.persistence.local.spi.util.MonitorUtil;
import com.nomagic.ci.persistence.lock.DecompositionLockException;
import com.nomagic.ci.persistence.lock.ILockManager;
import com.nomagic.ci.persistence.lock.ILockableProject;
import com.nomagic.ci.persistence.lock.IObjectLock;
import com.nomagic.ci.persistence.spi.lock.DecompositionLockHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ObjectLevelSharingManagerWithLockingSupport
extends p
implements IProjectAccessModeContributor {
    private final IProjectAccessModeController controller;
    private boolean lockFailed = false;

    public ObjectLevelSharingManagerWithLockingSupport(AbstractProject abstractProject, IMountingProjectFeatureHandler iMountingProjectFeatureHandler) {
        super(abstractProject, iMountingProjectFeatureHandler);
        this.controller = abstractProject.getAccessModeController();
        this.controller.addContributor(this);
    }

    @Override
    protected void interceptShare(EObject eObject, Map<String, String> map, boolean bl, IProgressMonitor iProgressMonitor) throws InvalidProjectObjectException {
        iProgressMonitor = MonitorUtil.getNonNullMonitor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1500);
            DecompositionLockHelper.checkDecompositionLock((IProject)this.d(), (boolean)true);
            iProgressMonitor.worked(1000);
            b.a(eObject, this.d(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    protected void interceptUnshare(EObject eObject, IProgressMonitor iProgressMonitor) throws InvalidProjectObjectException {
        iProgressMonitor = MonitorUtil.getNonNullMonitor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1500);
            DecompositionLockHelper.checkDecompositionLock((IProject)this.d(), (boolean)true);
            iProgressMonitor.worked(1000);
            b.a(eObject, this.d(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    protected void interceptUpdateSharePoint(EObject eObject, Map<String, String> map, IProgressMonitor iProgressMonitor) throws InvalidProjectObjectException {
        iProgressMonitor = MonitorUtil.getNonNullMonitor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1500);
            DecompositionLockHelper.checkDecompositionLock((IProject)this.d(), (boolean)true);
            iProgressMonitor.worked(1000);
            b.a(eObject, this.d(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void importSharePoints(Set<SharePointData> set, IProgressMonitor iProgressMonitor) {
        boolean bl = !set.isEmpty();
        LocalProxyService localProxyService = this.d().getService(LocalProxyService.class);
        if (localProxyService != null) {
            bl = false;
            HashSet<SharePointData> hashSet = new HashSet<SharePointData>();
            for (SharePointData object2 : set) {
                EObject eObject = object2.getSharePoint();
                if (eObject == null || localProxyService.isProxy(eObject) || localProxyService.isOrphanedProxy(eObject)) continue;
                hashSet.add(object2);
            }
            Map<String, SharePoint> map = this.m();
            for (Object object3 : hashSet) {
                if (map.containsKey(((SharePointData)object3).getSharePointID()) && !((SharePointData)object3).getOverwriteExisting()) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.checkDecompositionLockAndHandle();
        }
        super.importSharePoints(set, iProgressMonitor);
    }

    @Override
    protected void prepareMergeRootObjectIntoContainer(EObject eObject) throws LockAcquisitionException {
        this.lockObjectAndHandle(eObject);
        super.prepareMergeRootObjectIntoContainer(eObject);
    }

    @Override
    protected void prepareAddSharePointToResource(EObject eObject) throws LockAcquisitionException {
        this.lockObjectAndHandle(eObject);
        super.prepareAddSharePointToResource(eObject);
    }

    @Override
    protected void prepareRemoveRootFromResourceAndDelete(EObject eObject, Resource resource) throws LockAcquisitionException {
        this.lockObjectAndHandle(eObject);
        super.prepareRemoveRootFromResourceAndDelete(eObject, resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lockObjectAndHandle(EObject eObject) throws LockAcquisitionException {
        AbstractProject abstractProject = this.d();
        ILockManager iLockManager = ((ILockableProject)abstractProject).getLockManager();
        if (iLockManager.needLock(eObject)) {
            Set set = Collections.emptySet();
            boolean bl = false;
            try {
                set = iLockManager.lock(eObject, false, null);
                bl = true;
            }
            catch (PersistenceRuntimeException persistenceRuntimeException) {
                if (!ILocalLockFailureHandler.INSTANCE.handleSharing(abstractProject, (RuntimeException)((Object)persistenceRuntimeException))) {
                    throw persistenceRuntimeException;
                }
                this.setFailed(true);
            }
            if (bl) {
                boolean bl2 = false;
                for (IObjectLock iObjectLock : set) {
                    if (iObjectLock.getSubject() != eObject) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    throw new LockAcquisitionException(Collections.singleton(eObject));
                }
            }
        }
    }

    private void checkDecompositionLockAndHandle() {
        block8: {
            AbstractProject abstractProject = this.d();
            if (abstractProject.isReadOnly()) {
                return;
            }
            try {
                DecompositionLockHelper.checkDecompositionLock((IProject)abstractProject, (boolean)true);
            }
            catch (DecompositionLockException decompositionLockException) {
                block7: {
                    if (!ILocalLockFailureHandler.INSTANCE.handleFeatureChange(abstractProject, decompositionLockException)) break block7;
                    this.setFailed(true);
                    break block8;
                }
                throw decompositionLockException;
            }
        }
    }

    private void setFailed(boolean bl) {
        this.lockFailed = bl;
        this.controller.notifyChanged(this);
    }

    @Override
    public boolean isReadOnly() {
        return this.lockFailed;
    }

    @Override
    public String getReason() {
        return "Failed to acquire decomposition lock";
    }
}

