/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.lock;

import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.features.AbstractFeatureException;
import com.nomagic.ci.persistence.features.FeatureDependencyException;
import com.nomagic.ci.persistence.local.importers.IProjectDataProvider;
import com.nomagic.ci.persistence.local.lock.ILocalLockFailureHandler;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IProjectAccessModeContributor;
import com.nomagic.ci.persistence.local.spi.IProjectAccessModeController;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusSupport;
import com.nomagic.ci.persistence.local.spi.features.LocalFeatureInitializer;
import com.nomagic.ci.persistence.spi.features.IProjectFeatureRegistry;
import com.nomagic.ci.persistence.spi.lock.FeatureChangeDecompositionLocker;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalFeatureInitializerWithLockingSupport
extends LocalFeatureInitializer
implements IProjectAccessModeContributor {
    private final IProjectAccessModeController controller;
    private boolean lockFailed = false;
    protected FeatureChangeDecompositionLocker decompositionLocker;

    public LocalFeatureInitializerWithLockingSupport(AbstractProject abstractProject, IProjectFeatureRegistry iProjectFeatureRegistry, ServiceBusSupport serviceBusSupport) {
        super(abstractProject, iProjectFeatureRegistry, serviceBusSupport);
        this.controller = abstractProject.getAccessModeController();
        this.controller.addContributor(this);
        this.decompositionLocker = new FeatureChangeDecompositionLocker(abstractProject, ILocalLockFailureHandler.INSTANCE){

            protected void lockingFailedButHandled() {
                LocalFeatureInitializerWithLockingSupport.this.setFailed(true);
            }
        };
    }

    public void install(Set<String> set, IProgressMonitor iProgressMonitor) throws AbstractFeatureException {
        this.checkLockAndHandle(set, true);
        super.install(set, iProgressMonitor);
    }

    public void uninstall(Set<String> set, IProgressMonitor iProgressMonitor) throws AbstractFeatureException {
        this.checkLockAndHandle(set, false);
        super.uninstall(set, iProgressMonitor);
    }

    @Override
    public void importFeatures(IProjectDataProvider iProjectDataProvider, boolean bl, IProgressMonitor iProgressMonitor) throws ProjectConfigurationException, FeatureDependencyException {
        if (!bl) {
            boolean bl2;
            Set<String> set;
            block7: {
                set = iProjectDataProvider.getFeatures(this.getProject());
                bl2 = false;
                if (set == null || set.isEmpty()) break block7;
                Set set2 = this.getProject().getInstalledFeatures();
                for (String string : set) {
                    if (set2.contains(string)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                this.checkLockAndHandle(set, true);
            }
        }
        super.importFeatures(iProjectDataProvider, bl, iProgressMonitor);
    }

    protected void checkLockAndHandle(Set<String> set, boolean bl) {
        this.decompositionLocker.checkAndHandle(set, bl);
    }

    private void setFailed(boolean bl) {
        this.lockFailed = bl;
        this.controller.notifyChanged(this);
    }

    @Override
    public boolean isReadOnly() {
        return this.lockFailed;
    }

    @Override
    public String getReason() {
        return "Failed to acquire decomposition lock";
    }
}

