/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.lock;

import com.nomagic.ci.metamodel.project.AbstractProjectUsage;
import com.nomagic.ci.metamodel.project.Project;
import com.nomagic.ci.persistence.DisconnectedException;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.ProjectEvent;
import com.nomagic.ci.persistence.ProjectEventType;
import com.nomagic.ci.persistence.ProjectListener;
import com.nomagic.ci.persistence.local.spi.lock.LockWrapper;
import com.nomagic.ci.persistence.lock.DecompositionLockException;
import com.nomagic.ci.persistence.lock.IDecompositionLockService;
import com.nomagic.ci.persistence.lock.ILock;
import com.nomagic.ci.persistence.lock.ILockManager;
import com.nomagic.ci.persistence.lock.IObjectLock;
import com.nomagic.ci.persistence.lock.Locking;
import com.nomagic.ci.persistence.lock.LockingException;
import com.nomagic.ci.persistence.lock.ProjectUsageLockException;
import com.nomagic.ci.persistence.services.AbstractProjectService;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.versioning.Versioning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DecompositionLockService
extends AbstractProjectService
implements IDecompositionLockService,
ProjectListener {
    private static final Logger LOGGER = Logger.getLogger(DecompositionLockService.class);
    private Map<IProject, AbstractProjectUsage> usageCache = new WeakHashMap<IProject, AbstractProjectUsage>();
    private boolean unlockOnClose = true;

    public DecompositionLockService(IProject iProject) {
        super(DecompositionLockService.checkLocable(iProject));
        iProject.addProjectListener((ProjectListener)this);
    }

    private static IProject checkLocable(IProject iProject) {
        if (!Locking.isProjectLockable((IProject)iProject)) {
            throw new IllegalArgumentException("the project does not support locking");
        }
        return iProject;
    }

    public IDecompositionLockService.IDecompositionLock lock() {
        Set set;
        ILockManager iLockManager;
        block4: {
            iLockManager = this.getLockManager();
            set = iLockManager.lock((EObject)this.getDecompositionProject(), false, null);
            if (!set.isEmpty()) break block4;
            return null;
        }
        try {
            IObjectLock iObjectLock = (IObjectLock)set.iterator().next();
            iLockManager.addLocksToUnlockAfterSave((ILock)iObjectLock);
            return new DecompositionLock((ILock<EObject>)iObjectLock);
        }
        catch (LockingException lockingException) {
            throw new DecompositionLockException(lockingException.getMessage(), (Throwable)lockingException);
        }
        catch (DisconnectedException disconnectedException) {
            throw new DecompositionLockException("Could not lock", (Throwable)disconnectedException);
        }
    }

    public void unlock() {
        this.getLockManager().unlock((EObject)this.getDecompositionProject(), false, false);
    }

    public IDecompositionLockService.IDecompositionLock getLock() {
        IObjectLock iObjectLock = this.getLockManager().getLockForObject((EObject)this.getDecompositionProject());
        if (iObjectLock == null) {
            return null;
        }
        return new DecompositionLock((ILock<EObject>)iObjectLock);
    }

    public IDecompositionLockService.IProjectUsageLock lockUsage(IProject iProject) {
        Object object;
        ILockManager iLockManager;
        block5: {
            try {
                iLockManager = this.getLockManager();
                object = iLockManager.lock((EObject)this.getUsage(iProject), false, null);
                if (!object.isEmpty()) break block5;
                return null;
            }
            catch (LockingException lockingException) {
                object = null;
                try {
                    object = this.getUsageLock(iProject);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Failed to obtain the failed to lock usage", (Throwable)exception);
                }
                throw new ProjectUsageLockException(iProject, iProject.getLocationURI(), (IDecompositionLockService.IProjectUsageLock)object, (Throwable)lockingException, lockingException.getMessage());
            }
        }
        IObjectLock iObjectLock = (IObjectLock)object.iterator().next();
        iLockManager.addLocksToUnlockAfterSave((ILock)iObjectLock);
        return new ProjectUsageLock((ILock<EObject>)iObjectLock, iProject);
    }

    public void unlockUsage(IProject iProject) {
        AbstractProjectUsage abstractProjectUsage = this.getUsage(iProject);
        this.getLockManager().unlock((EObject)abstractProjectUsage, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IDecompositionLockService.IProjectUsageLock> getUsageLocks() {
        LOGGER.debug((Object)"Getting usage locks");
        ArrayList<IDecompositionLockService.IProjectUsageLock> arrayList = new ArrayList<IDecompositionLockService.IProjectUsageLock>();
        IProjectUsageManager<?> iProjectUsageManager = this.getProjectUsageManager();
        HashSet<AbstractProjectUsage> hashSet = new HashSet<AbstractProjectUsage>(iProjectUsageManager.getProjectUsages());
        hashSet.addAll(this.usageCache.values());
        ILockManager iLockManager = this.getLockManager();
        for (AbstractProjectUsage abstractProjectUsage : hashSet) {
            IObjectLock iObjectLock = iLockManager.getLockForObject((EObject)abstractProjectUsage);
            if (iObjectLock == null) continue;
            arrayList.add(new ProjectUsageLock((ILock<EObject>)iObjectLock, iProjectUsageManager.getProject(abstractProjectUsage)));
        }
        LOGGER.debug((Object)"Finished getting usage locks");
        return arrayList;
    }

    public IDecompositionLockService.IProjectUsageLock getUsageLock(IProject iProject) {
        AbstractProjectUsage abstractProjectUsage = this.getUsage(iProject);
        IObjectLock iObjectLock = this.getLockManager().getLockForObject((EObject)abstractProjectUsage);
        ProjectUsageLock projectUsageLock = iObjectLock == null ? null : new ProjectUsageLock((ILock<EObject>)iObjectLock, iProject);
        return projectUsageLock;
    }

    private ILockManager getLockManager() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getting project " + this.getProject().getLocationURI()));
        }
        ILockManager iLockManager = Locking.getLockManager((IProject)this.getProject());
        return iLockManager;
    }

    private Project getDecompositionProject() {
        return ((IDecompositionModel)this.getProject().getService(IDecompositionModel.class)).getDecompositionProject();
    }

    private IProjectUsageManager<?> getProjectUsageManager() {
        return (IProjectUsageManager)this.getProject().getService(IProjectUsageManager.class);
    }

    private AbstractProjectUsage getUsage(IProject iProject) {
        AbstractProjectUsage abstractProjectUsage;
        block6: {
            block5: {
                abstractProjectUsage = this.getProjectUsageManager().getProjectUsage(iProject);
                if (abstractProjectUsage == null) break block5;
                this.usageCache.put(iProject, abstractProjectUsage);
                break block6;
            }
            abstractProjectUsage = this.usageCache.get(iProject);
        }
        if (abstractProjectUsage == null) {
            throw new PersistenceRuntimeException("Project usage not found. URI: " + iProject);
        }
        return abstractProjectUsage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AbstractProjectUsage> findDuplicateUsages() {
        HashSet<URI> hashSet = new HashSet<URI>();
        ArrayList<AbstractProjectUsage> arrayList = new ArrayList<AbstractProjectUsage>();
        EList eList = this.getDecompositionProject().getProjectUsages();
        for (AbstractProjectUsage abstractProjectUsage : eList) {
            if (hashSet.add(abstractProjectUsage.getUsedProjectURI())) continue;
            for (AbstractProjectUsage abstractProjectUsage2 : eList) {
                if (abstractProjectUsage2 == abstractProjectUsage || !this.areUsagesEqual(abstractProjectUsage2, abstractProjectUsage)) continue;
                arrayList.add(abstractProjectUsage2);
            }
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areUsagesEqual(AbstractProjectUsage abstractProjectUsage, AbstractProjectUsage abstractProjectUsage2) {
        Project project2 = abstractProjectUsage.getUsedProject();
        Project project = abstractProjectUsage2.getUsedProject();
        if (project2 != null && project != null) {
            if (project2.eIsProxy()) return EcoreUtil.getURI((EObject)project2).equals((Object)EcoreUtil.getURI((EObject)project));
            if (project.eIsProxy()) return EcoreUtil.getURI((EObject)project2).equals((Object)EcoreUtil.getURI((EObject)project));
            return project2.equals(project);
        }
        URI uRI2 = abstractProjectUsage.getUsedProjectURI();
        URI uRI = abstractProjectUsage2.getUsedProjectURI();
        if (uRI2 != null) {
            boolean bl = uRI2.equals((Object)uRI);
            return bl;
        }
        if (uRI != null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolveDuplicateUsages(List<AbstractProjectUsage> list) {
        for (AbstractProjectUsage abstractProjectUsage : list) {
            LOGGER.debug((Object)("Resolving duplicate project usage by removing: " + abstractProjectUsage));
            EcoreUtil.remove((EObject)abstractProjectUsage);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notify(ProjectEvent projectEvent) {
        if (projectEvent.getEventType() == ProjectEventType.PRE_CLOSE) {
            if (Versioning.isHistorical((IProject)this.getProject())) {
                return;
            }
            ILockManager iLockManager = this.getLockManager();
            Collection collection = iLockManager.getLocksToUnlockAfterSave();
            for (ILock iLock : collection) {
                if (!(iLock instanceof IObjectLock)) continue;
                EObject eObject = (EObject)((IObjectLock)iLock).getSubject();
                if (!(eObject instanceof Project) || !this.isUnlockDecompositionOnClose()) {
                    try {
                        if (!(eObject instanceof AbstractProjectUsage)) continue;
                    }
                    catch (DisconnectedException disconnectedException) {
                        throw disconnectedException;
                    }
                    catch (DisconnectedException disconnectedException) {
                        throw disconnectedException;
                    }
                }
                iLockManager.unlock(iLock);
                continue;
                catch (IllegalArgumentException illegalArgumentException) {
                    throw illegalArgumentException;
                }
                catch (DisconnectedException disconnectedException) {
                    LOGGER.debug((Object)("Could not unlock" + iLock + "witch locked " + iLock.getSubject()), (Throwable)disconnectedException);
                }
            }
        }
    }

    public void setUnlockDecompositionOnClose(boolean bl) {
        this.unlockOnClose = bl;
    }

    public boolean isUnlockDecompositionOnClose() {
        return this.unlockOnClose;
    }

    private class DecompositionLock
    extends LockWrapper<IProject, EObject>
    implements IDecompositionLockService.IDecompositionLock {
        public DecompositionLock(ILock<EObject> iLock) {
            super(iLock);
        }

        public IProject getSubject() {
            return DecompositionLockService.this.getProject();
        }
    }

    private class ProjectUsageLock
    extends LockWrapper<IProject, EObject>
    implements IDecompositionLockService.IProjectUsageLock {
        private IProject project;

        public ProjectUsageLock(ILock<EObject> iLock, IProject iProject) {
            super(iLock);
            this.project = iProject;
        }

        public IProject getSubject() {
            return this.project;
        }
    }
}

