/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.localproject;

import com.nomagic.ci.persistence.local.spi.resources.LocalURIMapper;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public class MappedURIConverter
extends ExtensibleURIConverterImpl {
    private Map<String, Map.Entry<URIHandler, URI>> handlerMap = new HashMap<String, Map.Entry<URIHandler, URI>>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addHandlerMapping(String string, URIHandler uRIHandler, URI uRI) {
        if (string == null || uRIHandler == null) {
            throw new IllegalArgumentException();
        }
        Map.Entry<URIHandler, URI> entry = this.handlerMap.get(string);
        if (entry != null) {
            throw new IllegalStateException("The handler already exists for " + string + ". It was added for project with uri " + entry.getValue());
        }
        this.handlerMap.put(string, new AbstractMap.SimpleImmutableEntry<URIHandler, URI>(uRIHandler, uRI));
    }

    public void removeHandlerMapping(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.handlerMap.remove(string);
    }

    public URIHandler getURIHandler(URI uRI) {
        String string = LocalURIMapper.parseLocalProjectID(uRI);
        Map.Entry<URIHandler, URI> entry = this.handlerMap.get(string);
        if (entry != null) {
            return entry.getKey();
        }
        return super.getURIHandler(uRI);
    }
}

