/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.localproject;

import com.nomagic.ci.metamodel.local.project.LocalProject;
import com.nomagic.ci.metamodel.local.project.LocalProjectFeature;
import com.nomagic.ci.metamodel.project.Project;
import com.nomagic.ci.metamodel.project.util.DecompositionModelUtil;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.local.proxy.resource.IResolveBarrier;
import com.nomagic.ci.persistence.local.proxy.resource.ResolvingResourceSet;
import com.nomagic.ci.persistence.local.spi.IProjectInternal;
import com.nomagic.ci.persistence.local.spi.IResourceUriMapperService;
import com.nomagic.ci.persistence.local.spi.decomposition.LocalDecompositionModel;
import com.nomagic.ci.persistence.local.spi.resources.LocalURIMapper;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import com.nomagic.ci.persistence.spi.IAttachedProjectStateService;
import com.nomagic.ci.persistence.spi.ProjectState;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import org.eclipse.emf.common.util.URI;

public class LocalResolveBarrier
implements IResolveBarrier {
    private final IPrimaryProject primary;
    private final ResolvingResourceSet resourceSet;

    public LocalResolveBarrier(IPrimaryProject iPrimaryProject, ResolvingResourceSet resolvingResourceSet) {
        this.primary = iPrimaryProject;
        this.resourceSet = resolvingResourceSet;
    }

    @Override
    public boolean isForbidden(URI uRI, boolean bl) {
        URI uRI2 = uRI.trimFragment();
        if (LocalURIMapper.isLocalResourceURI(uRI2)) {
            IProject iProject;
            URI uRI3 = uRI2;
            URI uRI4 = this.resourceSet.getURIRemapper().remap(uRI2);
            if (uRI4 != null) {
                uRI3 = uRI4;
            }
            if ((iProject = LocalProjectUtil.getProject(this.primary, uRI3)) == null) {
                return true;
            }
            if (iProject instanceof IAttachedProject && ((IAttachedProjectStateService)iProject.getService(IAttachedProjectStateService.class)).getProjectState() == ProjectState.Created) {
                return true;
            }
            IResourceUriMapperService iResourceUriMapperService = (IResourceUriMapperService)iProject.getService(IResourceUriMapperService.class);
            ResourceInfo resourceInfo = iResourceUriMapperService.getResourceInfo(uRI3);
            if (resourceInfo != null) {
                Object object;
                String string = resourceInfo.getNamespace();
                String string2 = resourceInfo.getResourceName();
                if ("com.nomagic.ci.metamodel".equals(string) && "project".equals(string2)) {
                    return false;
                }
                LocalProject localProject = ((IProjectInternal)iProject).getPersistableServices().iterator();
                while (localProject.hasNext()) {
                    object = localProject.next();
                    if (!object.getNamespace().equals(string)) continue;
                    return false;
                }
                object = (LocalDecompositionModel)iProject.getService(IDecompositionModel.class);
                if (object.isAvailable() && (localProject = object.getDecompositionProject()) != null) {
                    LocalProjectFeature localProjectFeature = (LocalProjectFeature)DecompositionModelUtil.findProjectFeature((Project)localProject, (String)string);
                    return localProjectFeature == null;
                }
            }
            return true;
        }
        return false;
    }
}

