/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.localproject;

import com.nomagic.ci.metamodel.local.project.ProjectPackage;
import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.metamodel.project.AbstractProjectUsage;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.local.ProjectRepositoryRegistry;
import com.nomagic.ci.persistence.local.decomposition.LocalDecompositionDescriptor;
import com.nomagic.ci.persistence.local.spi.decomposition.IAttachedProjectResolver;
import com.nomagic.ci.persistence.local.spi.decomposition.LocalDecompositionDescriptorService;
import com.nomagic.ci.persistence.local.spi.localproject.LocalPrimaryProject;
import com.nomagic.ci.persistence.local.spi.resources.LocalURIMapper;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.spi.decomposition.DecompositionDescriptorService;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.util.ProjectUtil;
import com.nomagic.ci.persistence.versioning.IVersionDescriptor;
import javax.annotation.CheckForNull;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class LocalProjectResolver
implements IAttachedProjectResolver {
    private static final Logger LOGGER = Logger.getLogger(LocalProjectResolver.class);
    public static final String PROJECT_ID_CUSTOM_OPTION = "LOCAL_PROJECT_ID";
    private IProject project;

    public LocalProjectResolver(IProject iProject) {
        this.project = iProject;
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    @CheckForNull
    public URI getProjectURI(ProjectUsage projectUsage) {
        URI uRI = projectUsage.getResolvedProjectURI();
        if (uRI == null) {
            uRI = this.resolve(projectUsage);
            if (this.shouldCacheResolvedURI(projectUsage)) {
                projectUsage.setResolvedProjectURI(uRI);
            }
        }
        return this.resolve(projectUsage);
    }

    protected boolean shouldCacheResolvedURI(ProjectUsage projectUsage) {
        if ((this.project instanceof IPrimaryProject || projectUsage.isReshared()) && !LocalProjectUtil.isProjectUsageManual((IProject)this.project, (AbstractProjectUsage)projectUsage)) {
            IProjectUsageManager iProjectUsageManager = (IProjectUsageManager)this.project.getService(IProjectUsageManager.class);
            return iProjectUsageManager.getProject((AbstractProjectUsage)projectUsage) != null;
        }
        return true;
    }

    @CheckForNull
    protected URI resolve(ProjectUsage projectUsage) {
        IProject iProject = this.resolveProject(projectUsage);
        if (iProject != null) {
            return iProject.getLocationURI();
        }
        return this.resolveProjectURI(projectUsage);
    }

    @CheckForNull
    protected URI resolveProjectURI(ProjectUsage projectUsage) {
        return projectUsage.getUsedProjectURI();
    }

    protected IProject resolveProject(ProjectUsage projectUsage) {
        IProject iProject = null;
        String string = this.getUsedProjectID(projectUsage);
        if (string != null) {
            IPrimaryProject iPrimaryProject = ProjectUtil.getPrimaryProject((IProject)this.getProject());
            iProject = ProjectUtil.findProjectByID((IPrimaryProject)iPrimaryProject, (String)string);
        }
        return iProject;
    }

    protected String extractProjectID(URI uRI) {
        ProjectRepositoryRegistry projectRepositoryRegistry = ProjectRepositoryRegistry.getInstance();
        IProjectRepository iProjectRepository = projectRepositoryRegistry.getProjectRepository(uRI);
        if (iProjectRepository != null) {
            try {
                LocalDecompositionDescriptor localDecompositionDescriptor;
                LocalDecompositionDescriptorService localDecompositionDescriptorService = (LocalDecompositionDescriptorService)iProjectRepository.getService(DecompositionDescriptorService.class);
                if (localDecompositionDescriptorService != null && (localDecompositionDescriptor = localDecompositionDescriptorService.getDecompositionDescriptor(uRI, false, null)) != null) {
                    return localDecompositionDescriptor.getId();
                }
            }
            catch (PersistenceException persistenceException) {
                LOGGER.info((Object)("Error getting decomposition descritori for " + uRI), (Throwable)persistenceException);
            }
        }
        return null;
    }

    protected String getUsedProjectID(ProjectUsage projectUsage) {
        String string;
        String string2 = LocalProjectResolver.extractUsedProjectID(projectUsage);
        if (string2 != null && (string = this.getRemappedProjectID(string2)) != null) {
            string2 = string;
        }
        return string2;
    }

    protected String getRemappedProjectID(String string) {
        LocalPrimaryProject localPrimaryProject = (LocalPrimaryProject)ProjectUtil.getPrimaryProject((IProject)this.project);
        if (localPrimaryProject != null) {
            return localPrimaryProject.getProjectIDMap().get(string);
        }
        return null;
    }

    @Override
    public IVersionDescriptor getProjectVersion(ProjectUsage projectUsage) {
        return null;
    }

    @Override
    public void updateUsage(ProjectUsage projectUsage, IProject iProject) {
        this.updateUsageProjectID(projectUsage, iProject);
        this.updateUsageLocationURI(projectUsage, iProject);
    }

    protected void updateUsageProjectID(ProjectUsage projectUsage, IProject iProject) {
        String string = iProject.getProjectID();
        if (string != null) {
            EMap eMap = projectUsage.getProperties();
            if (this.project instanceof IPrimaryProject || !eMap.containsKey((Object)PROJECT_ID_CUSTOM_OPTION)) {
                eMap.put((Object)PROJECT_ID_CUSTOM_OPTION, (Object)string);
            }
        }
    }

    protected void updateUsageLocationURI(ProjectUsage projectUsage, IProject iProject) {
        URI uRI = iProject.getLocationURI();
        if (!uRI.equals((Object)projectUsage.getUsedProjectURI())) {
            projectUsage.setUsedProjectURI(uRI);
        }
    }

    public static String extractUsedProjectID(ProjectUsage projectUsage) {
        EObject eObject;
        String string = (String)projectUsage.getProperties().get((Object)PROJECT_ID_CUSTOM_OPTION);
        if (string == null && (eObject = (EObject)projectUsage.eGet((EStructuralFeature)ProjectPackage.eINSTANCE.getProjectUsage_UsedProject(), false)) != null) {
            URI uRI = EcoreUtil.getURI((EObject)eObject);
            string = LocalURIMapper.parseLocalProjectID(uRI);
        }
        return string;
    }

    public static String extractUsedProjectID(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration) {
        return abstractProjectAttachmentConfiguration.getCustomOptionValue(PROJECT_ID_CUSTOM_OPTION);
    }
}

