/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.localproject;

import com.nomagic.ci.metamodel.local.project.LocalProject;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProjectRepositoryType;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.ProjectAllocationException;
import com.nomagic.ci.persistence.ProjectDescriptor;
import com.nomagic.ci.persistence.ProjectOptions;
import com.nomagic.ci.persistence.decomposition.ProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.local.LocalProjectOptions;
import com.nomagic.ci.persistence.local.LocalProjectRepositoryType;
import com.nomagic.ci.persistence.local.ProjectRepositoryEventType;
import com.nomagic.ci.persistence.local.decomposition.LocalDecompositionDescriptor;
import com.nomagic.ci.persistence.local.importers.IProjectDataImporter;
import com.nomagic.ci.persistence.local.proxy.resource.impl.XMIProxySupporterResourceImpl;
import com.nomagic.ci.persistence.local.spi.DefaultProjectRepository;
import com.nomagic.ci.persistence.local.spi.IExtendedResource;
import com.nomagic.ci.persistence.local.spi.IPrimaryProjectInternal;
import com.nomagic.ci.persistence.local.spi.LocalDescriptorFactory;
import com.nomagic.ci.persistence.local.spi.decomposition.DecompositionModelService;
import com.nomagic.ci.persistence.local.spi.decomposition.IAttachedProjectResolver;
import com.nomagic.ci.persistence.local.spi.decomposition.LocalDecompositionDescriptorService;
import com.nomagic.ci.persistence.local.spi.decomposition.LocalDecompositionModel;
import com.nomagic.ci.persistence.local.spi.decomposition.UpdateForceModeProvider;
import com.nomagic.ci.persistence.local.spi.events.ComplexOperationEventsUtil;
import com.nomagic.ci.persistence.local.spi.files.AbstractLazyDirectoryProvider;
import com.nomagic.ci.persistence.local.spi.files.DirectoryProvider;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.RecoveryFileStorage;
import com.nomagic.ci.persistence.local.spi.files.RecoveryFileStorageProvider;
import com.nomagic.ci.persistence.local.spi.files.ResourceInfoEncoderDecoder;
import com.nomagic.ci.persistence.local.spi.files.SafeZipFilePersistence;
import com.nomagic.ci.persistence.local.spi.files.ZipFilePersistence;
import com.nomagic.ci.persistence.local.spi.localproject.LocalAttachedProject;
import com.nomagic.ci.persistence.local.spi.localproject.LocalPrimaryProject;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectOpenUtil;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectRepositoryMountingHelper;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectResolver;
import com.nomagic.ci.persistence.local.spi.mounting.IProjectRepositoryMountingHelper;
import com.nomagic.ci.persistence.local.util.ResourceUtil;
import com.nomagic.ci.persistence.spi.ComplexOperationContext;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.spi.decomposition.DecompositionDescriptorService;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import com.nomagic.ci.services.ServicesDiscovery;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class LocalProjectRepository
extends DefaultProjectRepository {
    private static final Logger LOGGER = Logger.getLogger(LocalProjectRepository.class);
    public static final String RESOURCE_URI_SCHEME = "local";
    public static String TEMP_DIR = LocalProjectRepository.class.getSimpleName();
    private LocalProjectRepositoryMountingHelper mountingHelper = new LocalProjectRepositoryMountingHelper();

    public LocalProjectRepository(LocalProjectRepositoryType localProjectRepositoryType) {
        super((IProjectRepositoryType)localProjectRepositoryType);
        this.initUpdateForceModeProvider();
        this.initDecompositionDescriptorService();
    }

    protected void initUpdateForceModeProvider() {
        this.registerRepositoryService(UpdateForceModeProvider.class, new UpdateForceModeProvider(){

            @Override
            public UpdateForceModeProvider.UpdateForceMode getUpdateForceMode() {
                return UpdateForceModeProvider.UpdateForceMode.SOURCE_PROJECT;
            }
        });
    }

    protected void initDecompositionDescriptorService() {
        this.registerRepositoryService(DecompositionDescriptorService.class, new LocalDecompositionDescriptorService(){

            @Override
            public LocalDecompositionDescriptor getDecompositionDescriptor(URI uRI, boolean bl, IProgressMonitor iProgressMonitor) throws PersistenceException {
                return LocalProjectRepository.this.getDecompositionDescriptor(uRI, bl, iProgressMonitor);
            }

            @Override
            public LocalDecompositionDescriptor getDecompositionDescriptor(URI uRI, IProgressMonitor iProgressMonitor) throws PersistenceException {
                return LocalProjectRepository.this.getDecompositionDescriptor(uRI, iProgressMonitor);
            }
        });
    }

    public LocalProjectRepositoryType getType() {
        return (LocalProjectRepositoryType)super.getType();
    }

    @Override
    protected IPrimaryProject doOpenProject(URI uRI, ProjectOptions projectOptions, IProgressMonitor iProgressMonitor) throws ProjectAllocationException {
        return new LocalProjectOpenUtil<LocalProjectRepository>().doOpenProject(this, uRI, projectOptions, iProgressMonitor);
    }

    @Override
    protected IPrimaryProject doCreateProject(URI uRI, Set<String> set, ProjectOptions projectOptions, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (projectOptions == null) {
            throw new IllegalArgumentException("Options not provided");
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = this.getListenerTicks();
        iProgressMonitor.beginTask("Creating Project...", n2 * 10);
        try {
            projectOptions = projectOptions.createCopy();
            LocalPrimaryProject localPrimaryProject = this.doCreateProject(uRI, projectOptions, true);
            localPrimaryProject.initialize();
            this.fireEvent(localPrimaryProject, uRI, ProjectRepositoryEventType.CREATING, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            localPrimaryProject.init(set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2 * 9));
            LocalPrimaryProject localPrimaryProject2 = localPrimaryProject;
            return localPrimaryProject2;
        }
        catch (IOException iOException) {
            throw new ProjectAllocationException("IO Error: " + iOException.getMessage(), (Throwable)iOException);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void doOpen(LocalPrimaryProject localPrimaryProject, IProgressMonitor iProgressMonitor) throws PersistenceException {
        localPrimaryProject.open(iProgressMonitor);
    }

    protected LocalPrimaryProject doCreateProject(URI uRI, ProjectOptions projectOptions, boolean bl) throws IOException {
        RecoveryFileStorageProviderImpl recoveryFileStorageProviderImpl = new RecoveryFileStorageProviderImpl();
        IResourcePersistence iResourcePersistence = this.createPrimaryProjectPersistence(uRI, recoveryFileStorageProviderImpl, bl);
        LocalPrimaryProject localPrimaryProject = this.createPrimaryProject(iResourcePersistence, projectOptions, bl);
        recoveryFileStorageProviderImpl.setProject(localPrimaryProject);
        return localPrimaryProject;
    }

    protected IResourcePersistence createPrimaryProjectPersistence(URI uRI, RecoveryFileStorageProvider recoveryFileStorageProvider, boolean bl) throws IOException {
        final URI uRI2 = this.inspectFileURI(uRI, bl);
        IResourcePersistence iResourcePersistence = this.createResourcePersistence(uRI2, new AbstractLazyDirectoryProvider(){

            @Override
            @Nonnull
            public File doCreateDirectory() {
                return LocalProjectRepository.this.calcPersistenceTempFilesLocation(uRI2);
            }
        }, recoveryFileStorageProvider, bl);
        return iResourcePersistence;
    }

    protected LocalPrimaryProject createPrimaryProject(IResourcePersistence iResourcePersistence, ProjectOptions projectOptions, boolean bl) {
        ResourceInfoEncoderDecoder resourceInfoEncoderDecoder = new ResourceInfoEncoderDecoder();
        LocalProjectOptions localProjectOptions = LocalProjectOptions.adapt(projectOptions);
        LocalPrimaryProject localPrimaryProject = new LocalPrimaryProject(this, localProjectOptions, iResourcePersistence, resourceInfoEncoderDecoder, resourceInfoEncoderDecoder, bl);
        return localPrimaryProject;
    }

    @Override
    protected IAttachedProject doGetAttachedProject(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, IPrimaryProjectInternal iPrimaryProjectInternal, IProgressMonitor iProgressMonitor) throws ProjectAllocationException {
        this.checkConfiguration(abstractProjectAttachmentConfiguration);
        this.checkPrimaryProject(iPrimaryProjectInternal);
        int n2 = this.getListenersCount() * 100;
        iProgressMonitor.beginTask("Creating attached project...", n2 * 1);
        try {
            boolean bl = this.isProjectForImport(abstractProjectAttachmentConfiguration);
            LocalAttachedProject localAttachedProject = this.doCreateAttachedProject(abstractProjectAttachmentConfiguration, iPrimaryProjectInternal, bl);
            localAttachedProject.initialize(iPrimaryProjectInternal);
            localAttachedProject.setNew(false);
            this.fireEvent(localAttachedProject, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), ProjectRepositoryEventType.OPENING, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            LocalAttachedProject localAttachedProject2 = localAttachedProject;
            return localAttachedProject2;
        }
        catch (PersistenceException persistenceException) {
            throw new ProjectAllocationException("IO Error: " + persistenceException.getMessage(), (Throwable)persistenceException);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected boolean isProjectForImport(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration) {
        return this.isProjectForImport(abstractProjectAttachmentConfiguration.getAttachedProjectURI());
    }

    @Override
    protected IAttachedProject doCreateAttachedProject(URI uRI, Set<String> set, IPrimaryProjectInternal iPrimaryProjectInternal, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkPrimaryProject(iPrimaryProjectInternal);
        int n2 = this.getListenerTicks();
        iProgressMonitor.beginTask("Creating attached project...", n2 * 2);
        try {
            LocalAttachedProject localAttachedProject = this.doCreateAttachedProject((AbstractProjectAttachmentConfiguration)new ProjectAttachmentConfiguration(uRI), iPrimaryProjectInternal, true);
            localAttachedProject.initialize(iPrimaryProjectInternal);
            localAttachedProject.init(set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            this.fireEvent(localAttachedProject, uRI, ProjectRepositoryEventType.CREATING, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            LocalAttachedProject localAttachedProject2 = localAttachedProject;
            return localAttachedProject2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void checkPrimaryProject(IPrimaryProjectInternal iPrimaryProjectInternal) {
        if (iPrimaryProjectInternal == null) {
            throw new PersistenceRuntimeException("The primary project NULL");
        }
        if (!(iPrimaryProjectInternal.getProjectRepository() instanceof LocalProjectRepository)) {
            throw new PersistenceRuntimeException("Attached project is not allowed for this kind of primary project");
        }
    }

    protected LocalAttachedProject doCreateAttachedProject(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, IPrimaryProjectInternal iPrimaryProjectInternal, boolean bl) throws PersistenceException {
        try {
            IResourcePersistence iResourcePersistence = this.createAttachedProjectPersistence(iPrimaryProjectInternal, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), bl);
            LocalAttachedProject localAttachedProject = this.createAttachedProject(iPrimaryProjectInternal, iResourcePersistence, abstractProjectAttachmentConfiguration, bl);
            return localAttachedProject;
        }
        catch (IOException iOException) {
            throw new PersistenceException((Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isProjectForImport(URI uRI) {
        return !this.canLoadProject(uRI) && this.canImportProject(uRI);
    }

    protected void checkConfiguration(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration) {
        if (abstractProjectAttachmentConfiguration.getStickyVersion() != null) {
            LOGGER.warn((Object)("Tried to load historical attached project via LocalProjectRepository. Project URI: " + abstractProjectAttachmentConfiguration.getAttachedProjectURI() + ", version: " + abstractProjectAttachmentConfiguration.getStickyVersion().getName()));
            throw new UnsupportedOperationException("Local repository does not support versioning");
        }
    }

    protected IResourcePersistence createAttachedProjectPersistence(IPrimaryProjectInternal iPrimaryProjectInternal, final URI uRI, boolean bl) throws IOException, ProjectAllocationException {
        LocalProjectRepository.basicInspectFileURI(uRI);
        RecoveryFileStorageProviderImpl recoveryFileStorageProviderImpl = new RecoveryFileStorageProviderImpl(iPrimaryProjectInternal);
        IResourcePersistence iResourcePersistence = this.createResourcePersistence(uRI, new AbstractLazyDirectoryProvider(){

            @Override
            @Nonnull
            public File doCreateDirectory() {
                return LocalProjectRepository.this.calcPersistenceTempFilesLocation(uRI);
            }
        }, recoveryFileStorageProviderImpl, bl);
        return iResourcePersistence;
    }

    private IResourcePersistence createResourcePersistence(URI uRI, DirectoryProvider directoryProvider, @CheckForNull RecoveryFileStorageProvider recoveryFileStorageProvider, boolean bl) throws IOException {
        return new SafeZipFilePersistence(uRI, directoryProvider, recoveryFileStorageProvider, bl);
    }

    protected File calcPersistenceTempFilesLocation(URI uRI) {
        return ZipFilePersistence.createWorkingDir();
    }

    protected LocalAttachedProject createAttachedProject(IPrimaryProjectInternal iPrimaryProjectInternal, IResourcePersistence iResourcePersistence, AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, boolean bl) {
        ResourceInfoEncoderDecoder resourceInfoEncoderDecoder = new ResourceInfoEncoderDecoder();
        String string = LocalProjectResolver.extractUsedProjectID(abstractProjectAttachmentConfiguration);
        LocalAttachedProject localAttachedProject = new LocalAttachedProject(this, iPrimaryProjectInternal, iResourcePersistence, resourceInfoEncoderDecoder, resourceInfoEncoderDecoder, string, bl);
        return localAttachedProject;
    }

    protected void initializeResourceSet(LocalPrimaryProject localPrimaryProject) {
        ResourceSet resourceSet = localPrimaryProject.getResourceSet();
        Resource.Factory factory = this.getDefaultResourceFactory(localPrimaryProject);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", factory);
        resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("*", factory);
    }

    protected Resource.Factory getDefaultResourceFactory(LocalPrimaryProject localPrimaryProject) {
        XMIResourceFactoryImpl xMIResourceFactoryImpl = new XMIResourceFactoryImpl(){

            public Resource createResource(URI uRI) {
                return new XMIResourceWithUUIDsImpl(uRI);
            }
        };
        return xMIResourceFactoryImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected URI inspectFileURI(URI uRI, boolean bl) {
        File file = LocalProjectRepository.basicInspectFileURI(uRI);
        if (!bl) {
            if (ZipFilePersistence.isZipFilePersistence(file)) return uRI;
            throw new IllegalArgumentException("Given file format is not supported");
        }
        if (file.isDirectory()) {
            file = new File(file, "UntitledProject" + System.currentTimeMillis() + "." + this.getType().getDefaultFileExtension());
            return URI.createFileURI((String)file.getAbsolutePath());
        }
        if (file.getParentFile() == null) throw new IllegalArgumentException("Can not create project in " + uRI);
        if (file.getParentFile().isDirectory()) return uRI;
        throw new IllegalArgumentException("Can not create project in " + uRI);
    }

    static File basicInspectFileURI(URI uRI) {
        File file = ZipFilePersistence.getFile(uRI);
        if (file == null) {
            throw new IllegalArgumentException("Given URI does not designate a file");
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canOpenProject(URI uRI) {
        return this.canLoadProject(uRI) || this.canImportProject(uRI);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canLoadProject(URI uRI) {
        File file = ZipFilePersistence.getFile(uRI);
        return file != null && ZipFilePersistence.isZipFilePersistence(file);
    }

    public boolean canImportProject(URI uRI) {
        IProjectDataImporter iProjectDataImporter = this.findImporter(uRI);
        if (iProjectDataImporter != null) {
            return true;
        }
        return false;
    }

    public ProjectDescriptor getProjectDescriptor(URI uRI, IProgressMonitor iProgressMonitor) throws PersistenceException {
        LocalDecompositionDescriptor localDecompositionDescriptor = this.getDecompositionDescriptor(uRI, iProgressMonitor);
        ProjectDescriptor projectDescriptor = localDecompositionDescriptor != null ? localDecompositionDescriptor.getProjectDescriptor() : null;
        return projectDescriptor;
    }

    public IProjectDataImporter findImporter(URI uRI) {
        Collection collection = ServicesDiscovery.INSTANCE.getServices(IProjectDataImporter.class.getName());
        for (IProjectDataImporter iProjectDataImporter : collection) {
            if (!iProjectDataImporter.canImport(this, uRI)) continue;
            return iProjectDataImporter;
        }
        return null;
    }

    public LocalDecompositionDescriptor getDecompositionDescriptor(URI uRI, IProgressMonitor iProgressMonitor) throws PersistenceException {
        return this.getDecompositionDescriptor(uRI, false, iProgressMonitor);
    }

    public LocalDecompositionDescriptor getDecompositionDescriptor(URI uRI, boolean bl, IProgressMonitor iProgressMonitor) throws ProjectAllocationException {
        if (this.canLoadProject(uRI)) {
            return this.loadDecompositionDescriptor(uRI, bl, iProgressMonitor);
        }
        if (this.canImportProject(uRI)) {
            return this.importProjectDescriptor(uRI, bl, iProgressMonitor);
        }
        return null;
    }

    public LocalDecompositionDescriptor loadDecompositionDescriptor(URI uRI, boolean bl, IProgressMonitor iProgressMonitor) throws ProjectAllocationException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 1000);
        try {
            iProgressMonitor.subTask("Creating project descriptor...");
            LocalPrimaryProject localPrimaryProject = this.doCreateProject(uRI, new ProjectOptions(), false);
            DecompositionModelService decompositionModelService = (DecompositionModelService)localPrimaryProject.getService(IDecompositionModel.class);
            decompositionModelService.setDeliverNotifications(false);
            localPrimaryProject.loadDecomposition(null);
            IAttachedProjectResolver iAttachedProjectResolver = bl ? localPrimaryProject.getService(IAttachedProjectResolver.class) : null;
            IAttachedProjectResolver iAttachedProjectResolver2 = iAttachedProjectResolver;
            LocalDecompositionModel localDecompositionModel = (LocalDecompositionModel)localPrimaryProject.getService(IDecompositionModel.class);
            LocalProject localProject = localDecompositionModel.getDecompositionProject();
            LocalDescriptorFactory localDescriptorFactory = this.getDescriptorFactory();
            LocalDecompositionDescriptor localDecompositionDescriptor = localDescriptorFactory.createDecompositionDescriptor(localPrimaryProject.getLocationURI(), localPrimaryProject.getProjectID(), localPrimaryProject.getName(), localPrimaryProject.getDescription(), localProject, iAttachedProjectResolver2);
            iProgressMonitor.worked(800);
            iProgressMonitor.subTask("Closing resources...");
            localPrimaryProject.doClose((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            LocalDecompositionDescriptor localDecompositionDescriptor2 = localDecompositionDescriptor;
            return localDecompositionDescriptor2;
        }
        catch (IOException iOException) {
            throw new ProjectAllocationException("Failed to load project information", (Throwable)iOException);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public LocalDecompositionDescriptor importProjectDescriptor(URI uRI, boolean bl, IProgressMonitor iProgressMonitor) {
        IProjectDataImporter iProjectDataImporter = this.findImporter(uRI);
        if (iProjectDataImporter == null) {
            throw new IllegalStateException("Can not load nor import project");
        }
        return iProjectDataImporter.getDecompositionDescriptor(uRI, iProgressMonitor);
    }

    @Override
    public IProjectRepositoryMountingHelper getMountingHelper() {
        return this.mountingHelper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(URI uRI, String string, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (uRI == null) throw new IllegalArgumentException();
        if (!uRI.isFile()) {
            throw new IllegalArgumentException();
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Deleting...", 1000);
        try {
            File file = new File(uRI.toFileString());
            iProgressMonitor.worked(100);
            file.delete();
            iProgressMonitor.worked(750);
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public <T> void registerService(Class<T> clazz, T t2) {
        this.registerRepositoryService(clazz, t2);
    }

    public static enum ProjectInitializationMode {
        NEW,
        NATIVE,
        IMPORTED;

    }

    public static class RecoveryFileStorageProviderImpl
    implements RecoveryFileStorageProvider {
        private static final String RECOVERY_FILE_STORAGE_KEY = RecoveryFileStorage.class.getName();
        IPrimaryProject project;

        public RecoveryFileStorageProviderImpl() {
        }

        private RecoveryFileStorageProviderImpl(IPrimaryProject iPrimaryProject) {
            this.project = iPrimaryProject;
        }

        public void setProject(IPrimaryProject iPrimaryProject) {
            this.project = iPrimaryProject;
        }

        @Override
        @CheckForNull
        public RecoveryFileStorage getRecoveryFileStorage() {
            ComplexOperationContext complexOperationContext;
            if (this.project != null && (complexOperationContext = ComplexOperationEventsUtil.getCurrentContext(this.project)) != null) {
                return (RecoveryFileStorage)complexOperationContext.get(RECOVERY_FILE_STORAGE_KEY);
            }
            return null;
        }

        public static void setRecoveryFileStorage(ComplexOperationContext complexOperationContext, RecoveryFileStorage recoveryFileStorage) {
            complexOperationContext.set(RECOVERY_FILE_STORAGE_KEY, (Object)recoveryFileStorage);
        }
    }

    protected static class XMIResourceWithUUIDsImpl
    extends XMIProxySupporterResourceImpl
    implements IExtendedResource {
        private XMIResourceWithUUIDsImpl(URI uRI) {
            super(uRI);
        }

        protected boolean useUUIDs() {
            return true;
        }

        @Override
        public void load(Map<?, ?> map) throws IOException {
            ResourceUtil.safelyLoadResource(this, map);
        }

        @Override
        public void superLoad(Map<?, ?> map) throws IOException {
            super.load(map);
        }

        public EList<EObject> getContents() {
            if (this.contents == null) {
                this.contents = new FixedContentsEList();
            }
            return this.contents;
        }

        protected class FixedContentsEList<E>
        extends ResourceImpl.ContentsEList<E> {
            private static final long serialVersionUID = 1L;

            protected FixedContentsEList() {
                super((ResourceImpl)XMIResourceWithUUIDsImpl.this);
            }

            public NotificationChain inverseRemove(E e2, NotificationChain notificationChain) {
                InternalEObject internalEObject = (InternalEObject)e2;
                if (XMIResourceWithUUIDsImpl.this.isLoaded) {
                    XMIResourceWithUUIDsImpl.this.detached((EObject)internalEObject);
                }
                return internalEObject.eSetResource(null, notificationChain);
            }
        }
    }
}

