/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.localproject;

import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.ProjectAllocationException;
import com.nomagic.ci.persistence.ProjectOptions;
import com.nomagic.ci.persistence.local.ProjectRepositoryEventType;
import com.nomagic.ci.persistence.local.spi.DefaultProjectRepository;
import com.nomagic.ci.persistence.local.spi.localproject.LocalPrimaryProject;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectRepository;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class LocalProjectOpenUtil<T extends LocalProjectRepository> {
    public final IPrimaryProject doOpenProject(T t2, URI uRI, ProjectOptions projectOptions, IProgressMonitor iProgressMonitor) throws ProjectAllocationException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = ((DefaultProjectRepository)t2).getListenerTicks();
        if (projectOptions == null) {
            throw new IllegalArgumentException("Options not provided");
        }
        projectOptions = projectOptions.createCopy();
        iProgressMonitor.beginTask("Opening project...", 10 * n2);
        try {
            LocalPrimaryProject localPrimaryProject;
            boolean bl = this.isProjectForImport(t2, uRI);
            try {
                localPrimaryProject = this.createProject(t2, uRI, projectOptions, bl);
                localPrimaryProject.initialize();
                localPrimaryProject.setNew(false);
            }
            catch (IOException iOException) {
                throw new ProjectAllocationException("IO Error: " + iOException.getMessage(), (Throwable)iOException);
            }
            ((DefaultProjectRepository)t2).fireEvent(localPrimaryProject, uRI, ProjectRepositoryEventType.OPENING, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            ((LocalProjectRepository)t2).doOpen(localPrimaryProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2 * 9));
            LocalPrimaryProject localPrimaryProject2 = localPrimaryProject;
            return localPrimaryProject2;
        }
        catch (PersistenceException persistenceException) {
            throw new ProjectAllocationException("IO Error: " + persistenceException.getMessage(), (Throwable)persistenceException);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected LocalPrimaryProject createProject(T t2, URI uRI, ProjectOptions projectOptions, boolean bl) throws IOException {
        return ((LocalProjectRepository)t2).doCreateProject(uRI, projectOptions, bl);
    }

    protected boolean isProjectForImport(T t2, URI uRI) {
        return ((LocalProjectRepository)t2).isProjectForImport(uRI);
    }
}

