/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.localproject;

import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.binary.IBinaryObjectService;
import com.nomagic.ci.persistence.local.ILocalProjectResourceManager;
import com.nomagic.ci.persistence.local.internal.local.a.a.i;
import com.nomagic.ci.persistence.local.internal.local.a.a.m;
import com.nomagic.ci.persistence.local.internal.local.e;
import com.nomagic.ci.persistence.local.internal.local.g;
import com.nomagic.ci.persistence.local.internal.local.k;
import com.nomagic.ci.persistence.local.partitioning.DirtyResourceSupportService;
import com.nomagic.ci.persistence.local.proxy.LocalProxyService;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IProjectServiceDescriptor;
import com.nomagic.ci.persistence.local.spi.IResourceUriMapper;
import com.nomagic.ci.persistence.local.spi.ProjectDecompositionManager;
import com.nomagic.ci.persistence.local.spi.ServiceNewAndOldValue;
import com.nomagic.ci.persistence.local.spi.ServiceResourceManagerFactory;
import com.nomagic.ci.persistence.local.spi.binary.IBinaryStreamStorage;
import com.nomagic.ci.persistence.local.spi.binary.IBinarySynchronizationService;
import com.nomagic.ci.persistence.local.spi.decomposition.IAttachedProjectResolver;
import com.nomagic.ci.persistence.local.spi.decomposition.ImportedUsagesHandler;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoEncoder;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.ProjectIDResource;
import com.nomagic.ci.persistence.local.spi.files.ReservedResourcePersistence;
import com.nomagic.ci.persistence.local.spi.localproject.LocalAttachedProject;
import com.nomagic.ci.persistence.local.spi.localproject.LocalBinaryDataService;
import com.nomagic.ci.persistence.local.spi.localproject.LocalImportedUsagesHandler;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectRepository;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectResolver;
import com.nomagic.ci.persistence.local.spi.localproject.MappedURIConverter;
import com.nomagic.ci.persistence.local.spi.resources.IProjectResourceFilter;
import com.nomagic.ci.persistence.local.spi.resources.LocalURIMapper;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.spi.resources.ResourcePersistenceHandler;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.util.ProjectUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class LocalProject {
    public static final String RESOURCE_PROGRESS_MONITOR = "RESOURCE_PROGRESS_MONITOR";
    private ProjectIDResource projectID;
    private AbstractProject project;
    private ResourcePersistenceHandler persistenceHandler;
    private Map<String, Object> persistenceOptions;
    private k localUriHandler;
    private ResourceSet resourceSet;
    private e sharePointsPersister;
    private static Logger LOGGER = Logger.getLogger(LocalProject.class);

    public LocalProject(IResourcePersistence iResourcePersistence, IResourceInfoEncoder iResourceInfoEncoder, IResourceInfoDecoder iResourceInfoDecoder, AbstractProject abstractProject, String string) {
        ReservedResourcePersistence reservedResourcePersistence = new ReservedResourcePersistence(iResourcePersistence);
        this.projectID = new ProjectIDResource(reservedResourcePersistence, string);
        this.project = abstractProject;
        this.persistenceOptions = new HashMap<String, Object>();
        this.persistenceOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        this.persistenceHandler = new ResourcePersistenceHandler(abstractProject);
        this.persistenceHandler.registerResourcePersistence(reservedResourcePersistence, null, iResourceInfoEncoder, iResourceInfoDecoder);
        this.initializeProjectURISupport();
        this.initializeBinarySupport();
        this.initializeProjectResolver();
        this.initializeProjectIDTracking();
        this.initializeImportedUsagesHandler();
    }

    LocalProjectRepository getRepository() {
        return (LocalProjectRepository)this.project.getProjectRepository();
    }

    public void registerAuxiliaryPersistence(IResourcePersistence iResourcePersistence, IProjectResourceFilter iProjectResourceFilter, IResourceInfoEncoder iResourceInfoEncoder, IResourceInfoDecoder iResourceInfoDecoder) {
        ReservedResourcePersistence reservedResourcePersistence = new ReservedResourcePersistence(iResourcePersistence);
        this.persistenceHandler.registerResourcePersistence(reservedResourcePersistence, iProjectResourceFilter, iResourceInfoEncoder, iResourceInfoDecoder);
    }

    public AbstractProject getProject() {
        return this.project;
    }

    public IResourcePersistence getPersistence() {
        return this.persistenceHandler.getPersistence(0);
    }

    public void setResourceSet(ResourceSet resourceSet, URI uRI) {
        this.resourceSet = resourceSet;
        MappedURIConverter mappedURIConverter = (MappedURIConverter)this.resourceSet.getURIConverter();
        try {
            mappedURIConverter.addHandlerMapping(this.getProjectID(), this.localUriHandler, uRI);
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.error((Object)("Failed to add uri handler for project with uri " + uRI));
            throw illegalStateException;
        }
        this.sharePointsPersister = new e(this.project);
    }

    protected void initializeProjectURISupport() {
        LocalURIMapper localURIMapper = new LocalURIMapper(this);
        this.localUriHandler = new k(localURIMapper, this.persistenceHandler);
        this.project.setUriMapper(localURIMapper);
    }

    protected void initializeBinarySupport() {
        this.project.registerProjectService(IBinaryObjectService.class, new LocalBinaryDataService(this.project));
        this.project.registerProjectService(IBinaryStreamStorage.class, this.persistenceHandler);
        this.project.registerProjectService(IBinarySynchronizationService.class, this.persistenceHandler);
    }

    protected void initializeProjectResolver() {
        LocalProjectResolver localProjectResolver = new LocalProjectResolver(this.project);
        this.project.registerProjectService(IAttachedProjectResolver.class, localProjectResolver);
    }

    protected void initializeProjectIDTracking() {
        g g2 = new g(this.project, this.project.getProjectServiceEventBus());
        this.project.registerProjectService(g.class, g2);
    }

    protected void initializeImportedUsagesHandler() {
        if (this.project instanceof LocalAttachedProject) {
            this.project.registerProjectService(ImportedUsagesHandler.class, new LocalImportedUsagesHandler((LocalAttachedProject)this.project));
        }
    }

    public String getProjectID() {
        return this.projectID.getProjectID();
    }

    public String getPersistedProjectID() {
        return this.projectID.getPersistedID();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setProjectID(String string) {
        String string2 = this.project.getProjectID();
        if (!string2.equals(string)) {
            MappedURIConverter mappedURIConverter2;
            HashMap<MappedURIConverter, Object> hashMap = new HashMap<MappedURIConverter, Object>();
            if (this.project.getResourceSet() != null && this.project.getUriMapper() != null) {
                for (MappedURIConverter mappedURIConverter2 : this.project.getResourceSet().getResources()) {
                    ResourceInfo resourceInfo = this.project.getUriMapper().getResourceInfo(mappedURIConverter2.getURI());
                    if (resourceInfo == null) continue;
                    hashMap.put(mappedURIConverter2, resourceInfo);
                }
            }
            this.projectID.setProjectID(string);
            if (this.resourceSet != null) {
                mappedURIConverter2 = (MappedURIConverter)this.resourceSet.getURIConverter();
                mappedURIConverter2.removeHandlerMapping(string2);
                try {
                    mappedURIConverter2.addHandlerMapping(string, this.localUriHandler, this.getLocationURI());
                }
                catch (IllegalStateException illegalStateException) {
                    LOGGER.error((Object)("Failed to add uri handler for project with uri " + this.getLocationURI()));
                    throw illegalStateException;
                }
            }
            if ((mappedURIConverter2 = this.project.getService(IDecompositionModel.class)).isAvailable()) {
                mappedURIConverter2.getDecompositionProject().setId(string);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                Resource resource = (Resource)entry.getKey();
                String string3 = ((ResourceInfo)entry.getValue()).getUserId();
                String string4 = ((ResourceInfo)entry.getValue()).getNamespace();
                String string5 = ((ResourceInfo)entry.getValue()).getResourceName();
                URI uRI = string3 != null ? this.project.getUriMapper().getPersonalResourceURI(string3, string4, string5) : this.project.getUriMapper().getResourceURI(string4, string5);
                resource.setURI(uRI);
            }
            ServiceNewAndOldValue serviceNewAndOldValue = new ServiceNewAndOldValue(string, string2);
            this.project.getProjectServiceEventBus().fire(this.project, AbstractProject.PROJECT_ID_EVENT_TYPE, serviceNewAndOldValue);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateUsagesOfThisProject() {
        Set<Map.Entry<IProject, ProjectUsage>> set = this.getAttachedBy().entrySet();
        for (Map.Entry<IProject, ProjectUsage> entry : set) {
            ProjectDecompositionManager.updateUsages(Collections.singleton(entry.getValue()), entry.getKey());
        }
    }

    public URI getLocationURI() {
        return this.getPersistence().getLocationURI();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLocationURI(URI uRI) {
        Map<IProject, ProjectUsage> map = this.getAttachedBy();
        this.getPersistence().setLocationURI(uRI);
        for (Map.Entry<IProject, ProjectUsage> entry : map.entrySet()) {
            IProject iProject = entry.getKey();
            ProjectUsage projectUsage = entry.getValue();
            com.nomagic.ci.persistence.local.internal.c.g.a((IAttachedProjectResolver)iProject.getService(IAttachedProjectResolver.class), projectUsage, this.project);
        }
        this.project.registerProjectInResourceAccessManager();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<IProject, ProjectUsage> getAttachedBy() {
        HashMap<IProject, ProjectUsage> hashMap = new HashMap<IProject, ProjectUsage>();
        IPrimaryProject iPrimaryProject = ProjectUtil.getPrimaryProject((IProject)this.project);
        if (iPrimaryProject != null) {
            for (IProject iProject : ProjectUtil.getProjects((IPrimaryProject)iPrimaryProject)) {
                ProjectUsage projectUsage = (ProjectUsage)((IProjectUsageManager)iProject.getService(IProjectUsageManager.class)).getProjectUsage((IProject)this.project);
                if (projectUsage == null) continue;
                hashMap.put(iProject, projectUsage);
            }
        }
        return hashMap;
    }

    File getLocationFile() {
        URI uRI = this.getLocationURI();
        return new File(uRI.toFileString());
    }

    String getFileExtension() {
        URI uRI = this.getLocationURI();
        return uRI.fileExtension();
    }

    public void setFileExtension(String string) {
        if (!string.equals(this.getFileExtension())) {
            String string2 = String.valueOf(this.getName()) + "." + string;
            this.setFileName(string2);
        }
    }

    public String getName() {
        String string = this.getLocationFile().getName();
        String string2 = this.getFileExtension();
        if (string2 != null) {
            int n2 = string2.length() + 1;
            string = string.substring(0, string.length() - n2);
        }
        return string;
    }

    public void setName(String string) {
        if (!string.equals(this.getName())) {
            block3: {
                String string2 = this.getFileExtension();
                if (string2 == null || string.endsWith(string2)) break block3;
                string = String.valueOf(string) + "." + string2;
            }
            this.setFileName(string);
        }
    }

    void setFileName(String string) {
        File file = this.getLocationFile();
        File file2 = file.getParentFile();
        File file3 = new File(file2, string);
        this.setLocationURI(URI.createFileURI((String)file3.getPath()));
    }

    public void update(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Reloading project support...", 1000);
        try {
            try {
                this.project.doUnload((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
                this.persistenceHandler.update((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
                this.project.loadProjectSupport((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
            }
            catch (IOException iOException) {
                throw new PersistenceException(iOException.getMessage(), (Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void updateFeatures(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            try {
                this.project.loadFeatures(iProgressMonitor);
            }
            catch (IOException iOException) {
                throw new PersistenceException(iOException.getMessage(), (Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void saveFeatureResources(Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.saveResources(map, iProgressMonitor, this.project.getManagedResources(), "Serializing project features data:");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveResources(Map<String, Object> map, IProgressMonitor iProgressMonitor, Collection<Resource> collection, String string) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = 10;
        int n3 = 10;
        int n4 = 100;
        int n5 = n4 * collection.size();
        com.nomagic.ci.persistence.local.internal.i.g g2 = (com.nomagic.ci.persistence.local.internal.i.g)this.project.getService(LocalProxyService.class);
        if (g2 != null) {
            n5 += n2 + collection.size() + n3 + collection.size();
        }
        iProgressMonitor.beginTask(String.valueOf(string) + "...", n5);
        try {
            try {
                Object object;
                for (String string2 : this.persistenceOptions.keySet()) {
                    Iterator<Resource> iterator;
                    if (!map.containsKey(string2) || (iterator = map.get(string2)) == (object = this.persistenceOptions.get(string2)) || object != null && object.equals(iterator)) continue;
                    throw new IllegalArgumentException(String.format("Hardcoded save option %s, value=%s is attempted to be overridden by passed save value %s", string2, object, iterator));
                }
                HashMap hashMap = new HashMap();
                hashMap.putAll(map);
                hashMap.putAll(this.persistenceOptions);
                for (Resource resource : collection) {
                    boolean bl2;
                    if (!resource.isLoaded() && resource.getResourceSet().getURIConverter().exists(resource.getURI(), null)) continue;
                    object = (DirtyResourceSupportService)ProjectUtil.getPrimaryProject((IProject)this.getProject()).getService(DirtyResourceSupportService.class);
                    boolean bl = bl2 = object == null ? true : object.isDirty(resource);
                    if (bl2) {
                        LOGGER.debug((Object)("Saving: " + resource.getURI()));
                        if (g2 != null) {
                            g2.a((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2), resource);
                            hashMap.put(RESOURCE_PROGRESS_MONITOR, new SubProgressMonitor(iProgressMonitor, n4));
                            resource.save((Map)hashMap);
                            g2.b((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3), resource);
                            continue;
                        }
                        hashMap.put(RESOURCE_PROGRESS_MONITOR, new SubProgressMonitor(iProgressMonitor, n4));
                        resource.save((Map)hashMap);
                        continue;
                    }
                    LOGGER.debug((Object)("Skipping saving: " + resource.getURI()));
                }
                return;
            }
            catch (IOException iOException) {
                throw new PersistenceException((Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void saveServiceResources(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 1000);
        try {
            this.saveProjectSharePoints((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
            this.saveResources(Collections.emptyMap(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500), this.project.getServiceResources(), "Serializing project support data:");
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void saveProjectSharePoints(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (this.sharePointsPersister == null) {
            this.sharePointsPersister = new e(this.getProject());
        }
        try {
            this.sharePointsPersister.a(iProgressMonitor);
        }
        catch (IOException iOException) {
            throw new PersistenceException((Throwable)iOException);
        }
    }

    public void saveDecomposition(Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 1000);
        try {
            Object object;
            IDecompositionModel iDecompositionModel = this.project.getService(IDecompositionModel.class);
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            Collection<Resource> collection = this.collectServiceResources((IProjectServiceDescriptor)iDecompositionModel);
            arrayList.addAll(collection);
            iProgressMonitor.worked(250);
            m m2 = this.project.getService(m.class);
            if (m2 != null) {
                object = this.collectServiceResources(m2);
                arrayList.addAll((Collection<Resource>)object);
            }
            if ((object = this.project.getService(i.class)) != null) {
                Collection<Resource> collection2 = this.collectServiceResources((IProjectServiceDescriptor)object);
                arrayList.addAll(collection2);
            }
            iProgressMonitor.worked(250);
            this.saveResources(map, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500), arrayList, "Serializing project support data:");
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Resource> collectServiceResources(IProjectServiceDescriptor iProjectServiceDescriptor) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        ILocalProjectResourceManager iLocalProjectResourceManager = ServiceResourceManagerFactory.getResourceManager(this.project, iProjectServiceDescriptor);
        for (String string : iLocalProjectResourceManager.getResourceNames()) {
            Resource resource = iLocalProjectResourceManager.getResource(string, false);
            if (resource == null) continue;
            arrayList.add(resource);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Resource> getAllResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource resource : this.project.getResourceSet().getResources()) {
            if (this.project.getUriMapper().getResourceInfo(resource.getURI()) == null) continue;
            arrayList.add(resource);
        }
        return arrayList;
    }

    public Collection<ResourceInfo> getProjectResources() {
        HashSet<ResourceInfo> hashSet = new HashSet<ResourceInfo>();
        hashSet.addAll(this.getLoadedResources());
        hashSet.addAll(this.getPersistedResources());
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<ResourceInfo> getLoadedResources() {
        IResourceUriMapper iResourceUriMapper = this.project.getUriMapper();
        List<ResourceInfo> list = Collections.emptyList();
        if (this.resourceSet != null && iResourceUriMapper != null) {
            list = new ArrayList<ResourceInfo>();
            for (Resource resource : this.resourceSet.getResources()) {
                ResourceInfo resourceInfo = iResourceUriMapper.getResourceInfo(resource.getURI());
                if (resourceInfo == null) continue;
                list.add(resourceInfo);
            }
        }
        return list;
    }

    public Collection<ResourceInfo> getPersistedResources() {
        return this.persistenceHandler.getPersistedResources();
    }

    void propagateProjectID() {
        IDecompositionModel iDecompositionModel = this.project.getService(IDecompositionModel.class);
        String string = this.projectID.getProjectID();
        iDecompositionModel.getDecompositionProject().setId(string);
        this.projectID.propagate();
    }

    public void commitProject(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 1000);
        try {
            this.propagateProjectID();
            this.persistenceHandler.commit((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 600));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void close(IProgressMonitor iProgressMonitor) throws IOException {
        MappedURIConverter mappedURIConverter = (MappedURIConverter)this.resourceSet.getURIConverter();
        mappedURIConverter.removeHandlerMapping(this.getProjectID());
        this.persistenceHandler.close(iProgressMonitor);
    }
}

