/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.localproject;

import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.metamodel.local.project.sharing.GlobalProxyCopyCleanEnabledRunner;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.local.LocalProjectOptions;
import com.nomagic.ci.persistence.local.decomposition.LocalDecompositionDescriptor;
import com.nomagic.ci.persistence.local.importers.IProjectDataImporter;
import com.nomagic.ci.persistence.local.internal.K;
import com.nomagic.ci.persistence.local.internal.V;
import com.nomagic.ci.persistence.local.internal.d.a;
import com.nomagic.ci.persistence.local.internal.f.k;
import com.nomagic.ci.persistence.local.internal.f.s;
import com.nomagic.ci.persistence.local.internal.i.a.g;
import com.nomagic.ci.persistence.local.internal.local.a.a.d;
import com.nomagic.ci.persistence.local.internal.local.a.a.i;
import com.nomagic.ci.persistence.local.internal.local.a.a.j;
import com.nomagic.ci.persistence.local.internal.local.a.a.m;
import com.nomagic.ci.persistence.local.internal.local.a.a.n;
import com.nomagic.ci.persistence.local.internal.local.a.a.o;
import com.nomagic.ci.persistence.local.internal.local.a.a.p;
import com.nomagic.ci.persistence.local.internal.local.a.a.zzzzeCustomizer;
import com.nomagic.ci.persistence.local.internal.local.f;
import com.nomagic.ci.persistence.local.internal.local.h;
import com.nomagic.ci.persistence.local.proxy.InstanceManagerService;
import com.nomagic.ci.persistence.local.proxy.LocalProxyService;
import com.nomagic.ci.persistence.local.proxy.SnapshotPreprocessor;
import com.nomagic.ci.persistence.local.proxy.ValueFilter;
import com.nomagic.ci.persistence.local.proxy.WorkspaceEventDispatcher;
import com.nomagic.ci.persistence.local.proxy.resource.ResolvingResourceSet;
import com.nomagic.ci.persistence.local.proxy.resource.impl.ResolvingResourceSetImpl;
import com.nomagic.ci.persistence.local.spi.AbstractPrimaryProject;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IRollbackExecutor;
import com.nomagic.ci.persistence.local.spi.ISaveExecutor;
import com.nomagic.ci.persistence.local.spi.ManagedResourceSet;
import com.nomagic.ci.persistence.local.spi.ProjectConfigurator;
import com.nomagic.ci.persistence.local.spi.ProjectFeatureResources;
import com.nomagic.ci.persistence.local.spi.ProjectUpdateContext;
import com.nomagic.ci.persistence.local.spi.URIRemapper;
import com.nomagic.ci.persistence.local.spi.binary.BinaryStreamAttic;
import com.nomagic.ci.persistence.local.spi.binary.ICentralStreamRepository;
import com.nomagic.ci.persistence.local.spi.binary.MultiBinaryStreamStorage;
import com.nomagic.ci.persistence.local.spi.decomposition.IDecompositionProjectIdProvider;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoEncoder;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.localproject.ILocalProjectInternal;
import com.nomagic.ci.persistence.local.spi.localproject.LocalAttachedProject;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProject;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectRepository;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectRollbackExecutor;
import com.nomagic.ci.persistence.local.spi.localproject.LocalResolveBarrier;
import com.nomagic.ci.persistence.local.spi.localproject.LocalSaveExecutor;
import com.nomagic.ci.persistence.local.spi.localproject.MappedURIConverter;
import com.nomagic.ci.persistence.local.spi.localproject.PrimaryProjectDecompositionIdProvider;
import com.nomagic.ci.persistence.local.spi.localproject.query.LocalQueryServiceImpl;
import com.nomagic.ci.persistence.local.spi.proxy.PackageURIRemapper;
import com.nomagic.ci.persistence.local.spi.query.IQueryProjectService;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.util.FileUtil;
import com.nomagic.ci.persistence.proxy.ProxyService;
import com.nomagic.ci.persistence.spi.binary.IBinaryObjectRuntimeService;
import com.nomagic.ci.services.SingletonServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class LocalPrimaryProject
extends AbstractPrimaryProject
implements ILocalProjectInternal {
    private static final Logger LOGGER = Logger.getLogger(LocalPrimaryProject.class);
    private LocalProject localProject;
    private final Map<String, String> projectIDmap = new HashMap<String, String>();
    private final Map<IProject, IProjectDataImporter> projectImporterMap = new HashMap<IProject, IProjectDataImporter>();
    private File binaryAtticDir;

    public LocalPrimaryProject(LocalProjectRepository localProjectRepository, LocalProjectOptions localProjectOptions, IResourcePersistence iResourcePersistence, IResourceInfoEncoder iResourceInfoEncoder, IResourceInfoDecoder iResourceInfoDecoder, boolean bl) throws ProjectConfigurationException {
        this(localProjectRepository, localProjectOptions, iResourcePersistence, iResourceInfoEncoder, iResourceInfoDecoder, bl, new ProjectConfigurator(iResourcePersistence.getLocationURI()));
    }

    public LocalPrimaryProject(LocalProjectRepository localProjectRepository, LocalProjectOptions localProjectOptions, IResourcePersistence iResourcePersistence, IResourceInfoEncoder iResourceInfoEncoder, IResourceInfoDecoder iResourceInfoDecoder, boolean bl, ProjectConfigurator projectConfigurator) throws ProjectConfigurationException {
        super(localProjectRepository, bl, localProjectOptions.getEnableProxyService() ? new ResolvingResourceSetImpl(new K()) : new V(new K()), localProjectOptions, projectConfigurator);
        this.initPartitioningSupport(false);
        this.initResourceSet();
        this.initProxyService(localProjectOptions);
        this.initBinarySupport();
        this.initProjectDecompositionIdProvider();
        this.localProject = new LocalProject(iResourcePersistence, iResourceInfoEncoder, iResourceInfoDecoder, this, null);
        this.localProject.setResourceSet(this.getResourceSet(), projectConfigurator.getRealProjectLocationURI());
        localProjectRepository.initializeResourceSet(this);
        this.initializeQueryService();
    }

    private void initializeQueryService() {
        AbstractProject abstractProject = this.localProject.getProject();
        this.registerProjectService(IQueryProjectService.class, new LocalQueryServiceImpl(abstractProject));
    }

    private void initResourceSet() {
        ManagedResourceSet managedResourceSet = (ManagedResourceSet)this.getResourceSet();
        managedResourceSet.setURIConverter((URIConverter)new MappedURIConverter());
        managedResourceSet.setURIRemapper(new URIRemapper(){

            @Override
            public URI remap(URI uRI) {
                return LocalPrimaryProject.this.getNewResourceURI(uRI);
            }

            @Override
            public List<URI> remapBack(URI uRI) {
                return LocalPrimaryProject.this.getOldResourceURIs(uRI);
            }
        });
        if (managedResourceSet instanceof ResolvingResourceSet) {
            ResolvingResourceSet resolvingResourceSet = (ResolvingResourceSet)managedResourceSet;
            resolvingResourceSet.addResolveBarrier(new LocalResolveBarrier(this, resolvingResourceSet));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<URI> getOldResourceURIs(URI uRI) {
        List<URI> list = Collections.emptyList();
        if (uRI.segmentCount() > 0) {
            String string = uRI.segment(0);
            Map<String, String> map = this.getProjectIDMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                String string2 = entry.getKey();
                URI uRI2 = URI.createHierarchicalURI((String)uRI.scheme(), (String)uRI.authority(), (String)uRI.device(), (String[])new String[]{string2}, (String)uRI.query(), (String)uRI.fragment());
                if (list.isEmpty()) {
                    list = Collections.singletonList(uRI2);
                    continue;
                }
                if (list.size() == 1) {
                    ArrayList<URI> arrayList = new ArrayList<URI>();
                    arrayList.add(list.get(0));
                    list = arrayList;
                }
                list.add(uRI2);
            }
        }
        return list;
    }

    private URI getNewResourceURI(URI uRI) {
        Map<String, String> map = this.getProjectIDMap();
        if (uRI.segmentCount() > 0) {
            String string = uRI.segment(0);
            String string2 = map.get(string);
            if (string2 != null) {
                return URI.createHierarchicalURI((String)uRI.scheme(), (String)uRI.authority(), (String)uRI.device(), (String[])new String[]{string2}, (String)uRI.query(), (String)uRI.fragment());
            }
        }
        return null;
    }

    private void initProxyService(LocalProjectOptions localProjectOptions) {
        Object object2;
        if (!localProjectOptions.getEnableProxyService()) {
            return;
        }
        if (!Boolean.getBoolean("skip.save.private.dependency.list")) {
            this.registerProjectService(i.class, new j(this));
        }
        com.nomagic.ci.persistence.local.internal.i.a.h h2 = new com.nomagic.ci.persistence.local.internal.i.a.h();
        p p2 = new p((IProject)this, h2);
        Set<SnapshotPreprocessor> set = localProjectOptions.getSnapshotPreprocessors();
        for (SnapshotPreprocessor object32 : set) {
            p2.a(object32);
        }
        g g2 = new g();
        com.nomagic.ci.persistence.local.internal.i.a.f f2 = new com.nomagic.ci.persistence.local.internal.i.a.f(this, g2, this.getResourceAccessManager(), p2);
        Set<ValueFilter> set2 = localProjectOptions.getProxyValueFilters();
        for (ValueFilter valueFilter : set2) {
            f2.addValueFilter(valueFilter);
        }
        List<PackageURIRemapper> list = localProjectOptions.getPackageURIRemappers();
        for (Object object2 : list) {
            f2.addPackageURIRemapper((PackageURIRemapper)object2);
        }
        this.registerProjectService(ProxyService.class, f2);
        this.registerProjectService(LocalProxyService.class, f2);
        this.registerProjectService(WorkspaceEventDispatcher.class, new com.nomagic.ci.persistence.local.internal.local.a.a.a(this));
        this.getService(a.class).a(WorkspaceEventDispatcher.class, new com.nomagic.ci.persistence.local.internal.i.a.d());
        object2 = new d(this, g2);
        this.registerProjectService(InstanceManagerService.class, object2);
        p2.a(new f());
        p2.a(new com.nomagic.ci.persistence.local.internal.local.i());
        p2.a(new o());
        p2.addDependenciesCustomizer(new zzzzeCustomizer(this));
        this.initSharePointContainmentProxyInfoManager(p2);
        this.registerProjectService(m.class, new n(this));
        this.initResolveWithProxyCopyCleanSupport();
    }

    protected void initResolveWithProxyCopyCleanSupport() {
        GlobalProxyCopyCleanEnabledRunner globalProxyCopyCleanEnabledRunner = (GlobalProxyCopyCleanEnabledRunner)SingletonServiceRegistry.INSTANCE.getService(GlobalProxyCopyCleanEnabledRunner.class);
        if (globalProxyCopyCleanEnabledRunner == null) {
            SingletonServiceRegistry.INSTANCE.register(GlobalProxyCopyCleanEnabledRunner.class, (Object)new com.nomagic.ci.persistence.local.internal.local.d());
        }
        h h2 = new h(this);
        this.registerProjectService(k.class, h2);
    }

    protected void initSharePointContainmentProxyInfoManager(com.nomagic.ci.persistence.local.internal.i.i i2) {
        com.nomagic.ci.persistence.local.internal.local.j j2 = new com.nomagic.ci.persistence.local.internal.local.j(this);
        this.registerProjectService(s.class, j2);
        i2.a(j2);
    }

    protected File calcBinaryRuntimeFilesLocation() {
        return FileUtil.createTempDir(String.valueOf(LocalProjectRepository.TEMP_DIR) + File.separator + "BinaryData" + System.currentTimeMillis());
    }

    protected void initBinarySupport() {
        this.binaryAtticDir = this.calcBinaryRuntimeFilesLocation();
        BinaryStreamAttic binaryStreamAttic = new BinaryStreamAttic(this.binaryAtticDir);
        MultiBinaryStreamStorage multiBinaryStreamStorage = new MultiBinaryStreamStorage(this, binaryStreamAttic);
        this.registerProjectService(ICentralStreamRepository.class, multiBinaryStreamStorage);
        this.registerProjectService(IBinaryObjectRuntimeService.class, multiBinaryStreamStorage);
    }

    protected void initProjectDecompositionIdProvider() {
        this.registerProjectService(IDecompositionProjectIdProvider.class, new PrimaryProjectDecompositionIdProvider(this));
    }

    public void initialize() {
        if (!this.canLoadProject()) {
            String string = this.importProjectID(this.findImporter());
            if (string != null) {
                this.setProjectID(string);
            }
        }
    }

    protected String importProjectID(IProjectDataImporter iProjectDataImporter) {
        if (iProjectDataImporter != null) {
            LocalDecompositionDescriptor localDecompositionDescriptor = this.importProjectDescriptor(iProjectDataImporter, this.getLocationURI(), null);
            if (localDecompositionDescriptor != null) {
                return localDecompositionDescriptor.getId();
            }
        }
        return null;
    }

    @Override
    public LocalProject getLocalProject() {
        return this.localProject;
    }

    @Override
    public LocalProjectRepository getProjectRepository() {
        return (LocalProjectRepository)super.getProjectRepository();
    }

    public URI getLocationURI() {
        return this.localProject.getLocationURI();
    }

    public void setLocationURI(URI uRI) {
        this.localProject.setLocationURI(uRI);
    }

    @Override
    public String getProjectID() {
        return this.localProject.getProjectID();
    }

    public void setProjectID(String string) {
        this.localProject.setProjectID(string);
    }

    @Override
    public void setName(String string) {
        this.localProject.setName(string);
    }

    @Override
    public String getName() {
        return this.localProject.getName();
    }

    @Override
    public void loadProjectSupport(IProgressMonitor iProgressMonitor) throws IOException {
        this.verifyProjectID();
        super.loadProjectSupport(iProgressMonitor);
    }

    @Override
    protected void updateProjectSupport(ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.localProject.update(iProgressMonitor);
    }

    @Override
    protected void updateFeatures(Collection<ProjectFeatureResources> collection, ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.localProject.updateFeatures(iProgressMonitor);
    }

    protected void cleanBinaryRutimeFilesLocation(@Nonnull File file) {
        FileUtil.deleteTree(file);
    }

    @Override
    public void doClose(@Nonnull IProgressMonitor iProgressMonitor) {
        try {
            iProgressMonitor.beginTask("do close...", 1000);
            try {
                this.localProject.close((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
            }
            catch (IOException iOException) {
                throw new ProjectConfigurationException(iOException.getMessage(), (Throwable)iOException);
            }
            super.doClose((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
            if (this.binaryAtticDir != null) {
                this.cleanBinaryRutimeFilesLocation(this.binaryAtticDir);
            }
            iProgressMonitor.worked(100);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    protected IRollbackExecutor createRollbackExecutor() throws PersistenceException {
        return new LocalProjectRollbackExecutor(this);
    }

    @Override
    protected void doSaveFeatureResources(Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.localProject.saveFeatureResources(map, iProgressMonitor);
    }

    @Override
    protected void doSaveServiceResources(Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.localProject.saveServiceResources(iProgressMonitor);
    }

    @Override
    protected void doSaveDecomposition(Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.localProject.saveDecomposition(map, iProgressMonitor);
    }

    @Override
    protected ISaveExecutor createSaveExecutor(String string, Map<String, Object> map) throws PersistenceException {
        return new LocalSaveExecutor(this.localProject, string, map);
    }

    public Map<String, String> getProjectIDMap() {
        return this.projectIDmap;
    }

    @Override
    public Collection<ResourceInfo> getProjectResources() {
        return this.localProject.getProjectResources();
    }

    public void doLoadShallowAttachedProject(LocalAttachedProject localAttachedProject, ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) throws PersistenceException {
        block6: {
            block5: {
                if (!this.canLoadProject()) break block5;
                this.verifyProjectID();
                this.doLoad(iProgressMonitor);
                break block6;
            }
            if (this.canImportProject()) {
                this.doImport(iProgressMonitor);
            }
        }
    }

    @Override
    public void doLoadInternal(IProgressMonitor iProgressMonitor) throws PersistenceException {
        block3: {
            block2: {
                if (!this.canLoadProject()) break block2;
                this.verifyProjectID();
                this.doLoad(iProgressMonitor);
                break block3;
            }
            this.doImport(iProgressMonitor);
        }
    }

    protected IProjectDataImporter findImporter() {
        LocalProjectRepository localProjectRepository = this.getProjectRepository();
        return localProjectRepository.findImporter(this.getLocationURI());
    }

    public boolean canLoadProject() {
        LocalProjectRepository localProjectRepository = this.getProjectRepository();
        if (this.getLoadedFrom() != null) {
            return localProjectRepository.canLoadProject(this.getLoadedFrom());
        }
        return localProjectRepository.canLoadProject(this.getLocationURI());
    }

    public boolean canImportProject() {
        LocalProjectRepository localProjectRepository = this.getProjectRepository();
        return localProjectRepository.canImportProject(this.getLocationURI());
    }

    protected void doLoad(IProgressMonitor iProgressMonitor) throws PersistenceException {
        super.doLoadInternal(iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void verifyProjectID() {
        String string2 = this.getProjectID();
        String string = this.getActualProjectID();
        if (string == null) return;
        if (string2.equals(string)) return;
        this.setProjectID(string);
    }

    protected String getActualProjectID() {
        return this.localProject.getPersistedProjectID();
    }

    protected void doImport(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Loading legacy data...", 1000);
        try {
            IProjectDataImporter iProjectDataImporter = this.findImporter();
            if (iProjectDataImporter == null) {
                throw new PersistenceException("Can not load legacy project " + this.getName() + " from " + this.getLocationURI());
            }
            this.doInit(Collections.emptySet(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            this.registerImporter(this, iProjectDataImporter);
            iProjectDataImporter.importToProject(this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 900));
        }
        finally {
            this.unregisterImporter(this);
            iProgressMonitor.done();
        }
    }

    protected LocalDecompositionDescriptor importProjectDescriptor(IProjectDataImporter iProjectDataImporter, URI uRI, IProgressMonitor iProgressMonitor) {
        return iProjectDataImporter.getDecompositionDescriptor(uRI, iProgressMonitor);
    }

    public void registerImporter(IProject iProject, IProjectDataImporter iProjectDataImporter) {
        this.projectImporterMap.put(iProject, iProjectDataImporter);
    }

    public void unregisterImporter(IProject iProject) {
        this.projectImporterMap.remove(iProject);
    }

    public boolean canImportShallowOnLoadFromAnyImporter(IAttachedProject iAttachedProject) {
        for (Map.Entry<IProject, IProjectDataImporter> entry : this.projectImporterMap.entrySet()) {
            IProject iProject;
            IProjectDataImporter iProjectDataImporter = entry.getValue();
            if (!iProjectDataImporter.canImportShallowOnLoad(iProject = entry.getKey(), iAttachedProject)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importShallowOnLoadFromAllImporters(IAttachedProject iAttachedProject, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        HashMap<IProject, IProjectDataImporter> hashMap = this.projectImporterMap.isEmpty() ? Collections.emptyMap() : new HashMap<IProject, IProjectDataImporter>(this.projectImporterMap);
        iProgressMonitor.beginTask("Looking for minimum data alternatively...", 100 * hashMap.size());
        try {
            for (Map.Entry entry : hashMap.entrySet()) {
                IProject iProject;
                IProjectDataImporter iProjectDataImporter = (IProjectDataImporter)entry.getValue();
                if (iProjectDataImporter.canImportShallowOnLoad(iProject = (IProject)entry.getKey(), iAttachedProject)) {
                    iProjectDataImporter.importShallowOnLoad(iProject, iAttachedProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                    continue;
                }
                iProgressMonitor.worked(100);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void importShallowOnLoad(IProject iProject, IAttachedProject iAttachedProject, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        HashMap<IProject, IProjectDataImporter> hashMap = this.projectImporterMap.isEmpty() ? Collections.emptyMap() : new HashMap<IProject, IProjectDataImporter>(this.projectImporterMap);
        HashMap<IProject, IProjectDataImporter> hashMap2 = hashMap;
        iProgressMonitor.beginTask("Looking for minimum data alternatively...", 100 * hashMap2.size());
        try {
            IProjectDataImporter iProjectDataImporter = (IProjectDataImporter)hashMap2.get(iProject);
            if (iProjectDataImporter == null) {
                LOGGER.warn((Object)("Importer for imported project " + iProject + ", uri: " + iProject.getLocationURI() + " not found"));
                return;
            }
            if (iProjectDataImporter.canImportShallowOnLoad(iProject, iAttachedProject)) {
                iProjectDataImporter.importShallowOnLoad(iProject, iAttachedProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

