/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.localproject;

import com.nomagic.ci.metamodel.binary.BinaryFactory;
import com.nomagic.ci.metamodel.binary.BinaryObject;
import com.nomagic.ci.metamodel.binary.StreamIdentityBinaryObject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.binary.IBinaryObjectService;
import com.nomagic.ci.persistence.local.ILocalResourceDescriptor;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.binary.IBinaryStreamContainer;
import com.nomagic.ci.persistence.local.spi.binary.IBinaryStreamStorage;
import com.nomagic.ci.persistence.local.spi.binary.StreamIdentityFactory;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.util.FileUtil;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import com.nomagic.ci.persistence.services.AbstractProjectService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.ecore.resource.Resource;

public class LocalBinaryDataService
extends AbstractProjectService
implements IBinaryObjectService {
    public LocalBinaryDataService(IProject iProject) {
        super(iProject);
    }

    public BinaryObject createBinaryObject() {
        return BinaryFactory.eINSTANCE.createStreamIdentityBinaryObject();
    }

    public BinaryObject createCompatibleBinaryObject(BinaryObject binaryObject) throws IOException {
        Object object;
        if (binaryObject == null) {
            throw new IllegalArgumentException();
        }
        Resource resource = binaryObject.eResource();
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (binaryObject instanceof StreamIdentityBinaryObject) {
            object = (StreamIdentityBinaryObject)binaryObject;
            if (this.getProject().getResourceSet() == binaryObject.eResource().getResourceSet()) {
                return object;
            }
        }
        object = this.getResourceInfo(resource);
        IBinaryStreamStorage iBinaryStreamStorage = (IBinaryStreamStorage)this.getProject().getService(IBinaryStreamStorage.class);
        IBinaryStreamContainer iBinaryStreamContainer = iBinaryStreamStorage.getContainerFor((ResourceInfo)object);
        StreamIdentityBinaryObject streamIdentityBinaryObject = BinaryFactory.eINSTANCE.createStreamIdentityBinaryObject();
        String string = StreamIdentityFactory.generateStreamContentID();
        streamIdentityBinaryObject.setStreamContentID(string);
        InputStream inputStream = binaryObject.getInputStream();
        if (inputStream != null) {
            OutputStream outputStream = iBinaryStreamContainer.getOutputStream(string);
            FileUtil.copy(inputStream, outputStream);
            outputStream.close();
            inputStream.close();
        }
        return streamIdentityBinaryObject;
    }

    private ResourceInfo getResourceInfo(Resource resource) {
        IProject iProject = LocalProjectUtil.getProject(resource);
        if (iProject == null) {
            throw new IllegalArgumentException();
        }
        ILocalResourceDescriptor iLocalResourceDescriptor = ((AbstractProject)iProject).getResourceDescriptor(resource);
        String string = iLocalResourceDescriptor.isPersonal() ? "default" : null;
        String string2 = string;
        String string3 = iLocalResourceDescriptor.getResourceFeatureDescriptor().getNamespace();
        String string4 = iLocalResourceDescriptor.getResourceName();
        return new ResourceInfo(string2, string3, string4);
    }
}

