/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.persistence.local.spi.DirectResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.DirectStreamHandle;
import com.nomagic.ci.persistence.local.spi.files.DirectZipStreamHandle;
import com.nomagic.ci.persistence.local.util.FileUtil;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ZipStreamCompressor {
    private FileOutputStream outputStream;
    private ZipOutputStream zipOutputStream;
    private static final Logger LOG = Logger.getLogger(ZipStreamCompressor.class);

    public ZipStreamCompressor(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public ZipStreamCompressor(FileOutputStream fileOutputStream) {
        this(new BufferedOutputStream(fileOutputStream, 65536));
        this.outputStream = fileOutputStream;
    }

    public ZipStreamCompressor(OutputStream outputStream) {
        this(new ZipOutputStream(outputStream));
    }

    public ZipStreamCompressor(ZipOutputStream zipOutputStream) {
        this.zipOutputStream = zipOutputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compress(DirectResourcePersistence directResourcePersistence, IProgressMonitor iProgressMonitor) throws IOException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        Set<String> set = directResourcePersistence.getResources();
        iProgressMonitor.beginTask("Compressing data", set.size() * 10);
        try {
            for (String string : set) {
                block33: {
                    if (this.zipOutputStream.getEntry(string) == null && !"Records.properties".equals(string)) {
                        InputStream inputStream;
                        Throwable throwable;
                        Object object;
                        DirectStreamHandle directStreamHandle = directResourcePersistence.getResourceAsDirectStreamHandle(string);
                        ZipEntry zipEntry = new ZipEntry(string);
                        if (directStreamHandle instanceof DirectZipStreamHandle) {
                            object = (DirectZipStreamHandle)directStreamHandle;
                            this.updateEntry(object.getEntry(), zipEntry);
                            this.zipOutputStream.putNextEntry(zipEntry, false);
                            try {
                                throwable = null;
                                inputStream = null;
                                try (InputStream inputStream2 = ((DirectZipStreamHandle)directStreamHandle).getCompressedStream();){
                                    FileUtil.copy(inputStream2, (OutputStream)this.zipOutputStream, -1L);
                                    break block33;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                        throw throwable;
                                    }
                                    if (throwable == throwable2) throw throwable;
                                    throwable.addSuppressed(throwable2);
                                    throw throwable;
                                }
                            }
                            finally {
                                this.zipOutputStream.closeEntry();
                            }
                        }
                        this.zipOutputStream.putNextEntry(zipEntry, true);
                        try {
                            object = null;
                            throwable = null;
                            try {
                                inputStream = directStreamHandle.getInputStream();
                                try {
                                    FileUtil.copy(inputStream, (OutputStream)this.zipOutputStream, -1L);
                                }
                                finally {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (object == null) {
                                    object = throwable3;
                                    throw object;
                                }
                                if (object == throwable3) throw object;
                                ((Throwable)object).addSuppressed(throwable3);
                                throw object;
                            }
                        }
                        finally {
                            this.zipOutputStream.closeEntry();
                        }
                    }
                }
                iProgressMonitor.worked(10);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void updateEntry(ZipEntry zipEntry, ZipEntry zipEntry2) {
        zipEntry2.setComment(zipEntry.getComment());
        zipEntry2.setCompressedSize(zipEntry.getCompressedSize());
        zipEntry2.setCrc(zipEntry.getCrc());
        zipEntry2.setEncrypted(zipEntry.isEncrypted());
        zipEntry2.setExternalAttributes(zipEntry.getExternalAttributes());
        zipEntry2.setExtra(zipEntry.getExtra());
        zipEntry2.setMethod(zipEntry.getMethod());
        zipEntry2.setPlatform(zipEntry.getPlatform());
        zipEntry2.setSize(zipEntry.getSize());
    }

    public void close() throws IOException {
        this.writeCompatEntry();
        if (this.outputStream != null) {
            try {
                this.zipOutputStream.flush();
                long l2 = System.currentTimeMillis();
                this.outputStream.getChannel().force(false);
                LOG.debug((Object)String.format("Force cache time %d ms\n", System.currentTimeMillis() - l2));
            }
            catch (Throwable throwable) {
                LOG.warn((Object)"Failed to force data write to disk", throwable);
            }
        }
        this.zipOutputStream.close();
    }

    private void writeCompatEntry() throws IOException {
        ZipEntry zipEntry2;
        Properties properties = new Properties();
        for (ZipEntry zipEntry2 : this.zipOutputStream) {
            String string = zipEntry2.getName();
            properties.setProperty(string, string);
        }
        zipEntry2 = new ZipEntry("Records.properties");
        this.zipOutputStream.putNextEntry(zipEntry2, true);
        try {
            properties.store((OutputStream)this.zipOutputStream, "Compatibility entry");
        }
        finally {
            this.zipOutputStream.closeEntry();
        }
    }
}

