/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.persistence.local.internal.local.DirectZipFile;
import com.nomagic.ci.persistence.local.internal.local.b;
import com.nomagic.ci.persistence.local.spi.DirectResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.AbstractLazyDirectoryProvider;
import com.nomagic.ci.persistence.local.spi.files.DirectStreamHandle;
import com.nomagic.ci.persistence.local.spi.files.DirectStreamHandleCompat;
import com.nomagic.ci.persistence.local.spi.files.DirectoryData;
import com.nomagic.ci.persistence.local.spi.files.DirectoryProvider;
import com.nomagic.ci.persistence.local.spi.files.IRenamingPersistence;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.ZipStreamCompressor;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectRepository;
import com.nomagic.ci.persistence.local.util.FileUtil;
import de.schlichtherle.truezip.zip.ZipEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class ZipFilePersistence
implements IResourcePersistence,
IRenamingPersistence,
DirectResourcePersistence {
    private static final Logger LOGGER = Logger.getLogger(ZipFilePersistence.class);
    private static final String WORK_DIR = ZipFilePersistence.class.getSimpleName();
    private static int count;
    private final Set<String> compressed = new HashSet<String>();
    private final Set<String> uncompressed = new HashSet<String>();
    private final Set<String> mDeleted = new HashSet<String>();
    private DirectoryProvider workDirProvider;
    private File mDirectory;
    private URI locationURI;
    private DirectoryData mWorkingCopy;
    private DirectZipFile zipFile;
    private boolean isNew;
    private boolean mClosed;

    @Nonnull
    public static synchronized File createWorkingDir() {
        String string = String.valueOf(LocalProjectRepository.TEMP_DIR) + File.separator + WORK_DIR + count++;
        File file = FileUtil.createTempDir(string);
        return file;
    }

    public ZipFilePersistence(URI uRI, boolean bl) throws IOException {
        this(uRI, new AbstractLazyDirectoryProvider(){

            @Override
            @Nonnull
            public File doCreateDirectory() {
                return ZipFilePersistence.createWorkingDir();
            }
        }, bl);
    }

    public ZipFilePersistence(URI uRI, DirectoryProvider directoryProvider, boolean bl) throws IOException {
        this.locationURI = uRI;
        this.workDirProvider = directoryProvider;
        this.isNew = bl;
        this.mWorkingCopy = this.initWorkingCopy();
        this.initialize();
    }

    protected DirectoryData initWorkingCopy() throws IOException {
        return new DirectoryData(new AbstractLazyDirectoryProvider(){

            @Override
            @Nonnull
            public File doCreateDirectory() {
                return ZipFilePersistence.this.lazyGetWorkingCopyDir();
            }
        });
    }

    protected void closeWorkingCopy() {
        this.mWorkingCopy.close();
    }

    @Nonnull
    protected File lazyGetWorkingCopyDir() {
        if (this.mDirectory == null) {
            this.mDirectory = this.workDirProvider.getDirectory();
        }
        return this.mDirectory;
    }

    @CheckForNull
    protected final File getWorkingCopyDir() {
        return this.mDirectory;
    }

    protected void initialize() throws IOException {
        File file = ZipFilePersistence.inspectFileURI(this.locationURI);
        this.zipFile = this.initZipFile(file);
    }

    protected DirectZipFile initZipFile(File file) throws IOException {
        DirectZipFile directZipFile;
        block7: {
            this.compressed.clear();
            directZipFile = null;
            if (this.isNew || !ZipFilePersistence.isExtractable(file)) break block7;
            try {
                directZipFile = new DirectZipFile(file);
                Iterator iterator = directZipFile.iterator();
                while (iterator.hasNext()) {
                    ZipEntry zipEntry = (ZipEntry)iterator.next();
                    if (zipEntry.isDirectory()) continue;
                    this.compressed.add(zipEntry.getName());
                }
            }
            catch (IOException iOException) {
                directZipFile = null;
                LOGGER.warn((Object)("Failed to open zip file " + file.getAbsolutePath()), (Throwable)iOException);
            }
        }
        return directZipFile;
    }

    protected void cleanup() {
        if (this.zipFile != null) {
            ZipFilePersistence.closeQuietly(this.zipFile);
        }
        this.mDeleted.clear();
        this.compressed.clear();
        this.uncompressed.clear();
        this.mWorkingCopy.clean();
    }

    public static File inspectFileURI(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("URI can not be null");
        }
        File file = ZipFilePersistence.getFile(uRI);
        if (file == null) {
            throw new IllegalArgumentException("URI does not designate a file");
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getFile(URI uRI) {
        if (uRI != null && uRI.isFile()) {
            return new File(uRI.toFileString());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isExtractable(File file) {
        return file != null && file.isFile() && file.canRead() && file.length() > 0L;
    }

    /*
     * Loose catch block
     */
    public static boolean isZipFilePersistence(File file) {
        block11: {
            block12: {
                ZipEntry zipEntry;
                block10: {
                    DirectZipFile directZipFile = null;
                    zipEntry = null;
                    try {
                        directZipFile = new DirectZipFile(file);
                        zipEntry = directZipFile.getEntry("Records.properties");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        LOGGER.info((Object)("File does not exists: " + file));
                        ZipFilePersistence.closeQuietly(directZipFile);
                        break block10;
                    }
                    catch (IOException iOException) {
                        try {
                            LOGGER.warn((Object)iOException.getMessage(), (Throwable)iOException);
                        }
                        catch (Throwable throwable) {
                            ZipFilePersistence.closeQuietly(directZipFile);
                            throw throwable;
                        }
                        ZipFilePersistence.closeQuietly(directZipFile);
                        break block10;
                    }
                    ZipFilePersistence.closeQuietly(directZipFile);
                }
                if (zipEntry == null) break block11;
                if (zipEntry.isDirectory()) break block11;
                break block12;
                catch (FileNotFoundException fileNotFoundException) {
                    throw fileNotFoundException;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void closeQuietly(DirectZipFile directZipFile) {
        if (directZipFile == null) return;
        try {
            directZipFile.close();
            return;
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    @Override
    public URI getLocationURI() {
        return this.locationURI;
    }

    @Override
    public void setLocationURI(URI uRI) {
        ZipFilePersistence.inspectFileURI(uRI);
        this.locationURI = uRI;
    }

    @Override
    public synchronized boolean deleteResource(String string) {
        this.uncompressed.remove(string);
        this.mDeleted.add(string);
        return true;
    }

    private boolean isResourceDeleted(String string) {
        return this.mDeleted.contains(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean isResourcePresent(String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Checking if resource " + string + " is present in persistence " + this.locationURI));
        }
        if (this.isResourceDeleted(string)) {
            this.debugResourceNotPresent(string);
            return false;
        }
        boolean bl2 = this.uncompressed.contains(string) || this.compressed.contains(string);
        if (bl2) return bl2;
        this.debugResourceNotPresent(string);
        return bl2;
    }

    private void debugResourceNotPresent(String string) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Resource is not present: ");
            stringBuilder.append(string);
            this.printPersistenceState(stringBuilder);
            LOGGER.debug((Object)stringBuilder.toString());
        }
    }

    @Override
    public DirectStreamHandle getResourceAsDirectStreamHandle(String string) {
        if (!this.isResourcePresent(string)) {
            throw new IllegalArgumentException();
        }
        DirectStreamHandle directStreamHandle = this.uncompressed.contains(string) ? new DirectStreamHandleCompat(this, string) : new b(this.zipFile, string);
        return directStreamHandle;
    }

    @Override
    public synchronized InputStream getResourceAsInputStream(String string) {
        if (!this.isResourceDeleted(string)) {
            boolean bl = this.uncompressed.contains(string);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Getting input stream for " + string + ", uncompressed: " + bl));
            }
            InputStream inputStream = bl ? this.getWorkingCopyResource(string) : this.getZipFileResource(string);
            InputStream inputStream2 = inputStream;
            if (inputStream2 == null) {
                this.debugInputStreamNotCreated(string);
            }
            return inputStream2;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Resource " + string + " is deleted, cannot open input stream"));
        }
        return null;
    }

    private void debugInputStreamNotCreated(String string) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not create input stream for ");
            stringBuilder.append(string);
            this.printPersistenceState(stringBuilder);
            LOGGER.debug((Object)stringBuilder.toString());
        }
    }

    private void printPersistenceState(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("Printing state. Compressed: ");
        this.printCollection(this.compressed, stringBuilder);
        stringBuilder.append(", uncompressed: ");
        this.printCollection(this.uncompressed, stringBuilder);
        stringBuilder.append(", deleted: ");
        this.printCollection(this.mDeleted, stringBuilder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printCollection(Collection<String> collection, StringBuilder stringBuilder) {
        if (collection == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append("[");
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private InputStream getWorkingCopyResource(String string) {
        return this.mWorkingCopy.getInput(string);
    }

    private InputStream getZipFileResource(String string) {
        InputStream inputStream = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Getting zip file resource: " + string + ", zipFile: " + (Object)((Object)this.zipFile)));
        }
        if (this.zipFile != null) {
            try {
                inputStream = this.zipFile.getInputStream(string, true);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("InputStream from zipFile: " + inputStream));
                }
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
        return inputStream;
    }

    @Override
    public synchronized OutputStream getResourceAsOutputStream(String string) {
        this.mDeleted.remove(string);
        this.uncompressed.add(string);
        return this.mWorkingCopy.getOutput(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void renameResource(String string, String string2) {
        if (!this.isResourcePresent(string) || this.isResourcePresent(string2)) {
            throw new IllegalArgumentException();
        }
        if (!this.uncompressed.contains(string)) {
            this.extractEntry(string);
        }
        this.mWorkingCopy.rename(string, string2);
        this.uncompressed.add(string2);
        this.mDeleted.add(string);
        this.mDeleted.remove(string2);
    }

    @Override
    public synchronized void update(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Reloading from disk", 1000);
        try {
            try {
                this.cleanup();
                iProgressMonitor.worked(500);
                this.initialize();
                iProgressMonitor.worked(500);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    public synchronized void commit(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Writing to disk...", 1000);
        try {
            try {
                iProgressMonitor.worked(100);
                this.compress(ZipFilePersistence.getFile(this.locationURI), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 700));
                this.isNew = false;
                this.initialize();
                iProgressMonitor.worked(200);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void compress(File file, IProgressMonitor iProgressMonitor) throws IOException {
        File file2 = new File(String.valueOf(file.getAbsolutePath()) + ".save");
        if (!file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            throw new IOException("failed to create directory for file " + file2.getAbsolutePath());
        }
        this.doCompress(file2, iProgressMonitor);
        this.cleanup();
        if (file.exists() && !file.delete()) {
            throw new IOException("failed to overwrite file " + file.getAbsolutePath());
        }
        if (!file2.renameTo(file)) {
            throw new IOException("failed to overwrite zip file " + file.getAbsolutePath());
        }
    }

    protected final void doCompress(File file, IProgressMonitor iProgressMonitor) throws FileNotFoundException, IOException {
        try (ZipStreamCompressor zipStreamCompressor = new ZipStreamCompressor(file);){
            zipStreamCompressor.compress(this, iProgressMonitor);
        }
    }

    @Override
    public synchronized void close(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Deleting files", 800);
        try {
            iProgressMonitor.worked(200);
            this.cleanup();
            iProgressMonitor.worked(200);
            this.workDirProvider.dispose();
            iProgressMonitor.worked(200);
            this.closeWorkingCopy();
            iProgressMonitor.worked(200);
            this.mClosed = true;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void extractEntry(String string) {
        if (this.zipFile == null) {
            throw new IllegalStateException("Can not extract: " + string + " entry. The " + this.locationURI + " is not present or persistence was not updated when it became available.");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            try {
                inputStream = this.zipFile.getInputStream(string, true);
                long l2 = this.zipFile.getEntry(string).getCrc();
                outputStream = this.mWorkingCopy.getOutput(string);
                FileUtil.copy(inputStream, outputStream, l2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly(inputStream);
            FileUtil.closeQuietly(outputStream);
            throw throwable;
        }
        FileUtil.closeQuietly(inputStream);
        FileUtil.closeQuietly(outputStream);
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public Set<String> getResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.uncompressed);
        hashSet.addAll(this.compressed);
        hashSet.removeAll(this.mDeleted);
        hashSet.remove("Records.properties");
        return hashSet;
    }
}

