/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.persistence.local.internal.local.DirectZipFile;
import com.nomagic.ci.persistence.local.spi.files.AbstractLazyDirectoryProvider;
import com.nomagic.ci.persistence.local.spi.files.DirectoryData;
import com.nomagic.ci.persistence.local.spi.files.DirectoryProvider;
import com.nomagic.ci.persistence.local.spi.files.RecoveryFileStorage;
import com.nomagic.ci.persistence.local.spi.files.RecoveryFileStorageProvider;
import com.nomagic.ci.persistence.local.spi.files.ZipFilePersistence;
import com.nomagic.ci.persistence.local.util.FileUtil;
import com.nomagic.ci.persistence.util.ThreadUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class SafeZipFilePersistence
extends ZipFilePersistence {
    private static final Logger LOGGER = Logger.getLogger(SafeZipFilePersistence.class);
    private static final String FILES_WORK_DIR = "files";
    private static final String ZIP_FILE_COPY = "source.zip";
    private static final int FILE_RENAME_ATTEMPT_COUNT = 20;
    private static final int FILE_RENAME_WAIT_MILLIS = 500;
    private File sourceTempZip;
    @CheckForNull
    private RecoveryFileStorageProvider recoveryFileStorageProvider;

    public SafeZipFilePersistence(URI uRI, boolean bl) throws IOException {
        super(uRI, bl);
    }

    public SafeZipFilePersistence(URI uRI, DirectoryProvider directoryProvider, @CheckForNull RecoveryFileStorageProvider recoveryFileStorageProvider, boolean bl) throws IOException {
        super(uRI, directoryProvider, bl);
        this.recoveryFileStorageProvider = recoveryFileStorageProvider;
    }

    @Override
    protected DirectZipFile initZipFile(File file) throws IOException {
        File file2 = this.lazyGetWorkingCopyDir();
        this.sourceTempZip = new File(file2, ZIP_FILE_COPY);
        if (SafeZipFilePersistence.isExtractable(file)) {
            FileUtil.copy(file, this.sourceTempZip, -1L);
            return super.initZipFile(this.sourceTempZip);
        }
        return null;
    }

    @Override
    protected DirectoryData initWorkingCopy() throws IOException {
        return new DirectoryData(new AbstractLazyDirectoryProvider(){

            @Override
            @Nonnull
            public File doCreateDirectory() {
                File file = SafeZipFilePersistence.this.lazyGetWorkingCopyDir();
                return new File(file, SafeZipFilePersistence.FILES_WORK_DIR);
            }
        });
    }

    @Override
    protected void closeWorkingCopy() {
        super.closeWorkingCopy();
        File file = this.getWorkingCopyDir();
        if (file != null) {
            FileUtil.deleteDir(file);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        if (this.sourceTempZip != null) {
            this.sourceTempZip.delete();
        }
    }

    @Override
    public synchronized void close(IProgressMonitor iProgressMonitor) {
        super.close(iProgressMonitor);
    }

    @Override
    protected void compress(File file, IProgressMonitor iProgressMonitor) throws IOException {
        File file2 = new File(String.valueOf(file.getAbsolutePath()) + ".bak");
        boolean bl = this.defaultCreateBackup(file, file2);
        if (!bl) {
            LOGGER.error((Object)("Default backup creation for " + file + " failed"));
            bl = this.copyingCreateBackup(file, file2);
            if (!bl) {
                LOGGER.error((Object)("Fallback backup creation for " + file + " failed"));
            }
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.defaultCompress(file, iProgressMonitor);
            if (!bl2) {
                LOGGER.error((Object)("Default compress for " + file + " failed"));
            }
        }
        if (!bl2) {
            this.recoveryCompress(file, iProgressMonitor);
        }
        this.cleanup();
    }

    private void recoveryCompress(File file, IProgressMonitor iProgressMonitor) throws IOException {
        File file2 = this.demandGetRecoveryFile(file);
        this.doCompress(file2, iProgressMonitor);
    }

    private File demandGetRecoveryFile(File file) throws IOException {
        String string = null;
        if (this.recoveryFileStorageProvider != null) {
            RecoveryFileStorage recoveryFileStorage = this.recoveryFileStorageProvider.getRecoveryFileStorage();
            if (recoveryFileStorage != null) {
                File file2 = recoveryFileStorage.getRecoveryFile(file);
                if (file2 != null) {
                    return file2;
                }
                string = "recovery file not provided";
            } else {
                string = "storage not provided";
            }
        } else {
            string = "storage provider not registered";
        }
        LOGGER.warn((Object)ThreadUtil.createThreadDump());
        throw new IOException("Saving to file " + file + " has failed and recovery file could not be created. Reason: " + string);
    }

    private boolean defaultCompress(File file, IProgressMonitor iProgressMonitor) {
        try {
            this.doCompress(file, iProgressMonitor);
            return true;
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"compressing to destination failed", (Throwable)iOException);
            return false;
        }
    }

    private boolean copyingCreateBackup(File file, File file2) {
        try {
            if (SafeZipFilePersistence.isExtractable(file)) {
                SafeZipFilePersistence.copyFile(file, file2);
                boolean bl = file.delete();
                if (!bl) {
                    LOGGER.error((Object)"deleting original after copying backup failed");
                }
                return bl;
            }
            return true;
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"copying backup creation failed", (Throwable)iOException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean defaultCreateBackup(File file, File file2) {
        try {
            if (file2.exists() && !file2.delete()) {
                throw new IOException("failed to delete backup file " + file2.getAbsolutePath());
            }
            if (SafeZipFilePersistence.isExtractable(file)) {
                boolean bl = false;
                int n2 = 0;
                while (true) {
                    if (n2 >= 20 || bl) {
                        if (bl) break;
                        throw new IOException("failed to rename zip file " + file2.getAbsolutePath());
                    }
                    bl = file.renameTo(file2);
                    if (!bl) {
                        try {
                            Thread.sleep(500L);
                            LOGGER.warn((Object)("Attempt to rename count " + n2 + " file: " + file2.getAbsolutePath()));
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    ++n2;
                }
            }
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("failed to create directory for file " + file.getAbsolutePath());
            }
            return true;
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"default backup creation failed", (Throwable)iOException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyFile(File file, File file2) throws IOException {
        block43: {
            if (file2.exists() && file2.isDirectory()) {
                throw new IOException("Destination '" + file2 + "' exists but is a directory");
            }
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    block42: {
                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                        try {
                            block41: {
                                FileChannel fileChannel = fileInputStream.getChannel();
                                try {
                                    try (FileChannel fileChannel2 = fileOutputStream.getChannel();){
                                        long l2 = fileChannel.size();
                                        long l3 = 0L;
                                        long l4 = 0L;
                                        while (l3 < l2) {
                                            l4 = l2 - l3 > 0x1E00000L ? 0x1E00000L : l2 - l3;
                                            l3 += fileChannel2.transferFrom(fileChannel, l3, l4);
                                        }
                                    }
                                    if (fileChannel == null) break block41;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    if (fileChannel == null) throw throwable;
                                    fileChannel.close();
                                    throw throwable;
                                }
                                fileChannel.close();
                            }
                            if (fileOutputStream == null) break block42;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            if (fileOutputStream == null) throw throwable;
                            fileOutputStream.close();
                            throw throwable;
                        }
                        fileOutputStream.close();
                    }
                    if (fileInputStream == null) break block43;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    if (fileInputStream == null) throw throwable;
                    fileInputStream.close();
                    throw throwable;
                }
                fileInputStream.close();
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        if (file.length() == file2.length()) return;
        throw new IOException("Failed to copy full contents from '" + file + "' to '" + file2 + "'");
    }
}

