/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoEncoder;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceInfoEncoderDecoder
implements IResourceInfoEncoder,
IResourceInfoDecoder {
    public static final char NAMESPACE_SEPARATOR = '.';
    public static final char PERSONAL_SEPARATOR = '-';
    private static final String PERSONAL_STREAM_PREFIX = "personal-";
    private static final Pattern PATTERN = Pattern.compile("[$]");
    private static final Pattern encodePattern = Pattern.compile("(\\$\\$)|(\\$d)|(\\$h)");

    @Override
    public String getStreamId(ResourceInfo resourceInfo) {
        String string = resourceInfo.getNamespace();
        String string2 = resourceInfo.getResourceName();
        String string3 = resourceInfo.getUserId();
        String string4 = String.valueOf(ResourceInfoEncoderDecoder.encodeNamespace(string)) + '.' + ResourceInfoEncoderDecoder.encodeResourceName(string2);
        if (string3 != null) {
            string4 = PERSONAL_STREAM_PREFIX + string4;
        }
        return string4;
    }

    @Override
    public ResourceInfo getResourceInfo(String string) {
        if (string != null) {
            int n2;
            String string2 = null;
            if (string.startsWith(PERSONAL_STREAM_PREFIX)) {
                string2 = "default";
                string = string.substring(PERSONAL_STREAM_PREFIX.length() + 1);
            }
            if ((n2 = string.lastIndexOf(46)) > 0 && n2 < string.length() - 1) {
                String string3 = ResourceInfoEncoderDecoder.decodeNamespace(string.substring(0, n2));
                String string4 = ResourceInfoEncoderDecoder.decodeResourceName(string.substring(n2 + 1));
                return new ResourceInfo(string2, string3, string4);
            }
        }
        return null;
    }

    public static String encodeNamespace(String string) {
        return PATTERN.matcher(string).replaceAll("\\$\\$").replaceAll(String.valueOf('-'), "\\$h");
    }

    public static String decodeNamespace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = encodePattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2.equals("$h")) {
                matcher.appendReplacement(stringBuffer, String.valueOf('-'));
                continue;
            }
            matcher.appendReplacement(stringBuffer, "\\$");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String encodeResourceName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = stringBuilder.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = stringBuilder.charAt(n3);
            if (c2 == '$') {
                stringBuilder.replace(n3, n3 + 1, "$$");
                ++n2;
                ++n3;
            } else if (c2 == '.') {
                stringBuilder.replace(n3, n3 + 1, "$d");
                ++n2;
                ++n3;
            } else if (c2 == '-') {
                stringBuilder.replace(n3, n3 + 1, "$h");
                ++n2;
                ++n3;
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String decodeResourceName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = encodePattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2.equals("$d")) {
                matcher.appendReplacement(stringBuffer, String.valueOf('.'));
                continue;
            }
            if (string2.equals("$h")) {
                matcher.appendReplacement(stringBuffer, String.valueOf('-'));
                continue;
            }
            matcher.appendReplacement(stringBuffer, "\\$");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

