/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.persistence.local.IResourcePool;
import com.nomagic.ci.persistence.local.spi.files.IReservedResourceHandle;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class ReservedResourcesPool
implements IResourcePool {
    private IResourcePool delegate;
    private IReservedResourceHandle handle;

    public ReservedResourcesPool(IResourcePool iResourcePool, IReservedResourceHandle iReservedResourceHandle) {
        this.delegate = iResourcePool;
        this.handle = iReservedResourceHandle;
    }

    @Override
    public InputStream getResourceAsInputStream(String string) {
        this.checkReserved(string);
        return this.delegate.getResourceAsInputStream(string);
    }

    @Override
    public OutputStream getResourceAsOutputStream(String string) {
        this.checkReserved(string);
        return this.delegate.getResourceAsOutputStream(string);
    }

    @Override
    public boolean deleteResource(String string) {
        this.checkReserved(string);
        return this.delegate.deleteResource(string);
    }

    @Override
    public boolean isResourcePresent(String string) {
        this.checkReserved(string);
        return this.delegate.isResourcePresent(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getResources() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.delegate.getResources()) {
            if (!this.isReserved(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    boolean isReserved(String string) {
        return this.handle.isReserved(string);
    }

    private void checkReserved(String string) {
        if (!this.isReserved(string)) {
            throw new IllegalArgumentException();
        }
    }
}

