/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.persistence.local.IResourcePool;
import com.nomagic.ci.persistence.local.spi.files.IReservedResourceHandle;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.ReservedResourcesPool;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class ReservedResourcePersistence
implements IResourcePersistence {
    private IResourcePersistence delegate;
    private CompositeReservedResourceHandle handles;
    private ReservedResourcesPool reserved;

    public ReservedResourcePersistence(IResourcePersistence iResourcePersistence) {
        if (iResourcePersistence == null) {
            throw new NullPointerException();
        }
        this.delegate = iResourcePersistence;
        this.handles = new CompositeReservedResourceHandle();
        this.reserved = new ReservedResourcesPool(iResourcePersistence, this.handles);
    }

    public IResourcePool addHandle(IReservedResourceHandle iReservedResourceHandle) {
        this.handles.getHandles().add(iReservedResourceHandle);
        return new ReservedResourcesPool(this.delegate, iReservedResourceHandle);
    }

    @Override
    public URI getLocationURI() {
        return this.delegate.getLocationURI();
    }

    @Override
    public void setLocationURI(URI uRI) {
        this.delegate.setLocationURI(uRI);
    }

    @Override
    public InputStream getResourceAsInputStream(String string) {
        this.checkReserved(string);
        return this.delegate.getResourceAsInputStream(string);
    }

    @Override
    public OutputStream getResourceAsOutputStream(String string) {
        this.checkReserved(string);
        return this.delegate.getResourceAsOutputStream(string);
    }

    @Override
    public boolean deleteResource(String string) {
        this.checkReserved(string);
        return this.delegate.deleteResource(string);
    }

    @Override
    public boolean isResourcePresent(String string) {
        this.checkReserved(string);
        return this.delegate.isResourcePresent(string);
    }

    @Override
    public Set<String> getResources() {
        HashSet<String> hashSet = new HashSet<String>(this.delegate.getResources());
        hashSet.removeAll(this.reserved.getResources());
        return hashSet;
    }

    @Override
    public void commit(IProgressMonitor iProgressMonitor) {
        this.delegate.commit(iProgressMonitor);
    }

    @Override
    public void update(IProgressMonitor iProgressMonitor) {
        this.delegate.update(iProgressMonitor);
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public void close(IProgressMonitor iProgressMonitor) {
        this.delegate.close(iProgressMonitor);
    }

    private void checkReserved(String string) {
        if (this.reserved.isReserved(string)) {
            throw new IllegalArgumentException("Resource name is reserved");
        }
    }

    private static class CompositeReservedResourceHandle
    implements IReservedResourceHandle {
        private Collection<IReservedResourceHandle> handles = new ArrayList<IReservedResourceHandle>();

        private CompositeReservedResourceHandle() {
        }

        Collection<IReservedResourceHandle> getHandles() {
            return this.handles;
        }

        @Override
        public boolean isReserved(String string) {
            for (IReservedResourceHandle iReservedResourceHandle : this.handles) {
                if (!iReservedResourceHandle.isReserved(string)) continue;
                return true;
            }
            return false;
        }
    }
}

