/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.spi.files.IRenamingPersistence;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class RenamingPersistenceCompat
implements IRenamingPersistence {
    private IResourcePersistence persistence;

    public RenamingPersistenceCompat(IResourcePersistence iResourcePersistence) {
        this.persistence = iResourcePersistence;
    }

    @Override
    public void renameResource(String string, String string2) {
        InputStream inputStream = this.persistence.getResourceAsInputStream(string);
        if (inputStream != null) {
            try {
                try (OutputStream outputStream = this.persistence.getResourceAsOutputStream(string2);){
                    FileUtil.copy(inputStream, outputStream);
                }
                finally {
                    inputStream.close();
                }
                this.persistence.deleteResource(string);
            }
            catch (IOException iOException) {
                throw new PersistenceRuntimeException((Throwable)iOException);
            }
        }
    }

    @Override
    public URI getLocationURI() {
        return this.persistence.getLocationURI();
    }

    @Override
    public void setLocationURI(URI uRI) {
        this.persistence.setLocationURI(uRI);
    }

    @Override
    public InputStream getResourceAsInputStream(String string) {
        return this.persistence.getResourceAsInputStream(string);
    }

    @Override
    public void commit(IProgressMonitor iProgressMonitor) {
        this.persistence.commit(iProgressMonitor);
    }

    @Override
    public void update(IProgressMonitor iProgressMonitor) {
        this.persistence.update(iProgressMonitor);
    }

    @Override
    public OutputStream getResourceAsOutputStream(String string) {
        return this.persistence.getResourceAsOutputStream(string);
    }

    @Override
    public boolean isClosed() {
        return this.persistence.isClosed();
    }

    @Override
    public void close(IProgressMonitor iProgressMonitor) {
        this.persistence.close(iProgressMonitor);
    }

    @Override
    public boolean deleteResource(String string) {
        return this.persistence.deleteResource(string);
    }

    @Override
    public boolean isResourcePresent(String string) {
        return this.persistence.isResourcePresent(string);
    }

    @Override
    public Set<String> getResources() {
        return this.persistence.getResources();
    }
}

