/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ReadableByteArrayOutputStream
extends ByteArrayOutputStream {
    private int offset;

    public ReadableByteArrayOutputStream(int n2) {
        super(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0) throw new IndexOutOfBoundsException();
        if (n3 < 0) throw new IndexOutOfBoundsException();
        if (n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.getUnreadSize();
        int n5 = Math.min(n4, n3);
        if (n5 <= 0) return n5;
        System.arraycopy(this.buf, this.offset, byArray, n2, n5);
        this.offset += n5;
        return n5;
    }

    public int read() {
        int n2 = this.offset < this.count ? this.buf[this.offset++] & 0xFF : -1;
        return n2;
    }

    public int getUnreadSize() {
        return this.count - this.offset;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.offset = 0;
    }
}

