/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.persistence.local.IResourcePool;
import com.nomagic.ci.persistence.local.spi.files.IReservedResourceHandle;
import com.nomagic.ci.persistence.local.spi.files.ReservedResourcePersistence;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.UUID;

public class ProjectIDResource
implements IReservedResourceHandle {
    public static final String PREFIX = "PROJECT-";
    private IResourcePool pool;
    private String projectID;

    public ProjectIDResource(ReservedResourcePersistence reservedResourcePersistence, String string) {
        block10: {
            block9: {
                if (string != null) {
                    if (!ProjectIDResource.isProjectID(string)) {
                        throw new IllegalArgumentException();
                    }
                }
                this.pool = reservedResourcePersistence.addHandle(this);
                if (string == null) break block9;
                this.projectID = string;
                break block10;
            }
            this.projectID = this.getPersistedID();
            if (this.projectID == null) {
                this.projectID = PREFIX + UUID.randomUUID().toString();
            }
        }
    }

    @Override
    public boolean isReserved(String string) {
        return string.startsWith(PREFIX);
    }

    public String getProjectID() {
        return this.projectID;
    }

    public void setProjectID(String string) {
        if (!ProjectIDResource.isProjectID(string)) {
            throw new IllegalArgumentException();
        }
        this.projectID = string;
    }

    public void verify() {
        String string = this.getPersistedID();
        if (!this.projectID.equals(string)) {
            throw new IllegalStateException("Current project ID " + this.projectID + " does not match with persisted " + string);
        }
    }

    public String getPersistedID() {
        Set<String> set = this.pool.getResources();
        String string = set.size() == 1 ? (String)set.iterator().next() : null;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propagate() {
        Set<String> set = this.pool.getResources();
        if (set.size() != 1 || !this.projectID.equals(set.iterator().next())) {
            for (String string : set) {
                this.pool.deleteResource(string);
            }
        }
        this.touch(this.projectID);
    }

    private void touch(String string) {
        OutputStream outputStream = this.pool.getResourceAsOutputStream(string);
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isProjectID(String string) {
        return string != null && string.startsWith(PREFIX);
    }
}

