/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.spi.files.DirectoryProvider;
import com.nomagic.ci.persistence.local.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class DirectoryData {
    public static final String MAPFILENAME = "Records.properties";
    private static final Logger LOGGER = Logger.getLogger(DirectoryData.class);
    private File mDirectory;
    private final DirectoryProvider directoryProvider;
    private final Properties mURItoIDMap = new Properties();
    private final FileNameCreatorWithLengthLimitation idCreator = new FileNameCreatorWithLengthLimitation(120);

    public DirectoryData(DirectoryProvider directoryProvider) throws IOException {
        this.directoryProvider = directoryProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File lazyGetDirectory() {
        if (this.mDirectory != null) return this.mDirectory;
        try {
            this.initDirectory();
            return this.mDirectory;
        }
        catch (IOException iOException) {
            throw new PersistenceRuntimeException(iOException.getMessage(), (Throwable)iOException);
        }
    }

    private void initDirectory() throws IOException {
        block6: {
            block5: {
                this.mDirectory = this.directoryProvider.getDirectory();
                if (this.mDirectory.exists()) break block5;
                this.createDirectory();
                break block6;
            }
            if (!FileUtil.makeEmptyDir(this.mDirectory)) {
                throw new IOException("Failed to empty a directory " + this.mDirectory);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createDirectory() throws IOException {
        if (this.mDirectory.mkdirs()) {
            return;
        }
        int n2 = 0;
        while (n2 < MkdirDiagnostics.diagnosticRetryCount) {
            LOGGER.info((Object)("Creating directory with diagnostics turned on, retry (" + (n2 + 1) + "): " + this.mDirectory.getPath()));
            if (MkdirDiagnostics.mkdirsWithDiagnostics(this.mDirectory)) {
                return;
            }
            ++n2;
        }
        throw new IOException("can not create directory " + this.mDirectory);
    }

    public File getDirectory() {
        return this.lazyGetDirectory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clean() {
        ArrayList<String> arrayList = new ArrayList<String>(this.list());
        for (String string : arrayList) {
            this.delete(string);
        }
    }

    public void close() {
        this.directoryProvider.dispose();
        if (this.mDirectory != null) {
            FileUtil.deleteDir(this.mDirectory);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File delete(String string) {
        File file = this.getFile(string);
        this.mURItoIDMap.remove(string);
        if (file != null && !file.delete()) {
            return file;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getFile(String var1_1) {
        var2_2 = this.getID(var1_1);
        if (var2_2 != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = var2_2.substring(1);
lbl5:
            // 2 sources

            ** while (var2_2.startsWith((String)"/") || var2_2.startsWith((String)File.separator))
        }
lbl6:
        // 1 sources

        var3_3 = this.lazyGetDirectory();
        return new File(var3_3, var2_2);
    }

    public String getID(String string) {
        String string2 = (String)this.mURItoIDMap.get(string);
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rename(String string, String string2) {
        if (!this.exists(string) || this.exists(string2)) {
            throw new IllegalArgumentException();
        }
        File file = this.getFile(string);
        String string3 = this.createID(string2);
        File file2 = new File(file.getParentFile(), string3);
        if (!file.renameTo(file2)) {
            throw new IllegalStateException();
        }
        this.mURItoIDMap.setProperty(string2, string3);
        this.mURItoIDMap.remove(string);
    }

    public boolean exists(String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Checking if resource " + string + " exists in working copy " + this.mDirectory));
        }
        boolean bl = this.mURItoIDMap.containsKey(string);
        if (!bl) {
            this.debugResourceDoesNotExist(string);
        }
        return bl;
    }

    private void debugResourceDoesNotExist(String string) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("URI does not exist in this working copy: ");
            stringBuilder.append(string);
            this.printURIToIDMapContents(stringBuilder);
            this.printWorkingDirectoryState(stringBuilder);
            this.printWorkingDirectoryContents(stringBuilder);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInput(String string) {
        File file = this.getFile(string);
        this.debugBeforeGetInput(string, file);
        if (file == null) {
            this.debugInputNotFound();
            return null;
        }
        try {
            return new BufferedInputStream(new FileInputStream(file), 65536);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.debugInputNotFound();
            throw new RuntimeException(fileNotFoundException);
        }
    }

    private void debugBeforeGetInput(String string, File file) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Getting input steam for URI ");
            stringBuilder.append(string);
            stringBuilder.append(", file is: ");
            StringBuilder stringBuilder2 = stringBuilder;
            String string2 = file != null ? file.getAbsolutePath() : "null";
            stringBuilder2.append(string2);
            if (file == null) {
                this.printURIToIDMapContents(stringBuilder);
            }
            this.printWorkingDirectoryState(stringBuilder);
            LOGGER.debug((Object)stringBuilder.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printURIToIDMapContents(StringBuilder stringBuilder) {
        this.newLineIfNotEmpty(stringBuilder);
        stringBuilder.append("URI to ID map: ");
        stringBuilder.append("[");
        Iterator<Map.Entry<Object, Object>> iterator = this.mURItoIDMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    private void printWorkingDirectoryState(StringBuilder stringBuilder) {
        this.newLineIfNotEmpty(stringBuilder);
        stringBuilder.append("Working directory is: ");
        StringBuilder stringBuilder2 = stringBuilder;
        String string = this.mDirectory != null ? this.mDirectory.getAbsolutePath() : "null";
        stringBuilder2.append(string);
        if (this.mDirectory != null) {
            stringBuilder.append(", working directory: exists=");
            stringBuilder.append(this.mDirectory.exists());
            stringBuilder.append(" isDirectory=");
            stringBuilder.append(this.mDirectory.isDirectory());
        }
    }

    private void newLineIfNotEmpty(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append("\n");
        }
    }

    private void debugInputNotFound() {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            this.printWorkingDirectoryContents(stringBuilder);
            if (stringBuilder.length() > 0) {
                LOGGER.debug((Object)stringBuilder.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printWorkingDirectoryContents(StringBuilder stringBuilder) {
        if (this.mDirectory == null) return;
        if (!this.mDirectory.exists()) return;
        if (!this.mDirectory.isDirectory()) return;
        this.newLineIfNotEmpty(stringBuilder);
        stringBuilder.append("Files in the working directory: [");
        File[] fileArray = this.mDirectory.listFiles();
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file = fileArray[n2];
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(file.getName());
            stringBuilder.append("[isFile=");
            stringBuilder.append(file.isFile());
            stringBuilder.append("]");
            ++n2;
        }
        stringBuilder.append("]");
    }

    public OutputStream getOutput(String string) {
        try {
            if (!this.mURItoIDMap.containsKey(string)) {
                String string2 = this.createID(string);
                this.mURItoIDMap.setProperty(string, string2);
            }
            return new BufferedOutputStream(new FileOutputStream(this.getFile(string)), 65536);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private String createID(String string) {
        return this.idCreator.createFileName(string, this.mURItoIDMap.values());
    }

    public void commit() {
        try {
            File file = this.getDirectory();
            File file2 = new File(file, MAPFILENAME);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 65536);
            this.mURItoIDMap.store(bufferedOutputStream, "Storage of type:" + this.getClass().getName());
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Set<String> list() {
        return this.mURItoIDMap.stringPropertyNames();
    }

    public static class FileNameCreatorWithLengthLimitation {
        private int maxLength;

        public FileNameCreatorWithLengthLimitation(int n2) {
            this.maxLength = n2;
        }

        public String createFileName(String string, Collection collection) {
            int n2 = string.lastIndexOf("/");
            String string2 = string;
            if (n2 >= 0) {
                string2 = string.substring(n2 + 1).replace('?', '_');
            }
            if (collection.contains(string2 = this.truncateStringByRemovingMiddleSection(string2))) {
                return this.makeUniqe(collection, string2);
            }
            return string2;
        }

        private String makeUniqe(Collection collection, String string) {
            int n2 = 1;
            String string2 = String.valueOf(string) + n2;
            while (collection.contains(string2)) {
                string2 = String.valueOf(string) + ++n2;
            }
            return string2;
        }

        private String truncateStringByRemovingMiddleSection(String string) {
            if (string.length() > this.maxLength) {
                int n2 = this.maxLength / 2;
                string = String.valueOf(string.substring(0, n2)) + string.substring(string.length() - n2);
            }
            return string;
        }
    }

    private static class MkdirDiagnostics {
        private static final int diagnosticRetryCount = MkdirDiagnostics.initDiagnosticRetryCount();

        private MkdirDiagnostics() {
        }

        private static int initDiagnosticRetryCount() {
            int n2 = Integer.getInteger("ci.directory.data.diagnostic.retry.count", 5);
            if (n2 < 5) {
                n2 = 5;
            }
            return n2;
        }

        public static boolean mkdirsWithDiagnostics(File file) {
            Exception exception = null;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            try {
                bl = MkdirDiagnostics.mkdirs(file, stringBuilder);
            }
            catch (Exception exception2) {
                exception = exception2;
                bl = false;
            }
            LOGGER.info((Object)stringBuilder.toString());
            if (exception != null) {
                LOGGER.error((Object)"Error occurred which creating the directory: ", (Throwable)exception);
            }
            return bl;
        }

        private static boolean mkdirs(File file, StringBuilder stringBuilder) {
            block18: {
                stringBuilder.append("Current path: " + file.getPath()).append(", absolute path: ").append(file.getAbsolutePath()).append('\n');
                boolean bl = file.exists();
                stringBuilder.append("[exists]: ").append(bl).append('\n');
                MkdirDiagnostics.printFilePermissions(file, stringBuilder);
                if (bl) {
                    return false;
                }
                if (file.mkdir()) {
                    stringBuilder.append("[mkdir]: successful\n");
                    MkdirDiagnostics.printFilePermissions(file, stringBuilder);
                    return true;
                }
                stringBuilder.append("[mkdir]: unsuccessful\n");
                File file2 = null;
                try {
                    file2 = file.getCanonicalFile();
                    stringBuilder.append("[getCanonicalFile]: successful\n");
                }
                catch (IOException iOException) {
                    stringBuilder.append("[getCanonicalFile]: failed with error:\n");
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    iOException.printStackTrace(printWriter);
                    try {
                        stringWriter.close();
                        printWriter.close();
                        stringBuilder.append(stringWriter.toString());
                    }
                    catch (Exception exception) {
                        LOGGER.error((Object)exception);
                    }
                    return false;
                }
                File file3 = file2.getParentFile();
                String string = file3 != null ? "not null" : "null";
                String string2 = string;
                stringBuilder.append("[getParentFile]: ").append(string2).append('\n');
                if (file3 != null) {
                    stringBuilder.append("[invoking parent.mkdirs]...\n");
                    boolean bl2 = MkdirDiagnostics.mkdirs(file3, stringBuilder);
                    stringBuilder.append("Down to path: " + file.getPath()).append(", absolute path: ").append(file.getAbsolutePath()).append('\n');
                    stringBuilder.append("[parent.mkdirs]: ").append(bl2).append('\n');
                    boolean bl3 = file3.exists();
                    stringBuilder.append("[parent.exists]: ").append(bl3).append('\n');
                    if (!bl2 && !bl3) break block18;
                    boolean bl4 = file2.mkdir();
                    stringBuilder.append("[canonFile.mkdir]: ").append(bl4).append('\n');
                    if (bl4) {
                        MkdirDiagnostics.printFilePermissions(file2, stringBuilder);
                    }
                    return bl4;
                }
            }
            return false;
        }

        private static void printFilePermissions(File file, StringBuilder stringBuilder) {
            stringBuilder.append("[canRead]: ").append(file.canRead()).append('\n');
            stringBuilder.append("[canWrite]: ").append(file.canWrite()).append('\n');
            stringBuilder.append("[canExecute]: ").append(file.canExecute()).append('\n');
        }
    }
}

