/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.files;

import com.nomagic.ci.metamodel.binary.AbstractStreamIdentityBinaryObject;
import com.nomagic.ci.metamodel.binary.BinaryObject;
import com.nomagic.ci.metamodel.binary.StreamIdentityBinaryObject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.local.IResourcePool;
import com.nomagic.ci.persistence.local.proxy.resource.ProxySupporterResource;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IResourceUriMapper;
import com.nomagic.ci.persistence.local.spi.binary.BinaryObjectProviderUtil;
import com.nomagic.ci.persistence.local.spi.binary.IBinaryStreamContainer;
import com.nomagic.ci.persistence.local.spi.binary.ICentralStreamRepository;
import com.nomagic.ci.persistence.local.spi.binary.StreamIdentityFactory;
import com.nomagic.ci.persistence.local.spi.files.IReservedResourceHandle;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.ReservedResourcePersistence;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.lock.ILockManager;
import com.nomagic.ci.persistence.lock.Locking;
import com.nomagic.ci.persistence.util.MultiValueHashMap;
import com.nomagic.ci.persistence.util.ProjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class BinaryStreamContainer
implements IBinaryStreamContainer {
    private static final Logger LOGGER = Logger.getLogger(BinaryStreamContainer.class);
    public static final String INDEX_RESOURCE = "Binaries.properties";
    private static final IReservedResourceHandle INDEX = new IReservedResourceHandle(){

        @Override
        public boolean isReserved(String string) {
            return BinaryStreamContainer.INDEX_RESOURCE.equals(string);
        }
    };
    private static final IReservedResourceHandle BINARY = new IReservedResourceHandle(){

        @Override
        public boolean isReserved(String string) {
            return StreamIdentityFactory.isStreamContentID(string);
        }
    };
    private AbstractProject project;
    private IResourcePool binaries;
    private IResourcePool indexPersistence;
    private ReservedResourcePersistence persistence;
    private IResourceInfoDecoder resInfoProvider;

    public BinaryStreamContainer(AbstractProject abstractProject, ReservedResourcePersistence reservedResourcePersistence, IResourceInfoDecoder iResourceInfoDecoder) {
        this.project = abstractProject;
        this.binaries = reservedResourcePersistence.addHandle(BINARY);
        this.indexPersistence = reservedResourcePersistence.addHandle(INDEX);
        this.persistence = reservedResourcePersistence;
        this.resInfoProvider = iResourceInfoDecoder;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public InputStream getInputStream(String string) {
        return this.binaries.getResourceAsInputStream(string);
    }

    @Override
    public OutputStream getOutputStream(String string) {
        return this.binaries.getResourceAsOutputStream(string);
    }

    public boolean isStreamPresent(String string) {
        return this.binaries.isResourcePresent(string);
    }

    public void preloadIndex() throws IOException {
        BinaryStreamContainer.readIndex(this.indexPersistence);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeUpdate(IProgressMonitor iProgressMonitor) throws IOException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Synchronizing binary data...", 1000);
        try {
            Object object2;
            HashSet<String> hashSet = new HashSet<String>(this.binaries.getResources());
            Map<String, Set<String>> map = BinaryStreamContainer.readIndex(this.indexPersistence);
            Set<String> set = this.collectLockedByMeBinaries(hashSet);
            for (Object object2 : map.values()) {
                object2.stream().filter(((Predicate<String>)set::contains).negate()).forEach(hashSet::remove);
            }
            iProgressMonitor.worked(100);
            if (hashSet.isEmpty()) return;
            object2 = this.getCentralRepository();
            object2.push(hashSet, this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 900));
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private Set<String> collectLockedByMeBinaries(Set<String> set) {
        if (Locking.isProjectLockable((IProject)this.project)) {
            ILockManager iLockManager = Locking.getLockManager((IProject)this.project);
            return BinaryObjectProviderUtil.getBinaryObjects(this.project).stream().filter(binaryObject -> binaryObject instanceof StreamIdentityBinaryObject).map(binaryObject -> (StreamIdentityBinaryObject)binaryObject).filter(streamIdentityBinaryObject -> set.contains(streamIdentityBinaryObject.getStreamContentID())).filter(arg_0 -> ((ILockManager)iLockManager).isObjectLockedByMe(arg_0)).map(AbstractStreamIdentityBinaryObject::getStreamContentID).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeCommit(IProgressMonitor iProgressMonitor) throws IOException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Synchronizing binary data...", 1000);
        try {
            Object object;
            Set<String> set2;
            HashSet<String> hashSet = new HashSet<String>();
            Map<String, Set<String>> map = this.rebuildIndex((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            for (Set<String> set2 : map.values()) {
                if (set2 == null) continue;
                hashSet.addAll(set2);
            }
            set2 = new HashSet<String>(hashSet);
            set2.removeAll(this.binaries.getResources());
            HashSet<String> hashSet2 = new HashSet<String>(this.binaries.getResources());
            hashSet2.removeAll(hashSet);
            iProgressMonitor.worked(100);
            if (!set2.isEmpty()) {
                object = this.getCentralRepository();
                object.pull(set2, this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
            }
            if (!hashSet2.isEmpty()) {
                object = this.getCentralRepository();
                object.push((Set<String>)hashSet2, this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
            }
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                LOGGER.info((Object)("Deleting unused resource " + (String)object));
                this.binaries.deleteResource((String)object);
            }
            iProgressMonitor.worked(100);
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeRemove(IProgressMonitor iProgressMonitor) throws IOException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        Set<String> set = this.persistence.getResources();
        iProgressMonitor.beginTask("Backing-up binary data...", 1000);
        try {
            Object object2;
            HashSet<String> hashSet = new HashSet<String>(this.binaries.getResources());
            Map<String, Set<String>> map = BinaryStreamContainer.readIndex(this.indexPersistence);
            for (Object object2 : set) {
                Set<String> set2;
                if (this.getResource((String)object2) != null || (set2 = map.get(object2)) == null) continue;
                hashSet.removeAll(set);
            }
            iProgressMonitor.worked(100);
            if (hashSet.isEmpty()) return;
            object2 = this.getCentralRepository();
            object2.push(hashSet, this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 900));
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private ICentralStreamRepository getCentralRepository() {
        IPrimaryProject iPrimaryProject = ProjectUtil.getPrimaryProject((IProject)this.project);
        return (ICentralStreamRepository)iPrimaryProject.getService(ICentralStreamRepository.class);
    }

    private Map<String, Set<String>> rebuildIndex(IProgressMonitor iProgressMonitor) throws IOException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        Map<String, Set<String>> map = BinaryStreamContainer.readIndex(this.indexPersistence);
        Map<String, Set<String>> map2 = this.getIndexUpdater().update(map, iProgressMonitor);
        BinaryStreamContainer.writeIndex(map2, this.indexPersistence);
        return map2;
    }

    protected IndexUpdater getIndexUpdater() {
        return new IndexUpdater(this, this.persistence, new BinaryResourceUtil());
    }

    @CheckForNull
    public Resource getResource(String string) {
        ResourceInfo resourceInfo = this.resInfoProvider.getResourceInfo(string);
        if (resourceInfo != null) {
            URI uRI = this.getResourceURI(resourceInfo);
            return this.project.getResourceSet().getResource(uRI, false);
        }
        return null;
    }

    private URI getResourceURI(ResourceInfo resourceInfo) {
        String string = resourceInfo.getNamespace();
        String string2 = resourceInfo.getResourceName();
        String string3 = resourceInfo.getUserId();
        IResourceUriMapper iResourceUriMapper = this.project.getUriMapper();
        return string3 == null ? iResourceUriMapper.getResourceURI(string, string2) : iResourceUriMapper.getPersonalResourceURI(string3, string, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Set<String>> readIndex(IResourcePool iResourcePool) throws IOException {
        MultiValueHashMap multiValueHashMap = new MultiValueHashMap();
        Properties properties = new Properties();
        InputStream inputStream = iResourcePool.getResourceAsInputStream(INDEX_RESOURCE);
        if (inputStream != null) {
            properties.load(inputStream);
            inputStream.close();
        }
        for (String string : properties.stringPropertyNames()) {
            String string2 = properties.getProperty(string);
            String[] stringArray = string2.split(",");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray[n3];
                multiValueHashMap.append((Object)string, (Object)string3);
                ++n3;
            }
        }
        return multiValueHashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeIndex(Map<String, Set<String>> map, IResourcePool iResourcePool) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                stringBuilder.append(string);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            properties.setProperty(entry.getKey(), stringBuilder.toString());
        }
        try (OutputStream outputStream = iResourcePool.getResourceAsOutputStream(INDEX_RESOURCE);){
            properties.store(outputStream, "");
            return;
        }
    }

    public static class BinaryResourceUtil {
        public Set<String> getStreamsInUse(Resource resource) {
            Set<String> set = Collections.emptySet();
            Collection<BinaryObject> collection = BinaryObjectProviderUtil.getBinaryObjects(resource);
            if (collection != null && !collection.isEmpty()) {
                set = new HashSet<String>();
                for (BinaryObject binaryObject : collection) {
                    StreamIdentityBinaryObject streamIdentityBinaryObject;
                    String string;
                    if (!(binaryObject instanceof StreamIdentityBinaryObject) || !binaryObject.isInputStreamAvailable() || (string = (streamIdentityBinaryObject = (StreamIdentityBinaryObject)binaryObject).getStreamContentID()) == null || !StreamIdentityFactory.isStreamContentID(string)) continue;
                    set.add(string);
                }
            }
            return set;
        }

        public boolean canProvideStreamsInUse(Resource resource) {
            if (resource instanceof ProxySupporterResource) {
                ProxySupporterResource proxySupporterResource = (ProxySupporterResource)resource;
                return !proxySupporterResource.isProxyContainer();
            }
            return true;
        }
    }

    public static class IndexUpdater {
        private BinaryStreamContainer binaryStreamContainer;
        private ReservedResourcePersistence persistence;
        private BinaryResourceUtil resourceUtil;

        public IndexUpdater(BinaryStreamContainer binaryStreamContainer, ReservedResourcePersistence reservedResourcePersistence, BinaryResourceUtil binaryResourceUtil) {
            this.binaryStreamContainer = binaryStreamContainer;
            this.persistence = reservedResourcePersistence;
            this.resourceUtil = binaryResourceUtil;
        }

        public Map<String, Set<String>> update(Map<String, Set<String>> map, IProgressMonitor iProgressMonitor) {
            Set<String> set = this.persistence.getResources();
            iProgressMonitor.beginTask("Building binary data index...", 100 * set.size());
            try {
                for (String object2 : set) {
                    Resource resource = this.binaryStreamContainer.getResource(object2);
                    if (resource != null && this.resourceUtil.canProvideStreamsInUse(resource)) {
                        Set<String> set2 = this.resourceUtil.getStreamsInUse(resource);
                        map.put(object2, set2);
                    }
                    iProgressMonitor.worked(100);
                }
                Iterator<String> iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    if (set.contains(string)) continue;
                    iterator.remove();
                }
                Map<String, Set<String>> map2 = map;
                return map2;
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }
}

