/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.features.dependency;

import com.nomagic.ci.persistence.local.features.dependency.DependencyInfo;
import com.nomagic.ci.persistence.local.internal.e.a.a;
import com.nomagic.ci.persistence.local.spi.IChangedObjectsTracker;
import com.nomagic.ci.persistence.local.util.DependencyCrossReferencer;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ChangedObjectsDependencyFinder
extends a {
    IChangedObjectsTracker project;
    Set<EObject> allChangedObjects;

    public ChangedObjectsDependencyFinder(IChangedObjectsTracker iChangedObjectsTracker) {
        this.project = iChangedObjectsTracker;
        this.allChangedObjects = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareChangedObjects(IProgressMonitor iProgressMonitor) {
        Set<EObject> set = this.project.getChangedObjects(iProgressMonitor);
        this.allChangedObjects = set;
        HashSet<EObject> hashSet = new HashSet<EObject>();
        for (EObject eObject : set) {
            if (!this.project.hasResourceChange(eObject)) continue;
            hashSet.add(eObject);
        }
        if (hashSet.isEmpty()) return;
        this.allChangedObjects = new HashSet<EObject>(set);
        for (EObject eObject : hashSet) {
            TreeIterator treeIterator = EcoreUtil.getAllProperContents((EObject)eObject, (boolean)false);
            while (treeIterator.hasNext()) {
                EObject eObject2 = (EObject)treeIterator.next();
                if (hashSet.contains(eObject2)) {
                    treeIterator.prune();
                }
                this.allChangedObjects.add(eObject2);
            }
        }
    }

    public Set<EObject> getAllChangedObjects() {
        return this.allChangedObjects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<DependencyInfo<?>> findDependencies(IProgressMonitor iProgressMonitor, Resource resource, boolean bl) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("", 1000);
            if (this.allChangedObjects == null) {
                throw new IllegalStateException("Changed objects set not prepared");
            }
            if (LocalProjectUtil.getProject(resource) != this.project) {
                throw new IllegalArgumentException("The resource does not belong to the context project");
            }
            iProgressMonitor.subTask("Collecting resource objects...");
            HashSet<EObject> hashSet = new HashSet<EObject>();
            for (Object object : this.allChangedObjects) {
                if (object.eResource() != resource) continue;
                hashSet.add((EObject)object);
            }
            iProgressMonitor.worked(100);
            if (!hashSet.isEmpty()) {
                Object object;
                iProgressMonitor.subTask("Finding references...");
                object = new ChangedObjectsDependencyCrossReferencer(resource, hashSet);
                Set<DependencyInfo<?>> set = ((DependencyCrossReferencer)((Object)object)).findDependencies((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
                return set;
            }
            Set<DependencyInfo<?>> set = Collections.emptySet();
            return set;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private static class ChangedObjectsDependencyCrossReferencer
    extends DependencyCrossReferencer {
        private static final long serialVersionUID = 1L;
        Set<EObject> changedObjects;

        public ChangedObjectsDependencyCrossReferencer(Resource resource, Set<EObject> set) {
            super(resource);
            this.changedObjects = set;
        }

        @Override
        protected boolean containment(EObject eObject) {
            return true;
        }

        @Override
        protected TreeIterator<Notifier> newContentsIterator() {
            return new FlatIterator(this.changedObjects.iterator());
        }
    }

    private static class FlatIterator
    implements TreeIterator<Notifier> {
        Iterator<EObject> iterator;

        public FlatIterator(Iterator<EObject> iterator) {
            this.iterator = iterator;
        }

        public void prune() {
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Notifier next() {
            return (Notifier)this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

