/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.features;

import com.nomagic.ci.metamodel.local.project.LocalDataSection;
import com.nomagic.ci.metamodel.local.project.LocalProject;
import com.nomagic.ci.metamodel.local.project.LocalProjectFeature;
import com.nomagic.ci.metamodel.local.project.ProjectFactory;
import com.nomagic.ci.metamodel.project.Project;
import com.nomagic.ci.metamodel.project.ProjectFeature;
import com.nomagic.ci.metamodel.project.util.DecompositionModelUtil;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.features.FeatureDependencyException;
import com.nomagic.ci.persistence.features.IProjectFeature;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import com.nomagic.ci.persistence.features.IProjectFeatureHandler;
import com.nomagic.ci.persistence.features.IProjectFeatureHandlerService;
import com.nomagic.ci.persistence.local.features.FeatureResourceManagerFactory;
import com.nomagic.ci.persistence.local.importers.IProjectDataProvider;
import com.nomagic.ci.persistence.local.importers.SharePointData;
import com.nomagic.ci.persistence.local.mounting.IMountingProjectFeatureHandler;
import com.nomagic.ci.persistence.local.sharing.IObjectLevelSharingManagerFactory;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.ProjectFeatureResources;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusEvent;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusEventImpl;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusSupport;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventType;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventTypeImpl;
import com.nomagic.ci.persistence.local.spi.sharing.IObjectLevelSharingManagerInternal;
import com.nomagic.ci.persistence.resources.IProjectResourceManager;
import com.nomagic.ci.persistence.services.IProjectService;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import com.nomagic.ci.persistence.spi.features.AbstractFeatureInitializer;
import com.nomagic.ci.persistence.spi.features.IProjectFeatureRegistry;
import com.nomagic.ci.services.SingletonServiceDiscovery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;

public class LocalFeatureInitializer
extends AbstractFeatureInitializer
implements IProjectService {
    public static final ServiceEventType IMPORT_FEATURE_EVENT_TYPE = new ServiceEventTypeImpl("IMPORT_FEATURE", AbstractFeatureInitializer.class);
    public static final ServiceEventType READ_FEATURE_EVENT_TYPE = new ServiceEventTypeImpl("READ_FEATURE", AbstractFeatureInitializer.class);
    public static final ServiceEventType UNISTALED_FEATURE_EVENT_TYPE = new ServiceEventTypeImpl("UNISTALED_FEATURE", AbstractFeatureInitializer.class);
    public static final ServiceEventType INSTALED_FEATURE_EVENT_TYPE = new ServiceEventTypeImpl("INSTALED_FEATURE", AbstractFeatureInitializer.class);
    private ServiceBusSupport serviceBusSupport;

    public LocalFeatureInitializer(AbstractProject abstractProject, IProjectFeatureRegistry iProjectFeatureRegistry, ServiceBusSupport serviceBusSupport) {
        super((IProject)abstractProject, iProjectFeatureRegistry);
        this.serviceBusSupport = serviceBusSupport;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importFeatures(IProjectDataProvider iProjectDataProvider, boolean bl, IProgressMonitor iProgressMonitor) throws ProjectConfigurationException, FeatureDependencyException {
        Set<String> set = iProjectDataProvider.getFeatures(this.project);
        IProjectFeatureHandlerService iProjectFeatureHandlerService = (IProjectFeatureHandlerService)SingletonServiceDiscovery.INSTANCE.getService(IProjectFeatureHandlerService.class);
        IDecompositionModel iDecompositionModel = (IDecompositionModel)this.project.getService(IDecompositionModel.class);
        if (iDecompositionModel == null) {
            throw new ProjectConfigurationException("Project has no decomposition feature");
        }
        if (bl && !(this.project instanceof IAttachedProject)) {
            throw new ProjectConfigurationException("Can not perform shallow read for non attached project");
        }
        LocalProject localProject = (LocalProject)iDecompositionModel.getDecompositionProject();
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            List list = iProjectFeatureHandlerService.getHandlers(set);
            iProgressMonitor.beginTask("Importing features...", 300 * list.size());
            for (IProjectFeatureHandler iProjectFeatureHandler : list) {
                LocalProjectFeature localProjectFeature = (LocalProjectFeature)DecompositionModelUtil.findProjectFeature((Project)localProject, (String)iProjectFeatureHandler.getNamespace());
                int n2 = 300;
                boolean bl2 = false;
                if (localProjectFeature == null) {
                    bl2 = true;
                    localProjectFeature = ProjectFactory.eINSTANCE.createProjectFeature();
                    localProjectFeature.setProject(localProject);
                    LocalFeatureInitializer.updateFeature((ProjectFeature)localProjectFeature, (IProjectFeatureDescriptor)iProjectFeatureHandler);
                }
                if (!bl || iProjectFeatureHandler instanceof IMountingProjectFeatureHandler) {
                    Object object;
                    IProjectFeature iProjectFeature;
                    if (set.contains(iProjectFeatureHandler.getName())) {
                        iProjectFeature = iProjectDataProvider.importFeature(this.project, iProjectFeatureHandler, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                        n2 -= 200;
                        this.updateFeatureInRegistry(iProjectFeatureHandler.getName(), iProjectFeature);
                        if (iProjectFeatureHandler instanceof IMountingProjectFeatureHandler) {
                            object = (IMountingProjectFeatureHandler)iProjectFeatureHandler;
                            IObjectLevelSharingManagerInternal iObjectLevelSharingManagerInternal = (IObjectLevelSharingManagerInternal)((IObjectLevelSharingManagerFactory)this.project.getService(IObjectLevelSharingManagerFactory.class)).createManager((IMountingProjectFeatureHandler)object);
                            Set<SharePointData> set2 = iProjectDataProvider.getSharePoints(this.project, (IMountingProjectFeatureHandler)iProjectFeatureHandler);
                            iObjectLevelSharingManagerInternal.importSharePoints(set2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                        } else {
                            iProgressMonitor.worked(100);
                        }
                        n2 -= 100;
                        object = new ServiceBusEventImpl((Object)this, IMPORT_FEATURE_EVENT_TYPE, localProjectFeature.getName());
                        this.serviceBusSupport.fireEvent((ServiceBusEvent)object);
                    } else if (bl2) {
                        iProjectFeature = iProjectFeatureHandler.install(this.project);
                        this.updateFeatureInRegistry(iProjectFeatureHandler.getName(), iProjectFeature);
                        iProgressMonitor.worked(300);
                        n2 -= 300;
                        object = new ServiceBusEventImpl((Object)this, INSTALED_FEATURE_EVENT_TYPE, iProjectFeatureHandler.getName());
                        ((AbstractProject)this.project).getServiceBusSupport().fireEvent((ServiceBusEvent)object);
                    }
                }
                if (n2 <= 0) continue;
                iProgressMonitor.worked(n2);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void updateFeatureInRegistry(String string, IProjectFeature iProjectFeature) {
        IProjectFeature iProjectFeature2 = this.registry.getFeature(string);
        if (iProjectFeature2 != null) {
            this.registry.removeFeature(iProjectFeature2);
        }
        if (iProjectFeature != null) {
            this.registry.addFeature(iProjectFeature);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(final boolean bl, IProgressMonitor iProgressMonitor) throws ProjectConfigurationException, IOException {
        if (bl && !(this.project instanceof IAttachedProject)) {
            throw new ProjectConfigurationException("Can not perform shallow read for non attached project");
        }
        this.read(new AbstractFeatureInitializer.ReadCoordinator(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean canRead(ProjectFeature projectFeature, IProjectFeatureHandler iProjectFeatureHandler) {
                return !bl || iProjectFeatureHandler instanceof IMountingProjectFeatureHandler;
            }

            @CheckForNull
            public IProjectFeature read(ProjectFeature projectFeature, IProjectFeatureHandler iProjectFeatureHandler) throws ProjectConfigurationException {
                if (bl) {
                    return ((IMountingProjectFeatureHandler)iProjectFeatureHandler).readShallow((IAttachedProject)LocalFeatureInitializer.this.project, LocalFeatureInitializer.getDescriptor((ProjectFeature)projectFeature));
                }
                return iProjectFeatureHandler.read(LocalFeatureInitializer.this.project, LocalFeatureInitializer.getDescriptor((ProjectFeature)projectFeature));
            }
        }, iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        List list = LocalFeatureInitializer.getAvailableFeatureHandlers((IProject)this.project);
        iProgressMonitor.beginTask("Updating project features...", 100 * list.size());
        try {
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry entry : list) {
                IProjectFeature iProjectFeature;
                ProjectFeature projectFeature = (ProjectFeature)entry.getKey();
                IProjectFeatureHandler iProjectFeatureHandler = (IProjectFeatureHandler)entry.getValue();
                String string = projectFeature.getName();
                hashSet.add(string);
                if (this.registry.getFeature(string) == null && (iProjectFeature = iProjectFeatureHandler.read(this.project, LocalFeatureInitializer.getDescriptor((ProjectFeature)projectFeature))) != null) {
                    this.registry.addFeature(iProjectFeature);
                }
                iProgressMonitor.worked(100);
            }
            for (Map.Entry entry : new ArrayList(this.registry.getFeatures())) {
                if (hashSet.contains(entry.getDescriptor().getName())) continue;
                this.registry.removeFeature((IProjectFeature)entry);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public List<ProjectFeatureResources> getFeatureResources() {
        return LocalFeatureInitializer.getFeatureResources(this.project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ProjectFeatureResources> getFeatureResources(IProject iProject) {
        List<ProjectFeatureResources> list = Collections.emptyList();
        IDecompositionModel iDecompositionModel = (IDecompositionModel)iProject.getService(IDecompositionModel.class);
        if (iDecompositionModel != null && iDecompositionModel.isAvailable()) {
            list = new ArrayList<ProjectFeatureResources>();
            LocalProject localProject = (LocalProject)iDecompositionModel.getDecompositionProject();
            for (LocalProjectFeature localProjectFeature : localProject.getFeatures()) {
                IProjectFeatureDescriptor iProjectFeatureDescriptor = LocalFeatureInitializer.getDescriptor((ProjectFeature)localProjectFeature);
                ArrayList<ProjectFeatureResources.FeatureResourceDescriptor> arrayList = new ArrayList<ProjectFeatureResources.FeatureResourceDescriptor>();
                for (LocalDataSection localDataSection : localProjectFeature.getAccessibleSections()) {
                    ProjectFeatureResources.FeatureResourceDescriptor featureResourceDescriptor = new ProjectFeatureResources.FeatureResourceDescriptor(localDataSection.getName(), localDataSection.isShared(), localDataSection.isPersonal());
                    arrayList.add(featureResourceDescriptor);
                }
                list.add(new ProjectFeatureResources(iProjectFeatureDescriptor, arrayList));
            }
        }
        return list;
    }

    @CheckForNull
    protected AbstractFeatureInitializer.EventSupport createEventSupport() {
        return new EventSupportImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeFeatureResources(IProjectFeatureHandler iProjectFeatureHandler) {
        IProjectResourceManager iProjectResourceManager = FeatureResourceManagerFactory.getResourceManager(this.project, (IProjectFeatureDescriptor)iProjectFeatureHandler);
        for (String string : iProjectResourceManager.getResourceNames()) {
            Resource resource = iProjectResourceManager.getResource(string, false);
            if (resource == null) continue;
            try {
                resource.delete(null);
            }
            catch (IOException iOException) {
                throw new ProjectConfigurationException(iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    private class EventSupportImpl
    implements AbstractFeatureInitializer.EventSupport {
        private EventSupportImpl() {
        }

        public void featureInstalled(IProjectFeatureHandler iProjectFeatureHandler) {
            ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl((Object)LocalFeatureInitializer.this, INSTALED_FEATURE_EVENT_TYPE, iProjectFeatureHandler.getName());
            LocalFeatureInitializer.this.serviceBusSupport.fireEvent(serviceBusEventImpl);
        }

        public void featureRead(ProjectFeature projectFeature) {
            ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl((Object)LocalFeatureInitializer.this, READ_FEATURE_EVENT_TYPE, projectFeature.getName());
            LocalFeatureInitializer.this.serviceBusSupport.fireEvent(serviceBusEventImpl);
        }

        public void featureUninstalled(ProjectFeature projectFeature) {
            ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl((Object)LocalFeatureInitializer.this, UNISTALED_FEATURE_EVENT_TYPE, projectFeature.getName());
            LocalFeatureInitializer.this.serviceBusSupport.fireEvent(serviceBusEventImpl);
        }
    }
}

