/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.events;

import com.nomagic.ci.event.AbstractEventSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CompositeEventSupport<L, E, T extends AbstractEventSupport<L, E>> {
    T preEventSupport;
    T eventSupport;
    T postEventSupport;

    public CompositeEventSupport(T t2, T t3, T t4) {
        this.preEventSupport = t2;
        this.eventSupport = t3;
        this.postEventSupport = t4;
    }

    public final void fireEvent(E e2, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("Firing event...", 3000);
            this.preEventSupport.fireEvent(e2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            this.eventSupport.fireEvent(e2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            this.postEventSupport.fireEvent(e2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public final void fireEvent(E e2) {
        this.preEventSupport.fireEvent(e2);
        this.eventSupport.fireEvent(e2);
        this.postEventSupport.fireEvent(e2);
    }

    public T getEventSupport() {
        return this.eventSupport;
    }

    public T getPreEventSupport() {
        return this.preEventSupport;
    }

    public T getPostEventSupport() {
        return this.postEventSupport;
    }
}

