/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.decompositionversion;

import com.nomagic.ci.metamodel.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.emf.common.util.EMap;

public class DecompositionVersionUtility {
    private static final String VERSION_KEY = "CI_VERSION";
    private static List<String> VERSIONS_IN_ORDER = new ArrayList<String>();

    public static Version getCurrentVersion() {
        return Version.V1702_SP1;
    }

    public static boolean isBeforeVersion(@Nonnull Version version, @Nonnull EMap<String, String> eMap) {
        String string = DecompositionVersionUtility.getCurrentVersion(eMap);
        return string == null || DecompositionVersionUtility.getVersionIndex(string) < DecompositionVersionUtility.getVersionIndex(version.text);
    }

    private static int getVersionIndex(@Nonnull String string) {
        return VERSIONS_IN_ORDER.indexOf(string);
    }

    @CheckForNull
    private static String getCurrentVersion(@Nonnull EMap<String, String> eMap) {
        return (String)eMap.get((Object)VERSION_KEY);
    }

    public static void saveCurrentVersionToProjectProperties(@Nonnull Project project) {
        DecompositionVersionUtility.writeVersionInMap((EMap<String, String>)project.getProperties(), DecompositionVersionUtility.getCurrentVersion());
    }

    public static boolean isBeforeVersion(@Nonnull Version version, @Nonnull Project project) {
        return DecompositionVersionUtility.isBeforeVersion(version, (EMap<String, String>)project.getProperties());
    }

    public static Object writeVersionInMap(@Nonnull EMap<String, String> eMap, @Nonnull Version version) {
        return eMap.put((Object)VERSION_KEY, (Object)version.text);
    }

    public static enum Version {
        V1702_SP1("V1702_SP1"),
        V1702_SP2("V1702_SP2");

        final String text;

        private Version(String string2) {
            this.text = string2;
            VERSIONS_IN_ORDER.add(this.text);
        }
    }
}

