/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.decomposition;

import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.IProjectRepositoryType;
import com.nomagic.ci.persistence.local.ProjectRepositoryRegistry;
import com.nomagic.ci.persistence.local.spi.IVersionableProjectRepositoryInternal;
import com.nomagic.ci.persistence.local.spi.decomposition.IProjectUsageResolver;
import com.nomagic.ci.persistence.versioning.IVersionDescriptor;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;

public abstract class ProjectUsageVersionResolver
implements IProjectUsageResolver {
    private IProjectRepository repository;

    public ProjectUsageVersionResolver(IProjectRepository iProjectRepository) {
        this.repository = iProjectRepository;
    }

    public IProjectRepository getRepository() {
        return this.repository;
    }

    @Override
    public IVersionDescriptor getProjectVersion(ProjectUsage projectUsage) {
        URI uRI;
        IVersionDescriptor iVersionDescriptor = null;
        String string = projectUsage.getVersion();
        if (string != null && (uRI = this.getProjectURI(projectUsage)) != null) {
            iVersionDescriptor = this.getVersionDescriptor(uRI, string);
        }
        return iVersionDescriptor;
    }

    protected IVersionDescriptor getVersionDescriptor(URI uRI, String string) {
        IVersionDescriptor iVersionDescriptor = null;
        IVersionableProjectRepositoryInternal iVersionableProjectRepositoryInternal = this.findSourceRepository(uRI);
        if (iVersionableProjectRepositoryInternal != null) {
            iVersionDescriptor = iVersionableProjectRepositoryInternal.getDescriptorByVersionName(uRI, string);
        }
        return iVersionDescriptor;
    }

    protected IVersionableProjectRepositoryInternal findSourceRepository(URI uRI) {
        if (this.repository instanceof IVersionableProjectRepositoryInternal && this.repository.canOpenProject(uRI)) {
            return (IVersionableProjectRepositoryInternal)this.repository;
        }
        ProjectRepositoryRegistry projectRepositoryRegistry = ProjectRepositoryRegistry.getInstance();
        Collection<IProjectRepositoryType> collection = projectRepositoryRegistry.getSupportingRepositoryTypes(uRI);
        for (IProjectRepositoryType iProjectRepositoryType : collection) {
            for (IProjectRepository iProjectRepository : projectRepositoryRegistry.getProjectRepositoriesByType(iProjectRepositoryType)) {
                if (!(iProjectRepository instanceof IVersionableProjectRepositoryInternal) || !iProjectRepository.canOpenProject(uRI)) continue;
                return (IVersionableProjectRepositoryInternal)iProjectRepository;
            }
        }
        return null;
    }
}

