/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.local.decomposition.ProjectStructureEditorSimulator;
import com.nomagic.ci.persistence.local.internal.m.b;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.spi.decomposition.AttachedProjectRemoveService;
import com.nomagic.ci.persistence.spi.decomposition.AttachmentSet;
import com.nomagic.ci.persistence.spi.decomposition.DecompositionUtil;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.util.ProjectUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProjectStructureEditorSimulatorImpl
implements ProjectStructureEditorSimulator {
    IPrimaryProject primary;

    public ProjectStructureEditorSimulatorImpl(IPrimaryProject iPrimaryProject) {
        this.primary = iPrimaryProject;
    }

    @Override
    public ProjectStructureEditorSimulator.SimulationEnvironment startSimulation() {
        return new SimulationEnvironmentImpl();
    }

    public IProject getProject() {
        return this.primary;
    }

    private class SimulationEnvironmentImpl
    implements ProjectStructureEditorSimulator.SimulationEnvironment {
        private Set<IAttachedProject> removedProjects = new HashSet<IAttachedProject>();
        private Set<IProject> modifiedProjects = new HashSet<IProject>();
        private AttachmentSet removedAttachments = new AttachmentSet();
        private Map<IAttachedProject, Boolean> manuallyReachableCache = new HashMap<IAttachedProject, Boolean>();

        private SimulationEnvironmentImpl() {
        }

        @Override
        public void detachProject(IProject iProject, IProject iProject2) {
            this.validateAttachment(iProject, iProject2);
            this.doDetachProject(iProject, iProject2);
            this.removeAccordingToRemovedAttachments();
        }

        private void doDetachProject(IProject iProject, IProject iProject2) {
            this.removedAttachments.addAttachment(iProject, iProject2);
            this.modifiedProjects.add(iProject);
        }

        private void validateAttachment(IProject iProject, IProject iProject2) {
            this.checkImputProject(iProject2);
            this.checkImputProject(iProject);
            if (this.removedAttachments.containsAttachment(iProject, iProject2)) {
                throw new RuntimeException("Attachment already removed");
            }
            IProjectDecompositionManager iProjectDecompositionManager = (IProjectDecompositionManager)iProject.getService(IProjectDecompositionManager.class);
            Set set = iProjectDecompositionManager.getAttachedProjects().keySet();
            if (!set.contains(iProject2)) {
                throw new RuntimeException("Attachment does not exist in actual project structure");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void removeAccordingToRemovedAttachments() {
            Map map = DecompositionUtil.toReverseUsageMap((AttachmentSet)this.removedAttachments);
            Set set = DecompositionUtil.calcProjectsToRemove((Map)map);
            this.removedProjects.addAll(set);
            this.modifiedProjects.removeAll(set);
            AttachmentSet attachmentSet = new AttachmentSet();
            for (IProject iProject : this.removedAttachments.getAttachingProjects()) {
                if (this.removedProjects.contains(iProject)) continue;
                for (IProject iProject2 : this.removedAttachments.getAttachedProjects(iProject)) {
                    attachmentSet.addAttachment(iProject, iProject2);
                }
            }
            this.removedAttachments = attachmentSet;
            this.manuallyReachableCache.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void removeProjects(Set<IAttachedProject> set) {
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("Projects to remove not provided");
            }
            for (IAttachedProject iAttachedProject : set) {
                this.checkImputProject((IProject)iAttachedProject);
            }
            Map map = AttachedProjectRemoveService.calcUsagesToDiscard(set, (AttachmentSet)this.removedAttachments, this.removedProjects);
            for (Object object : map.entrySet()) {
                for (IProject iProject : (Set)object.getValue()) {
                    this.removedAttachments.addAttachment(iProject, (IProject)object.getKey());
                    this.modifiedProjects.add(iProject);
                }
            }
            this.removeAccordingToRemovedAttachments();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void bulkDetach(AttachmentSet attachmentSet) {
            if (attachmentSet == null || attachmentSet.isEmpty()) {
                throw new IllegalArgumentException("No attachments provided");
            }
            for (IProject iProject : attachmentSet.getAttachingProjects()) {
                for (IProject iProject2 : attachmentSet.getAttachedProjects(iProject)) {
                    this.validateAttachment(iProject, iProject2);
                }
            }
            for (IProject iProject : attachmentSet.getAttachingProjects()) {
                for (IProject iProject2 : attachmentSet.getAttachedProjects(iProject)) {
                    this.doDetachProject(iProject, iProject2);
                }
            }
            this.removeAccordingToRemovedAttachments();
        }

        @Override
        public Set<IAttachedProject> getRemovedProjects() {
            return new HashSet<IAttachedProject>(this.removedProjects);
        }

        @Override
        public Set<IProject> getModifiedProjects() {
            return new HashSet<IProject>(this.modifiedProjects);
        }

        @Override
        public AttachmentSet getRemovedAttachments() {
            return this.removedAttachments.createCopy();
        }

        @Override
        public boolean isManuallyReachable(IAttachedProject iAttachedProject) {
            if (iAttachedProject.getPrimaryProject() != ProjectStructureEditorSimulatorImpl.this.primary) {
                return false;
            }
            if (this.removedProjects.contains(iAttachedProject)) {
                return false;
            }
            Boolean bl = this.manuallyReachableCache.get(iAttachedProject);
            if (bl == null) {
                boolean bl2 = b.a((IProject)ProjectStructureEditorSimulatorImpl.this.primary, (IProject)iAttachedProject, this.removedAttachments, this.removedProjects);
                this.manuallyReachableCache.put(iAttachedProject, bl2);
                return bl2;
            }
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<IProject, AbstractProjectAttachmentConfiguration> getAttachedProjects(IProject iProject) {
            this.checkImputProject(iProject);
            IProjectDecompositionManager iProjectDecompositionManager = (IProjectDecompositionManager)iProject.getService(IProjectDecompositionManager.class);
            HashMap<IProject, AbstractProjectAttachmentConfiguration> hashMap = new HashMap<IProject, AbstractProjectAttachmentConfiguration>(iProjectDecompositionManager.getAttachedProjects());
            if (!this.removedAttachments.isEmpty()) {
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    IProject iProject2 = (IProject)iterator.next();
                    if (!this.removedProjects.contains(iProject2) && !this.removedAttachments.containsAttachment(iProject, iProject2)) continue;
                    iterator.remove();
                }
            }
            return hashMap;
        }

        private void checkImputProject(IProject iProject) {
            if (iProject == null) {
                throw new IllegalArgumentException("null not permitted");
            }
            if (this.removedProjects.contains(iProject)) {
                throw new RuntimeException("The project has already been removed");
            }
            if (ProjectUtil.getPrimaryProject((IProject)iProject) != ProjectStructureEditorSimulatorImpl.this.primary) {
                throw new RuntimeException("Attachment does not exist in actual project structure");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<IProject, AbstractProjectAttachmentConfiguration> getAttachingProjects(IProject iProject) {
            this.checkImputProject(iProject);
            IProjectDecompositionManager iProjectDecompositionManager = (IProjectDecompositionManager)iProject.getService(IProjectDecompositionManager.class);
            HashMap<IProject, AbstractProjectAttachmentConfiguration> hashMap = new HashMap<IProject, AbstractProjectAttachmentConfiguration>(iProjectDecompositionManager.getAttachingProjects());
            if (!this.removedAttachments.isEmpty()) {
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    IProject iProject2 = (IProject)iterator.next();
                    if (!this.removedProjects.contains(iProject2) && !this.removedAttachments.containsAttachment(iProject2, iProject)) continue;
                    iterator.remove();
                }
            }
            return hashMap;
        }
    }
}

