/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.LockAcquisitionException;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.decomposition.IProjectFeatureProvider;
import com.nomagic.ci.persistence.decomposition.SubstituteObjectRegistry;
import com.nomagic.ci.persistence.features.AbstractFeatureException;
import com.nomagic.ci.persistence.features.FeatureDependencyException;
import com.nomagic.ci.persistence.features.FeatureNotInstalledException;
import com.nomagic.ci.persistence.features.FeaturesNotSpecifiedException;
import com.nomagic.ci.persistence.features.IProjectFeatureHandler;
import com.nomagic.ci.persistence.features.IProjectFeatureHandlerService;
import com.nomagic.ci.persistence.local.decomposition.ICustomFeatureJoiner;
import com.nomagic.ci.persistence.local.decomposition.IProjectJoiningFeatureProvider;
import com.nomagic.ci.persistence.local.decomposition.IProjectJoiningService;
import com.nomagic.ci.persistence.local.spi.decomposition.ProjectJointServiceSupport;
import com.nomagic.ci.persistence.lock.ILock;
import com.nomagic.ci.persistence.lock.ILockManager;
import com.nomagic.ci.persistence.lock.Locking;
import com.nomagic.ci.persistence.spi.decomposition.AbstractPartitioningService;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.spi.decomposition.IllegalProjectRelationshipException;
import com.nomagic.ci.persistence.util.ProjectUtil;
import com.nomagic.ci.services.SingletonServiceDiscovery;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class ProjectJoiningService
extends AbstractPartitioningService
implements IProjectJoiningService {
    private final ProjectJointServiceSupport mProjectJointServiceSupport;

    public ProjectJoiningService(IProject iProject, ProjectJointServiceSupport projectJointServiceSupport) {
        super(iProject);
        this.mProjectJointServiceSupport = projectJointServiceSupport;
    }

    @Override
    public void join(IAttachedProject iAttachedProject, IProjectJoiningFeatureProvider iProjectJoiningFeatureProvider, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.doJoin(iAttachedProject, iProjectJoiningFeatureProvider, null, iProgressMonitor);
    }

    @Override
    public void join(IAttachedProject iAttachedProject, IProjectJoiningFeatureProvider iProjectJoiningFeatureProvider, @CheckForNull Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.doJoin(iAttachedProject, iProjectJoiningFeatureProvider, map, iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doJoin(IAttachedProject iAttachedProject, IProjectJoiningFeatureProvider iProjectJoiningFeatureProvider, @CheckForNull Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Joining project...", 1400);
        try {
            this.report((Exception)((Object)this.checkAttached(iAttachedProject, map)));
            this.report((Exception)this.checkFeatures(iAttachedProject, iProjectJoiningFeatureProvider));
            this.report((Exception)((Object)this.mProjectJointServiceSupport.checkMounting(iAttachedProject, iProjectJoiningFeatureProvider, this.project)));
            iProgressMonitor.worked(100);
            this.interceptJoin(iAttachedProject, iProjectJoiningFeatureProvider);
            Set set = iProjectJoiningFeatureProvider.getFeatures();
            int n2 = this.getWorkPerUnit(300, set.size());
            IProjectFeatureHandlerService iProjectFeatureHandlerService = this.getFeatureHandlerService();
            HashSet<EObject> hashSet = new HashSet<EObject>();
            HashMap<String, ICustomFeatureJoiner> hashMap = new HashMap<String, ICustomFeatureJoiner>();
            this.addLocksAndFeatureJoiners(iAttachedProject, iProjectJoiningFeatureProvider, iProjectFeatureHandlerService, set, hashSet, hashMap);
            this.lockObjects(iProgressMonitor, hashSet);
            this.mProjectJointServiceSupport.prepare(iAttachedProject, this.getProject());
            try {
                SubstituteObjectRegistry substituteObjectRegistry = new SubstituteObjectRegistry();
                List list = iProjectFeatureHandlerService.getHandlers(set);
                for (IProjectFeatureHandler iProjectFeatureHandler : list) {
                    ICustomFeatureJoiner iCustomFeatureJoiner;
                    String string = iProjectFeatureHandler.getName();
                    if (!this.project.getInstalledFeatures().contains(string)) {
                        this.project.installFeatures(Collections.singleton(string), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                    }
                    if ((iCustomFeatureJoiner = (ICustomFeatureJoiner)hashMap.get(string)) == null) continue;
                    iCustomFeatureJoiner.joinFeatureWith(this.project, substituteObjectRegistry, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
                if (!substituteObjectRegistry.getSubstituted().isEmpty()) {
                    this.mProjectJointServiceSupport.remapReferencesToSubstitutes((IProject)iAttachedProject, substituteObjectRegistry, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500), this.project);
                }
                this.mProjectJointServiceSupport.removeMountPoints(iAttachedProject, iProgressMonitor, substituteObjectRegistry, this.getProject());
            }
            finally {
                this.mProjectJointServiceSupport.finish(this.getProject());
            }
            this.mProjectJointServiceSupport.doAttachments(this.getProject(), iAttachedProject);
            this.mProjectJointServiceSupport.detachInDecomposition(iAttachedProject, iProgressMonitor, this.project);
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void lockObjects(IProgressMonitor iProgressMonitor, Set<EObject> set) throws LockAcquisitionException {
        EObject eObject;
        IPrimaryProject iPrimaryProject = ProjectUtil.getPrimaryProject((IProject)this.project);
        if (!Locking.isProjectLockable((IProject)iPrimaryProject)) return;
        if (set.isEmpty()) return;
        ILockManager iLockManager = Locking.getLockManager((IProject)iPrimaryProject);
        Object object = set.iterator();
        while (object.hasNext()) {
            eObject = object.next();
            if (iLockManager.needLock(eObject)) continue;
            object.remove();
        }
        try {
            object = iLockManager.lock(set, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
        }
        catch (RuntimeException runtimeException) {
            throw new LockAcquisitionException(set, (Throwable)runtimeException);
        }
        if (set.size() == object.size()) return;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            eObject = (ILock)iterator.next();
            set.remove(eObject.getSubject());
        }
        throw new LockAcquisitionException(set);
    }

    protected void interceptJoin(IAttachedProject iAttachedProject, IProjectJoiningFeatureProvider iProjectJoiningFeatureProvider) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addLocksAndFeatureJoiners(IAttachedProject iAttachedProject, IProjectJoiningFeatureProvider iProjectJoiningFeatureProvider, IProjectFeatureHandlerService iProjectFeatureHandlerService, Set<String> set, Set<EObject> set2, Map<String, ICustomFeatureJoiner> map) {
        for (String string : set) {
            IProjectFeatureHandler iProjectFeatureHandler = iProjectFeatureHandlerService.getHandler(string);
            ICustomFeatureJoiner iCustomFeatureJoiner = iProjectJoiningFeatureProvider.getCustomFeatureJoiner(string);
            if (iCustomFeatureJoiner == null) {
                iCustomFeatureJoiner = this.mProjectJointServiceSupport.getDefaultFeatureJoiner(iAttachedProject, iProjectFeatureHandler);
            }
            map.put(string, iCustomFeatureJoiner);
            set2.addAll(iCustomFeatureJoiner.getObjectsToModify(null));
        }
    }

    private IProjectFeatureHandlerService getFeatureHandlerService() {
        IProjectFeatureHandlerService iProjectFeatureHandlerService = (IProjectFeatureHandlerService)SingletonServiceDiscovery.INSTANCE.getService(IProjectFeatureHandlerService.class);
        if (iProjectFeatureHandlerService == null) {
            throw new ProjectConfigurationException("Feature handler service not available");
        }
        return iProjectFeatureHandlerService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private AbstractFeatureException checkFeatures(IAttachedProject iAttachedProject, IProjectFeatureProvider iProjectFeatureProvider) {
        if (iProjectFeatureProvider.getFeatures().isEmpty()) {
            return new FeaturesNotSpecifiedException();
        }
        Set set = iAttachedProject.getInstalledFeatures();
        if (!set.containsAll(iProjectFeatureProvider.getFeatures())) {
            HashSet hashSet = new HashSet(iProjectFeatureProvider.getFeatures());
            hashSet.removeAll(set);
            return new FeatureNotInstalledException(hashSet);
        }
        HashSet<String> hashSet = new HashSet<String>();
        IProjectFeatureHandlerService iProjectFeatureHandlerService = (IProjectFeatureHandlerService)SingletonServiceDiscovery.INSTANCE.getService(IProjectFeatureHandlerService.class);
        for (String string : iProjectFeatureProvider.getFeatures()) {
            IProjectFeatureHandler iProjectFeatureHandler = iProjectFeatureHandlerService.getHandler(string);
            if (iProjectFeatureHandler != null) continue;
            hashSet.add(string);
        }
        if (!hashSet.isEmpty()) {
            return new FeatureDependencyException(set);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private PersistenceException checkAttached(IAttachedProject iAttachedProject, @CheckForNull Map<String, Object> map) {
        AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration = this.getConfiguration(iAttachedProject);
        if (abstractProjectAttachmentConfiguration == null) {
            return new IllegalProjectRelationshipException((IProject)iAttachedProject, this.project, IllegalProjectRelationshipException.IllegalRelationship.NOT_ATTACHED);
        }
        IPrimaryProject iPrimaryProject = ProjectUtil.getPrimaryProject((IProject)this.project);
        IProjectDecompositionManager iProjectDecompositionManager = (IProjectDecompositionManager)iAttachedProject.getService(IProjectDecompositionManager.class);
        if (iProjectDecompositionManager != null) {
            for (IProject iProject : iProjectDecompositionManager.getAttachingProjectSet()) {
                if (iProject == this.project || iProject == iAttachedProject || !(iProject instanceof IPrimaryProject) && !iPrimaryProject.getProjects().contains(iProject) || this.isIncomingUsageIgnored(iAttachedProject, iProject, map)) continue;
                return new IllegalProjectRelationshipException((IProject)iAttachedProject, iProject, IllegalProjectRelationshipException.IllegalRelationship.ATTACHED);
            }
        }
        return null;
    }

    public boolean isIncomingUsageIgnored(IAttachedProject iAttachedProject, IProject iProject, @CheckForNull Map<String, Object> map) {
        return false;
    }

    @CheckForNull
    private AbstractProjectAttachmentConfiguration getConfiguration(IAttachedProject iAttachedProject) {
        IProjectDecompositionManager iProjectDecompositionManager = (IProjectDecompositionManager)this.project.getService(IProjectDecompositionManager.class);
        if (iProjectDecompositionManager != null) {
            return (AbstractProjectAttachmentConfiguration)iProjectDecompositionManager.getAttachedProjects().get(iAttachedProject);
        }
        return null;
    }
}

