/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.local.internal.c.i;
import com.nomagic.ci.persistence.local.internal.f.a.d;
import com.nomagic.ci.persistence.local.spi.ProjectDecompositionManager;
import com.nomagic.ci.persistence.local.spi.events.ComplexOperationEventsUtil;
import com.nomagic.ci.persistence.spi.decomposition.AttachedProjectRemoveService;
import com.nomagic.ci.persistence.spi.decomposition.AttachmentSet;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageRemover;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class LocalAttachedProjectRemoveService
extends AttachedProjectRemoveService {
    public LocalAttachedProjectRemoveService(IPrimaryProject iPrimaryProject) {
        super(iPrimaryProject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkIsAttached(AttachmentSet attachmentSet) throws PersistenceException {
        for (IProject iProject : attachmentSet.getAttachingProjects()) {
            this.checkInputProject(iProject);
            ProjectDecompositionManager projectDecompositionManager = (ProjectDecompositionManager)((Object)iProject.getService(IProjectDecompositionManager.class));
            for (IProject iProject2 : attachmentSet.getAttachedProjects(iProject)) {
                this.checkInputProject(iProject2);
                projectDecompositionManager.checkIsAttached(iProject2, true);
            }
        }
    }

    protected IProjectUsageRemover getProjectUsageRemover(Set<IAttachedProject> set) {
        return i.a(ComplexOperationEventsUtil.getCurrentContext(this.primary), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkDetached(Map<IProject, Set<IProject>> map) throws PersistenceException {
        for (Map.Entry<IProject, Set<IProject>> entry : map.entrySet()) {
            IProject iProject = entry.getKey();
            ProjectDecompositionManager projectDecompositionManager = (ProjectDecompositionManager)((Object)iProject.getService(IProjectDecompositionManager.class));
            for (IProject iProject2 : entry.getValue()) {
                projectDecompositionManager.checkProjectTobeDetached(iProject2);
            }
        }
    }

    protected void preDetach(IProject iProject, IProject iProject2, IProgressMonitor iProgressMonitor) {
        ProjectDecompositionManager projectDecompositionManager = (ProjectDecompositionManager)((Object)iProject.getService(IProjectDecompositionManager.class));
        projectDecompositionManager.firePreDetach(iProject2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
    }

    protected void postDetach(IProject iProject, IProject iProject2, boolean bl, IProgressMonitor iProgressMonitor) {
        ProjectDecompositionManager projectDecompositionManager = (ProjectDecompositionManager)((Object)iProject.getService(IProjectDecompositionManager.class));
        projectDecompositionManager.firePostDetach(iProject2, bl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
    }

    protected void updateProjectStructureIfNeeded(IProgressMonitor iProgressMonitor, boolean bl) throws PersistenceException {
        d.a((IProject)this.primary, bl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
    }
}

