/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.local.spi.decomposition.ExtractedAttachedProjectInfoService;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class ExtractedAttachedProjectInfoServiceImpl
implements ExtractedAttachedProjectInfoService {
    private IAttachedProject project;
    Map<IProject, AbstractProjectAttachmentConfiguration> inheritableAttachments = new LinkedHashMap<IProject, AbstractProjectAttachmentConfiguration>();

    public ExtractedAttachedProjectInfoServiceImpl(IAttachedProject iAttachedProject) {
        this.project = iAttachedProject;
    }

    @Override
    public void persistInheritableAttachments(IProject iProject, Map<IProject, AbstractProjectAttachmentConfiguration> map) {
        this.inheritableAttachments.clear();
        for (Map.Entry<IProject, AbstractProjectAttachmentConfiguration> entry : map.entrySet()) {
            if (!this.isProjectUsageValid(iProject, entry)) continue;
            this.inheritableAttachments.put(entry.getKey(), entry.getValue());
        }
    }

    protected boolean isProjectUsageValid(IProject iProject, Map.Entry<IProject, AbstractProjectAttachmentConfiguration> entry) {
        return LocalProjectUtil.isProjectUsageManual((IProject)iProject, (IProject)entry.getKey());
    }

    @Override
    @Nonnull
    public Map<IProject, AbstractProjectAttachmentConfiguration> getInheritableAttachments() {
        return Collections.unmodifiableMap(this.inheritableAttachments);
    }

    @Override
    public void clearInheritableAttachments() {
        this.inheritableAttachments.clear();
    }

    public IProject getProject() {
        return this.project;
    }
}

