/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.decomposition.ProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.local.spi.ProjectDecompositionManager;
import com.nomagic.ci.persistence.local.spi.decomposition.ProjectUsageJoiner;
import com.nomagic.ci.persistence.local.spi.util.MonitorUtil;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.util.ProjectUtil;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class DefaultProjectUsageJoiner
implements ProjectUsageJoiner {
    protected IProject project;

    public DefaultProjectUsageJoiner(IProject iProject) {
        this.project = iProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void joinProjectUsages(IAttachedProject iAttachedProject, IProgressMonitor iProgressMonitor) throws PersistenceException {
        iProgressMonitor = MonitorUtil.getNonNullMonitor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1000);
            IPrimaryProject iPrimaryProject = ProjectUtil.getPrimaryProject((IProject)this.project);
            ProjectDecompositionManager projectDecompositionManager = (ProjectDecompositionManager)((Object)this.project.getService(IProjectDecompositionManager.class));
            Map<IProject, AbstractProjectAttachmentConfiguration> map = projectDecompositionManager.getAttachedProjects();
            Map map2 = ((IProjectDecompositionManager)iAttachedProject.getService(IProjectDecompositionManager.class)).getAttachedProjects();
            for (Map.Entry entry : map2.entrySet()) {
                IProject iProject = (IProject)entry.getKey();
                if (iProject == iPrimaryProject || map.containsKey(iProject)) continue;
                projectDecompositionManager.attachProjectConfigured(iProject, (ProjectAttachmentConfiguration)entry.getValue(), null, null);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public IProject getProject() {
        return this.project;
    }
}

