/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.decomposition;

import com.nomagic.ci.metamodel.local.project.LocalProject;
import com.nomagic.ci.metamodel.local.project.ProjectFactory;
import com.nomagic.ci.metamodel.local.project.ProjectPackage;
import com.nomagic.ci.metamodel.project.util.EListUtil;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.local.proxy.InstanceManagerService;
import com.nomagic.ci.persistence.local.proxy.LocalProxyService;
import com.nomagic.ci.persistence.local.proxy.ValueFilter;
import com.nomagic.ci.persistence.local.services.WaitForService;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IProjectServiceDescriptor;
import com.nomagic.ci.persistence.local.spi.IResourceUriMapper;
import com.nomagic.ci.persistence.local.spi.ServiceNewAndOldValue;
import com.nomagic.ci.persistence.local.spi.decomposition.IDecompositionProjectIdProvider;
import com.nomagic.ci.persistence.local.spi.decomposition.LocalDecompositionModel;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusEvent;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusEventImpl;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusSupport;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventListener;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.util.FileUtil;
import com.nomagic.ci.persistence.local.util.ResourceLoadAdapter;
import com.nomagic.ci.persistence.local.util.ResourceUtil;
import com.nomagic.ci.persistence.util.EMFTypesUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DecompositionModelService
implements LocalDecompositionModel,
IProjectServiceDescriptor {
    public static final String NAMESPACE = "com.nomagic.ci.metamodel";
    public static final String PROJECT_RESOUCE_NAME = "project";
    private static final EListUtil.ItemFilter<EObject> PROJECT_FILTER = new EListUtil.TypeFilter(LocalProject.class);
    private static final Logger LOGGER = Logger.getLogger(DecompositionModelService.class);
    private final AbstractProject project;
    protected ServiceBusSupport serviceEventBus;
    private ResourceLoadAdapter resourceSetAdapter;
    private volatile Resource projectResource;
    private boolean deliverNotifications = true;

    public DecompositionModelService(AbstractProject abstractProject, ServiceBusSupport serviceBusSupport) {
        this.project = abstractProject;
        this.serviceEventBus = serviceBusSupport;
        this.resourceSetAdapter = new ResourceLoadAdapter(){

            @Override
            public void onLoadStateChange(Resource resource, boolean bl) {
                if (DecompositionModelService.this.isProjectResourceURI(resource.getURI())) {
                    DecompositionModelService.this.projectResource = (Resource)(bl ? resource : null);
                    if (DecompositionModelService.this.deliverNotifications) {
                        DecompositionModelService.this.notifyActive(bl);
                    }
                }
            }
        };
        abstractProject.getServiceBusSupport().addListener(new ServiceEventListener(){

            @Override
            public void notify(ServiceBusEvent serviceBusEvent) {
                if (serviceBusEvent.getSource() instanceof AbstractProject) {
                    if (serviceBusEvent.getEventType().equals(AbstractProject.RESOURCE_SET_EVENT_TYPE)) {
                        ResourceSet resourceSet;
                        ServiceNewAndOldValue serviceNewAndOldValue = (ServiceNewAndOldValue)serviceBusEvent.getData();
                        DecompositionModelService.this.makeUnavailable();
                        if (serviceNewAndOldValue.getOldValue() instanceof ResourceSet) {
                            resourceSet = (ResourceSet)serviceNewAndOldValue.getOldValue();
                            resourceSet.eAdapters().remove((Object)DecompositionModelService.this.resourceSetAdapter);
                        }
                        if (serviceNewAndOldValue.getNewValue() instanceof ResourceSet) {
                            resourceSet = (ResourceSet)serviceNewAndOldValue.getNewValue();
                            resourceSet.eAdapters().add((Object)DecompositionModelService.this.resourceSetAdapter);
                        }
                        DecompositionModelService.this.checkResources();
                    } else if (serviceBusEvent.getEventType().equals(AbstractProject.URI_MAPPER_EVENT_TYPE)) {
                        DecompositionModelService.this.makeUnavailable();
                        DecompositionModelService.this.checkResources();
                    }
                }
            }
        });
        if (abstractProject instanceof IPrimaryProject) {
            new WaitForService<InstanceManagerService>(abstractProject, InstanceManagerService.class){

                @Override
                public void serviceAvailable(InstanceManagerService instanceManagerService) {
                    instanceManagerService.setInstanceRestoringEnabled((EPackage)ProjectPackage.eINSTANCE, false);
                }
            }.doWait();
        }
        this.initDecompositionProxyValueFilter();
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void makeUnavailable() {
        boolean bl = this.isAvailable();
        this.projectResource = null;
        if (!this.deliverNotifications) return;
        if (!bl) return;
        this.notifyActive(false);
    }

    private void initDecompositionProxyValueFilter() {
        block3: {
            ValueFilter valueFilter;
            block2: {
                LocalProxyService localProxyService = this.project.getService(LocalProxyService.class);
                valueFilter = new ValueFilter(){

                    @Override
                    public boolean accept(EObject eObject, EStructuralFeature eStructuralFeature) {
                        return eObject.eClass().getEPackage() == ProjectPackage.eINSTANCE;
                    }
                };
                if (localProxyService == null) break block2;
                localProxyService.addValueFilter(valueFilter);
                break block3;
            }
            this.project.getServiceBusSupport().addListener(new ServiceEventListener(){

                @Override
                public void notify(ServiceBusEvent serviceBusEvent) {
                    ServiceNewAndOldValue serviceNewAndOldValue;
                    if (serviceBusEvent.getSource() instanceof AbstractProject && serviceBusEvent.getEventType().equals(AbstractProject.SERVICE_REGISTERED_EVENT_TYPE) && (serviceNewAndOldValue = (ServiceNewAndOldValue)serviceBusEvent.getData()).getNewValue() instanceof LocalProxyService) {
                        LocalProxyService localProxyService = (LocalProxyService)serviceNewAndOldValue.getNewValue();
                        localProxyService.addValueFilter(valueFilter);
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isProjectResourceURI(URI uRI) {
        IResourceUriMapper iResourceUriMapper = this.project.getUriMapper();
        if (iResourceUriMapper == null) return false;
        ResourceInfo resourceInfo = iResourceUriMapper.getResourceInfo(uRI);
        ResourceInfo resourceInfo2 = resourceInfo;
        if (resourceInfo2 == null) return false;
        if (!NAMESPACE.equals(resourceInfo2.getNamespace())) return false;
        if (!PROJECT_RESOUCE_NAME.equals(resourceInfo2.getResourceName())) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkResources() {
        if (this.project.getResourceSet() != null && this.project.getUriMapper() != null) {
            for (Resource resource : this.project.getResourceSet().getResources()) {
                if (!resource.isLoaded()) continue;
                this.resourceSetAdapter.onLoadStateChange(resource, true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDeliverNotifications(boolean bl) {
        if (this.deliverNotifications == bl) return;
        this.deliverNotifications = bl;
        if (!this.isAvailable()) return;
        this.notifyActive(this.deliverNotifications);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAvailable() {
        return this.projectResource != null && this.projectResource.isLoaded();
    }

    protected void notifyOptions(boolean bl) {
        if (bl) {
            LocalProject localProject = this.getDecompositionProject();
            Map map = EMFTypesUtil.getMapFromEMap((EMap)localProject.getProperties());
            ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl(this, DECOMPOSITION_OPTIONS_EVENT_TYPE, map);
            this.serviceEventBus.fireEvent(serviceBusEventImpl);
        }
    }

    protected void notifyActive(boolean bl) {
        Object object;
        block5: {
            if (!bl || this.projectResource == null) break block5;
            object = this.projectResource.eAdapters();
            if (!EListUtil.contains((List)object, (EListUtil.ItemFilter)new EListUtil.TypeFilter(DecompositionResourceAdapter.class))) {
                object.add((Object)new DecompositionResourceAdapter(this.projectResource));
            }
            DecompositionResourceAdapter.checkDecompositionResourceContents(this.projectResource);
        }
        this.notifyOptions(bl);
        object = new ServiceBusEventImpl(this, IS_AVAILABLE_EVENT_TYPE, bl);
        this.serviceEventBus.fireEvent((ServiceBusEvent)object);
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public LocalProject getDecompositionProject() {
        if (this.projectResource == null) {
            throw new ProjectConfigurationException("Decomposition model resource not loaded");
        }
        return DecompositionModelService.getProject(this.projectResource);
    }

    public void load(IProgressMonitor iProgressMonitor) throws IOException {
        URI uRI = this.getResourceURI();
        Resource resource = this.project.getResourceSet().getResource(uRI, true);
        if (resource == null) {
            throw new ProjectConfigurationException("Decomposition model resource cannot be located");
        }
        if (!resource.isLoaded()) {
            ResourceUtil.safelyLoadResource(resource, null);
        }
    }

    public void unload(IProgressMonitor iProgressMonitor) {
        URI uRI = this.getResourceURI();
        Resource resource = this.project.getResourceSet().getResource(uRI, false);
        if (resource != null) {
            resource.unload();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void install(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        URI uRI = this.getResourceURI();
        try {
            iProgressMonitor.beginTask("", 100);
            ResourceSet resourceSet = this.project.getResourceSet();
            LocalProject localProject = ProjectFactory.eINSTANCE.createProject();
            localProject.setId(this.getProjectID());
            Resource resource = resourceSet.getResource(uRI, false);
            if (resource == null) {
                resource = resourceSet.createResource(uRI);
            } else if (resource.isLoaded()) {
                throw new ProjectConfigurationException("Decomposition model resource already loaded " + uRI);
            }
            iProgressMonitor.worked(50);
            resource.getContents().add((Object)localProject);
            if (resource.isLoaded()) return;
            try {
                ResourceUtil.safelyLoadResource(resource, null);
                return;
            }
            catch (IOException iOException) {
                throw new ProjectConfigurationException("Decomposition model resource could not be loaded", (Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected String getProjectID() {
        IDecompositionProjectIdProvider iDecompositionProjectIdProvider = this.project.getService(IDecompositionProjectIdProvider.class);
        if (iDecompositionProjectIdProvider != null) {
            String string = iDecompositionProjectIdProvider.getNewProjectID();
            if (string != null) {
                return string;
            }
        }
        return EcoreUtil.generateUUID();
    }

    @Override
    public URI getResourceURI() {
        URI uRI = DecompositionModelService.getProjectResourceURI(this.project.getUriMapper());
        return uRI;
    }

    public static URI getProjectResourceURI(IResourceUriMapper iResourceUriMapper) {
        return iResourceUriMapper.getResourceURI(NAMESPACE, PROJECT_RESOUCE_NAME);
    }

    public static LocalProject getProject(Resource resource) throws ProjectConfigurationException {
        LocalProject localProject = (LocalProject)EListUtil.find((List)resource.getContents(), PROJECT_FILTER);
        if (localProject == null) {
            DecompositionModelService.handleMissingDecompositionProject(resource);
            throw new ProjectConfigurationException("Project decomposition resource is corrupted");
        }
        return localProject;
    }

    private static void handleMissingDecompositionProject(Resource resource) {
        StringBuilder stringBuilder;
        block8: {
            stringBuilder = new StringBuilder();
            try {
                stringBuilder.append("Decomposition project was not found in the resource contents. Resource URI: ").append(resource.getURI()).append(", resource contents: [");
                for (EObject eObject : resource.getContents()) {
                    stringBuilder.append(String.valueOf(eObject));
                    if (eObject == null) continue;
                    stringBuilder.append(" : ").append(eObject.getClass().getName());
                }
                boolean bl = resource.getResourceSet().getURIConverter().exists(resource.getURI(), null);
                stringBuilder.append("]. Resource persisted and exists: ").append(bl);
                if (!bl) break block8;
                InputStream inputStream = resource.getResourceSet().getURIConverter().createInputStream(resource.getURI());
                stringBuilder.append(". Input stream for the resource: ").append(inputStream);
                if (inputStream == null) break block8;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    stringBuilder.append(", contents from the input stream:\n");
                    FileUtil.copy(inputStream, byteArrayOutputStream);
                }
                finally {
                    FileUtil.closeQuietly(inputStream);
                    FileUtil.closeQuietly(byteArrayOutputStream);
                }
                stringBuilder.append(byteArrayOutputStream.toString("UTF-8"));
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Failed to handle missing decomposition project. The logged information may be incomplete", (Throwable)exception);
            }
        }
        LOGGER.error((Object)stringBuilder.toString());
    }

    private static class DecompositionResourceAdapter
    extends AdapterImpl {
        Resource decompositionResource;

        public DecompositionResourceAdapter(Resource resource) {
            this.decompositionResource = resource;
        }

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() == this.decompositionResource && notification.getFeatureID(Resource.class) == 2) {
                DecompositionResourceAdapter.checkDecompositionResourceContents(this.decompositionResource);
            }
        }

        static void checkDecompositionResourceContents(Resource resource) {
            EList eList = resource.getContents();
            if (eList.size() > 1) {
                if (EListUtil.findAll((List)eList, (EListUtil.ItemFilter)PROJECT_FILTER).size() > 1) {
                    LOGGER.error((Object)("Decomposition resource " + resource.getURI() + " has more than one project in its contents"));
                } else {
                    LOGGER.warn((Object)("Decomposition resource " + resource.getURI() + " has more than one object in its contents"));
                }
            }
        }
    }
}

