/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.binary;

import com.nomagic.ci.metamodel.binary.AbstractStreamIdentityBinaryObject;
import com.nomagic.ci.metamodel.binary.BinaryObject;
import com.nomagic.ci.metamodel.binary.IBinaryObjectRuntime;
import com.nomagic.ci.metamodel.binary.IBinaryObjectRuntimeProvider;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.local.IResourcePool;
import com.nomagic.ci.persistence.local.internal.b.a;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.binary.IBinaryStreamContainer;
import com.nomagic.ci.persistence.local.spi.binary.IBinaryStreamStorage;
import com.nomagic.ci.persistence.local.spi.binary.ICentralStreamRepository;
import com.nomagic.ci.persistence.local.spi.binary.StreamIdentityFactory;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.util.FileUtil;
import com.nomagic.ci.persistence.spi.binary.BinaryObjectRuntime;
import com.nomagic.ci.persistence.spi.binary.IBinaryObjectRuntimeService;
import com.nomagic.ci.persistence.util.ProjectUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MultiBinaryStreamStorage
implements ICentralStreamRepository,
IBinaryObjectRuntimeService {
    private Map<BinaryObject, StreamWriting> pendingWrites = new HashMap<BinaryObject, StreamWriting>();
    private IPrimaryProject primary;
    private IResourcePool attic;
    private static final Logger LOGGER = Logger.getLogger(MultiBinaryStreamStorage.class);

    public static IBinaryObjectRuntimeProvider getBinaryObjectRuntimeService() {
        return new IBinaryObjectRuntimeProvider(){

            public IBinaryObjectRuntime getRuntime(AbstractStreamIdentityBinaryObject abstractStreamIdentityBinaryObject) {
                return new BinaryObjectRuntime(abstractStreamIdentityBinaryObject);
            }
        };
    }

    public MultiBinaryStreamStorage(IPrimaryProject iPrimaryProject, IResourcePool iResourcePool) {
        this.primary = iPrimaryProject;
        this.attic = iResourcePool;
    }

    @Override
    public IPrimaryProject getProject() {
        return this.primary;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanAttic() {
        for (String string : this.attic.getResources()) {
            this.attic.deleteResource(string);
        }
    }

    public IResourcePool getAttic() {
        return this.attic;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void pull(Set<String> set, IBinaryStreamContainer iBinaryStreamContainer, IProgressMonitor iProgressMonitor) throws IOException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Copying binary data...", 100 * set.size());
        try {
            for (String string : set) {
                InputStream inputStream = this.findInputStream(string);
                if (inputStream == null) {
                    throw new IOException("Can not find " + string + " stream in any project");
                }
                OutputStream outputStream = iBinaryStreamContainer.getOutputStream(string);
                FileUtil.copy(inputStream, outputStream);
                inputStream.close();
                outputStream.close();
                iProgressMonitor.worked(100);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void push(Set<String> set, IBinaryStreamContainer iBinaryStreamContainer, IProgressMonitor iProgressMonitor) throws IOException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Copying binary data...", 100 * set.size());
        try {
            for (String string : set) {
                if (!this.attic.isResourcePresent(string)) {
                    InputStream inputStream = iBinaryStreamContainer.getInputStream(string);
                    OutputStream outputStream = this.attic.getResourceAsOutputStream(string);
                    FileUtil.copy(inputStream, outputStream);
                    inputStream.close();
                    outputStream.close();
                }
                iProgressMonitor.worked(100);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @CheckForNull
    private InputStream findInputStream(String string) {
        if (this.attic.isResourcePresent(string)) {
            return this.attic.getResourceAsInputStream(string);
        }
        for (IProject iProject : ProjectUtil.getProjects((IPrimaryProject)this.primary)) {
            IBinaryStreamStorage iBinaryStreamStorage = (IBinaryStreamStorage)iProject.getService(IBinaryStreamStorage.class);
            IBinaryStreamContainer iBinaryStreamContainer = iBinaryStreamStorage.getContainerOf(string);
            if (iBinaryStreamContainer == null) continue;
            return iBinaryStreamContainer.getInputStream(string);
        }
        return null;
    }

    public boolean isInputStreamAvailable(IProject iProject, AbstractStreamIdentityBinaryObject abstractStreamIdentityBinaryObject) {
        String string = abstractStreamIdentityBinaryObject.getStreamContentID();
        if (StreamIdentityFactory.isStreamContentID(string)) {
            IBinaryStreamStorage iBinaryStreamStorage = (IBinaryStreamStorage)iProject.getService(IBinaryStreamStorage.class);
            IBinaryStreamContainer iBinaryStreamContainer = iBinaryStreamStorage.getContainerOf(string);
            if (iBinaryStreamContainer != null) {
                return true;
            }
            if (this.attic.isResourcePresent(string)) {
                return true;
            }
            for (IProject iProject2 : ProjectUtil.getProjects((IPrimaryProject)this.primary)) {
                IBinaryStreamStorage iBinaryStreamStorage2;
                IBinaryStreamContainer iBinaryStreamContainer2;
                if (iProject2 == iProject || (iBinaryStreamContainer2 = (iBinaryStreamStorage2 = (IBinaryStreamStorage)iProject2.getService(IBinaryStreamStorage.class)).getContainerOf(string)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public InputStream getInputStream(IProject iProject, AbstractStreamIdentityBinaryObject abstractStreamIdentityBinaryObject) throws IOException {
        String string = abstractStreamIdentityBinaryObject.getStreamContentID();
        if (StreamIdentityFactory.isStreamContentID(string)) {
            IBinaryStreamStorage iBinaryStreamStorage = (IBinaryStreamStorage)iProject.getService(IBinaryStreamStorage.class);
            IBinaryStreamContainer iBinaryStreamContainer = iBinaryStreamStorage.getContainerOf(string);
            if (iBinaryStreamContainer != null) {
                return iBinaryStreamContainer.getInputStream(string);
            }
            if (this.attic.isResourcePresent(string)) {
                return this.attic.getResourceAsInputStream(string);
            }
            for (IProject iProject2 : ProjectUtil.getProjects((IPrimaryProject)this.primary)) {
                IBinaryStreamStorage iBinaryStreamStorage2;
                IBinaryStreamContainer iBinaryStreamContainer2;
                if (iProject2 == iProject || (iBinaryStreamContainer2 = (iBinaryStreamStorage2 = (IBinaryStreamStorage)iProject2.getService(IBinaryStreamStorage.class)).getContainerOf(string)) == null) continue;
                return iBinaryStreamContainer2.getInputStream(string);
            }
        }
        LOGGER.warn((Object)("Invalid stream content ID: " + string), (Throwable)new Exception());
        return null;
    }

    public synchronized OutputStream getOutputStream(IProject iProject, AbstractStreamIdentityBinaryObject abstractStreamIdentityBinaryObject) throws IOException {
        a a2;
        StreamWriting streamWriting = this.pendingWrites.get(abstractStreamIdentityBinaryObject);
        if (streamWriting != null) {
            a2 = streamWriting.getOutputStream();
            try {
                a2.close();
            }
            finally {
                LOGGER.warn((Object)("The stream writing to " + abstractStreamIdentityBinaryObject + " is still pending"));
            }
        }
        a2 = abstractStreamIdentityBinaryObject.eResource();
        IBinaryStreamStorage iBinaryStreamStorage = (IBinaryStreamStorage)iProject.getService(IBinaryStreamStorage.class);
        ResourceInfo resourceInfo = ((AbstractProject)iProject).getUriMapper().getResourceInfo(a2.getURI());
        IBinaryStreamContainer iBinaryStreamContainer = iBinaryStreamStorage.getContainerFor(resourceInfo);
        if (iBinaryStreamContainer == null) {
            throw new IllegalStateException("Binary storage is not available for " + abstractStreamIdentityBinaryObject);
        }
        String string = StreamIdentityFactory.generateStreamContentID();
        a a3 = new a(iBinaryStreamContainer.getOutputStream(string));
        StreamWriting streamWriting2 = new StreamWriting(abstractStreamIdentityBinaryObject, a3, string);
        this.pendingWrites.put((BinaryObject)abstractStreamIdentityBinaryObject, streamWriting2);
        return a3;
    }

    private synchronized void writeFinished(BinaryObject binaryObject) {
        this.pendingWrites.remove(binaryObject);
    }

    private class StreamWriting
    implements PropertyChangeListener {
        private AbstractStreamIdentityBinaryObject binaryObject;
        private a outputStream;
        private String futureStreamID;

        StreamWriting(AbstractStreamIdentityBinaryObject abstractStreamIdentityBinaryObject, a a2, String string) {
            this.binaryObject = abstractStreamIdentityBinaryObject;
            this.futureStreamID = string;
            this.outputStream = a2;
            this.outputStream.a(this);
        }

        AbstractStreamIdentityBinaryObject getBinaryObject() {
            return this.binaryObject;
        }

        a getOutputStream() {
            return this.outputStream;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MultiBinaryStreamStorage.this.writeFinished((BinaryObject)this.binaryObject);
            this.binaryObject.setStreamContentID(this.futureStreamID);
        }
    }
}

