/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.binary;

import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.IResourcePool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.log4j.Logger;

public class BinaryStreamAttic
implements IResourcePool {
    private static final Logger LOGGER = Logger.getLogger(BinaryStreamAttic.class);
    private File dir;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BinaryStreamAttic(File file) {
        if (file.isDirectory() && file.canExecute() && file.canWrite()) {
            this.dir = file;
            return;
        }
        throw new IllegalArgumentException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @CheckForNull
    public InputStream getResourceAsInputStream(String string) {
        File file = new File(this.dir, string);
        if (file.isFile()) {
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    @Override
    public OutputStream getResourceAsOutputStream(String string) {
        File file = new File(this.dir, string);
        try {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PersistenceRuntimeException((Throwable)fileNotFoundException);
        }
    }

    @Override
    public boolean deleteResource(String string) {
        LOGGER.info((Object)("Deleting resource with id " + string));
        File file = new File(this.dir, string);
        return file.delete();
    }

    @Override
    public boolean isResourcePresent(String string) {
        File file = new File(this.dir, string);
        return file.isFile();
    }

    @Override
    public Set<String> getResources() {
        return new HashSet<String>(Arrays.asList(this.dir.list()));
    }
}

