/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.binary;

import com.nomagic.ci.metamodel.binary.BinaryObject;
import com.nomagic.ci.metamodel.project.DataSection;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.features.IProjectFeatureHandler;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IDataSectionManager;
import com.nomagic.ci.persistence.local.spi.binary.FullScanBinaryObjectProvider;
import com.nomagic.ci.persistence.local.spi.binary.IBinaryObjectProvider;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.resource.Resource;

public class BinaryObjectProviderUtil {
    private static final IBinaryObjectProvider fullScanBinaryObjectProvider = new FullScanBinaryObjectProvider();

    public static Collection<BinaryObject> getBinaryObjects(IProject iProject) {
        ArrayList<BinaryObject> arrayList = new ArrayList<BinaryObject>();
        for (Resource resource : ((AbstractProject)iProject).getManagedResources()) {
            IBinaryObjectProvider iBinaryObjectProvider = BinaryObjectProviderUtil.getProvider(iProject, resource);
            Collection<BinaryObject> collection = iBinaryObjectProvider.getBinaryObjects(resource);
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public static Collection<BinaryObject> getBinaryObjects(Resource resource) {
        IProject iProject = LocalProjectUtil.getProject(resource);
        IBinaryObjectProvider iBinaryObjectProvider = BinaryObjectProviderUtil.getProvider(iProject, resource);
        Collection<BinaryObject> collection = iBinaryObjectProvider.getBinaryObjects(resource);
        return collection;
    }

    private static IBinaryObjectProvider getProvider(IProject iProject, Resource resource) {
        IProjectFeatureHandler iProjectFeatureHandler;
        IDataSectionManager iDataSectionManager;
        DataSection dataSection;
        if (iProject != null && (dataSection = (iDataSectionManager = (IDataSectionManager)iProject.getService(IDataSectionManager.class)).getSection(resource)) != null && dataSection.getFeaturedBy() != null && (iProjectFeatureHandler = AbstractProject.getFeatureHandler(dataSection.getFeaturedBy().getName())) instanceof IBinaryObjectProvider) {
            IBinaryObjectProvider iBinaryObjectProvider = (IBinaryObjectProvider)iProjectFeatureHandler;
            return iBinaryObjectProvider;
        }
        return fullScanBinaryObjectProvider;
    }
}

