/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;

public class URIQuery
implements Iterable<Map.Entry<String, String>> {
    private static final String ENTRY_SEPARATOR = "&";
    private static final String VALUE_SEPARATOR = "=";
    private static final String ESCAPE = "_";
    private static final String ENTRY_SEPARATOR_ESCAPE = "_a";
    private static final String VALUE_SEPARATOR_ESCAPE = "_e";
    private static final String ESCAPE_ESCAPE = "_u";
    private Map<String, String> qmap = new LinkedHashMap<String, String>();

    public static URIQuery parse(URI uRI) {
        String string = uRI.hasQuery() ? uRI.query() : "";
        return URIQuery.parse(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URIQuery parse(String string) {
        URIQuery uRIQuery = new URIQuery();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ENTRY_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            int n2 = string2.lastIndexOf(VALUE_SEPARATOR);
            if (n2 >= 0) {
                String string3;
                String string4 = string2.substring(0, n2);
                String string5 = string3 = n2 < string2.length() ? string2.substring(n2 + 1) : "";
                if (string4.length() <= 0) continue;
                uRIQuery.put(URIQuery.decode(string4), URIQuery.decode(string3));
                continue;
            }
            uRIQuery.put(URIQuery.decode(string2), "");
        }
        return uRIQuery;
    }

    public String get(String string) {
        return this.qmap.get(string);
    }

    public String remove(String string) {
        return this.qmap.remove(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.qmap.put(string, string2);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.qmap.entrySet().iterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : this) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(ENTRY_SEPARATOR);
            }
            stringBuilder.append(URIQuery.encode(entry.getKey()));
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            stringBuilder.append(VALUE_SEPARATOR);
            stringBuilder.append(URIQuery.encode(entry.getValue()));
        }
        return stringBuilder.toString();
    }

    public String toAppendString() {
        String string = this.toString();
        String string2 = string.length() > 0 ? string : null;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String encode(String string) {
        if (string == null) return string;
        if (string.isEmpty()) return string;
        String string2 = URI.encodeQuery((String)string, (boolean)false);
        string2 = string2.replace(ESCAPE, ESCAPE_ESCAPE);
        string2 = string2.replace(ENTRY_SEPARATOR, ENTRY_SEPARATOR_ESCAPE);
        return string2.replace(VALUE_SEPARATOR, VALUE_SEPARATOR_ESCAPE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String decode(String string) {
        if (string == null) return string;
        if (string.isEmpty()) return string;
        String string2 = string.replace(VALUE_SEPARATOR_ESCAPE, VALUE_SEPARATOR);
        string2 = string2.replace(ENTRY_SEPARATOR_ESCAPE, ENTRY_SEPARATOR);
        string2 = string2.replace(ESCAPE_ESCAPE, ESCAPE);
        return URI.decode((String)string2);
    }
}

