/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.persistence.local.ILocalProjectResourceManager;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IProjectServiceDescriptor;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.util.ResourceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ServiceResourceManagerFactory {
    public static ILocalProjectResourceManager getResourceManager(AbstractProject abstractProject, IProjectServiceDescriptor iProjectServiceDescriptor) {
        return new ServiceResourceManager(abstractProject, iProjectServiceDescriptor);
    }

    private static class ServiceResourceManager
    implements ILocalProjectResourceManager {
        private AbstractProject project;
        private IProjectServiceDescriptor service;

        private ServiceResourceManager(AbstractProject abstractProject, IProjectServiceDescriptor iProjectServiceDescriptor) {
            this.project = abstractProject;
            this.service = iProjectServiceDescriptor;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Collection<String> getResourceNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = this.service.getNamespace();
            for (ResourceInfo resourceInfo : this.project.getProjectResources()) {
                if (resourceInfo.getUserId() != null || !resourceInfo.getNamespace().equals(string)) continue;
                arrayList.add(resourceInfo.getResourceName());
            }
            return arrayList;
        }

        public Resource getResource(String string, boolean bl) {
            URI uRI = this.project.getServiceResourceURI(this.service, string);
            return ResourceUtil.getActuallyLoadedResource(this.project.getResourceSet(), uRI, bl);
        }

        public Resource createResource(String string) {
            URI uRI = this.project.getServiceResourceURI(this.service, string);
            return this.project.getResourceSet().createResource(uRI);
        }

        @Override
        public URI getResourceURI(String string) {
            return this.project.getServiceResourceURI(this.service, string);
        }

        public boolean resourceExists(String string) {
            URI uRI = this.getResourceURI(string);
            return this.getResourceSet().getURIConverter().exists(uRI, null);
        }

        @Nonnull
        public ResourceSet getResourceSet() {
            return this.project.getResourceSet();
        }

        @Override
        public void save(Resource resource, Map<?, ?> map) throws IOException {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void load(Resource resource, Map<?, ?> map) throws IOException {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void unload(Resource resource, Map<?, ?> map) throws IOException {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void delete(Resource resource, Map<?, ?> map) throws IOException {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

