/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.local.spi.PreUpdateProjectState;
import com.nomagic.ci.persistence.util.ProjectUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProjectUpdateContext {
    Set<IProject> projectsToUpdate;
    private Set<IProject> updatedProjects = new HashSet<IProject>();
    private Map<String, Object> properties;
    private Map<IProject, PreUpdateProjectState> state;

    public ProjectUpdateContext(Set<IProject> set) {
        this(Collections.emptyList(), set);
    }

    public ProjectUpdateContext(IPrimaryProject iPrimaryProject, Set<IProject> set) {
        this(ProjectUtil.getProjects((IPrimaryProject)iPrimaryProject), set);
    }

    public ProjectUpdateContext(Collection<IProject> collection, Set<IProject> set) {
        this.projectsToUpdate = set != null ? new HashSet<IProject>(set) : null;
        this.properties = new HashMap<String, Object>();
        this.state = new HashMap<IProject, PreUpdateProjectState>();
        for (IProject iProject : collection) {
            this.state.put(iProject, new PreUpdateProjectState(iProject));
        }
    }

    public void addUpdatedProject(IProject iProject) {
        this.updatedProjects.add(iProject);
    }

    public boolean isProjectUpdated(IProject iProject) {
        return this.updatedProjects.contains(iProject);
    }

    public Set<IProject> getUpdatedProjects() {
        return this.updatedProjects;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public PreUpdateProjectState getPreUpdateProjectState(IProject iProject) {
        return this.state.get(iProject);
    }

    public boolean projectHasToBeUpdated(IProject iProject) {
        return this.projectsToUpdate != null && this.projectsToUpdate.contains(iProject);
    }

    public void addProjectToUpdate(IProject iProject) {
        if (this.projectsToUpdate == null) {
            this.projectsToUpdate = new HashSet<IProject>();
        }
        this.projectsToUpdate.add(iProject);
    }
}

