/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.metamodel.local.project.LocalProject;
import com.nomagic.ci.metamodel.local.project.MountPoint;
import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.metamodel.project.AbstractProjectUsage;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.ProjectAllocationException;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.ProjectEvent;
import com.nomagic.ci.persistence.ProjectEventType;
import com.nomagic.ci.persistence.ProjectListener;
import com.nomagic.ci.persistence.decomposition.IAttachedProjectRemoverCallback;
import com.nomagic.ci.persistence.decomposition.ProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.local.ProjectRepositoryRegistry;
import com.nomagic.ci.persistence.local.decomposition.IProjectAttachmentConfigurator;
import com.nomagic.ci.persistence.local.decomposition.ProjectAccessException;
import com.nomagic.ci.persistence.local.features.dependency.DependencyInfo;
import com.nomagic.ci.persistence.local.importers.ImportProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.local.internal.B;
import com.nomagic.ci.persistence.local.internal.I;
import com.nomagic.ci.persistence.local.internal.c.a.g;
import com.nomagic.ci.persistence.local.internal.c.c;
import com.nomagic.ci.persistence.local.internal.c.i;
import com.nomagic.ci.persistence.local.internal.f.b;
import com.nomagic.ci.persistence.local.internal.f.c;
import com.nomagic.ci.persistence.local.internal.f.d;
import com.nomagic.ci.persistence.local.internal.n;
import com.nomagic.ci.persistence.local.internal.w;
import com.nomagic.ci.persistence.local.mounting.IProjectMountingService;
import com.nomagic.ci.persistence.local.spi.AbstractAttachedProject;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.DecompositionEventImpl;
import com.nomagic.ci.persistence.local.spi.IPrimaryProjectInternal;
import com.nomagic.ci.persistence.local.spi.IProjectRepositoryInternal;
import com.nomagic.ci.persistence.local.spi.IVersionableProjectRepositoryInternal;
import com.nomagic.ci.persistence.local.spi.ProjectAccessController;
import com.nomagic.ci.persistence.local.spi.ProjectUpdateContext;
import com.nomagic.ci.persistence.local.spi.autouse.AutomaticUsageConfigurator;
import com.nomagic.ci.persistence.local.spi.decomposition.AttachedProjectRemoveMethod;
import com.nomagic.ci.persistence.local.spi.decomposition.IAttachedProjectResolver;
import com.nomagic.ci.persistence.local.spi.decomposition.IReverseProjectUsageManager;
import com.nomagic.ci.persistence.local.spi.decomposition.ImportedUsagesHandler;
import com.nomagic.ci.persistence.local.spi.decomposition.LocalDecompositionModel;
import com.nomagic.ci.persistence.local.spi.events.ComplexOperationEventsUtil;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusEvent;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventListener;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProjectResolver;
import com.nomagic.ci.persistence.local.versioning.LocalVersioning;
import com.nomagic.ci.persistence.mounting.IMountPoint;
import com.nomagic.ci.persistence.spi.IAttachedProjectStateService;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.spi.decomposition.AttachmentType;
import com.nomagic.ci.persistence.spi.decomposition.DecompositionUtil;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.spi.decomposition.IllegalProjectRelationshipException;
import com.nomagic.ci.persistence.spi.decomposition.ProjectDecompositionEventType;
import com.nomagic.ci.persistence.spi.decomposition.ProjectDecompositionListener;
import com.nomagic.ci.persistence.util.EMFTypesUtil;
import com.nomagic.ci.persistence.util.ProjectUtil;
import com.nomagic.ci.persistence.versioning.IVersionDescriptor;
import com.nomagic.ci.persistence.versioning.IVersionableProjectRepository;
import com.nomagic.ci.persistence.versioning.Versioning;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;

public class ProjectDecompositionManager
extends NotifierImpl
implements IProjectDecompositionManager {
    public static final Logger LOGGER = Logger.getLogger(ProjectDecompositionManager.class);
    private final IPrimaryProjectInternal primary;
    private final c remover;
    private final AbstractProject project;
    private final boolean isAttachedProject;
    private Boolean isTransactional = null;
    n eventSupport = new n();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProjectDecompositionManager(IPrimaryProjectInternal iPrimaryProjectInternal, AbstractProject abstractProject, boolean bl) {
        if (iPrimaryProjectInternal == null) throw new NullPointerException();
        if (abstractProject == null) {
            throw new NullPointerException();
        }
        this.primary = iPrimaryProjectInternal;
        this.project = abstractProject;
        this.isAttachedProject = abstractProject instanceof IAttachedProject;
        this.remover = new c(iPrimaryProjectInternal);
        if (!bl) return;
        this.registerListeners();
        return;
    }

    public ProjectDecompositionManager(IPrimaryProjectInternal iPrimaryProjectInternal, AbstractProject abstractProject) {
        this(iPrimaryProjectInternal, abstractProject, true);
    }

    public ProjectDecompositionManager(ProjectDecompositionManager projectDecompositionManager) {
        this(projectDecompositionManager.primary, projectDecompositionManager.project, false);
    }

    private void registerListeners() {
        this.project.getServiceBusSupport().addListener(new ServiceEventListener(){

            @Override
            public void notify(ServiceBusEvent serviceBusEvent) {
                if (serviceBusEvent.getSource() instanceof AbstractProject && serviceBusEvent.getEventType().equals(AbstractProject.PROJECT_SAVE_DEPENDENCIES_PUBLISHED_EVENT_TYPE)) {
                    ProjectDecompositionManager.this.updateVersionableProjectUsages();
                    ProjectDecompositionManager.this.resolveUsedProjects();
                }
            }
        });
        this.project.addProjectListener(new ProjectListener(){

            public void notify(ProjectEvent projectEvent) {
                if (projectEvent.getEventType() == ProjectEventType.POST_SAVE) {
                    IProjectUsageManager iProjectUsageManager = ProjectDecompositionManager.this.project.getService(IProjectUsageManager.class);
                    for (ProjectUsage projectUsage : iProjectUsageManager.getProjectUsages()) {
                        projectUsage.setNew(false);
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateVersionableProjectUsages() {
        IProjectUsageManager iProjectUsageManager = this.project.getService(IProjectUsageManager.class);
        IAttachedProjectResolver iAttachedProjectResolver = this.project.getService(IAttachedProjectResolver.class);
        for (ProjectUsage projectUsage : iProjectUsageManager.getProjectUsages()) {
            IProject iProject = iProjectUsageManager.getProject((AbstractProjectUsage)projectUsage);
            if (!ProjectDecompositionManager.isUpdateVersion(iProject)) continue;
            com.nomagic.ci.persistence.local.internal.c.g.a(iAttachedProjectResolver, projectUsage, iProject);
        }
    }

    private static void updateProjectUsages(IProject iProject) {
        IProjectUsageManager iProjectUsageManager = (IProjectUsageManager)iProject.getService(IProjectUsageManager.class);
        ProjectDecompositionManager.updateUsages(iProjectUsageManager.getProjectUsages(), iProject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateUsages(Collection<ProjectUsage> collection, IProject iProject) {
        IAttachedProjectResolver iAttachedProjectResolver = (IAttachedProjectResolver)iProject.getService(IAttachedProjectResolver.class);
        for (ProjectUsage projectUsage : collection) {
            IProject iProject2 = ((IProjectUsageManager)iProject.getService(IProjectUsageManager.class)).getProject((AbstractProjectUsage)projectUsage);
            com.nomagic.ci.persistence.local.internal.c.g.a(iAttachedProjectResolver, projectUsage, iProject2);
        }
    }

    private static boolean isUpdateVersion(IProject iProject) {
        IProjectRepository iProjectRepository = iProject.getProjectRepository();
        if (iProjectRepository.getService(IVersionableProjectRepository.class) != null) {
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolveUsedProjects() {
        IProjectUsageManager iProjectUsageManager = this.project.getService(IProjectUsageManager.class);
        for (ProjectUsage projectUsage : iProjectUsageManager.getProjectUsages()) {
            IProject iProject = iProjectUsageManager.getProject((AbstractProjectUsage)projectUsage);
            if (iProject == null) continue;
            com.nomagic.ci.persistence.local.internal.c.g.a(projectUsage);
        }
    }

    private ProjectAccessController getAccessController() {
        return ((IProjectRepositoryInternal)this.project.getProjectRepository()).getProjectAccessController();
    }

    private void checkAccess(URI uRI) throws ProjectAccessException {
        if (!this.getAccessController().canRead(uRI)) {
            throw new ProjectAccessException();
        }
    }

    public IProject getProject() {
        return this.project;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AbstractProjectAttachmentConfiguration> getAttached() {
        List<AbstractProjectAttachmentConfiguration> list = Collections.emptyList();
        LocalDecompositionModel localDecompositionModel = this.getDecomposition();
        if (localDecompositionModel.isAvailable()) {
            list = new ArrayList<AbstractProjectAttachmentConfiguration>();
            EList eList = localDecompositionModel.getDecompositionProject().getProjectUsages();
            for (ProjectUsage projectUsage : eList) {
                list.add((AbstractProjectAttachmentConfiguration)this.createConfigurationFromUsage(projectUsage));
            }
        }
        return list;
    }

    public ProjectAttachmentConfiguration getConfiguration(IProject iProject) {
        IProjectUsageManager iProjectUsageManager = this.project.getService(IProjectUsageManager.class);
        ProjectUsage projectUsage = (ProjectUsage)iProjectUsageManager.getProjectUsage(iProject);
        ProjectAttachmentConfiguration projectAttachmentConfiguration = projectUsage != null ? this.createConfigurationFromUsage(projectUsage) : null;
        return projectAttachmentConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IProject> getAvailableAttachedProjects() {
        LocalDecompositionModel localDecompositionModel;
        List<IProject> list = Collections.emptyList();
        if (this.project.isProjectAvailable() && (localDecompositionModel = this.getDecomposition()).isAvailable()) {
            IProjectUsageManager iProjectUsageManager = this.project.getService(IProjectUsageManager.class);
            list = new ArrayList<IProject>();
            for (ProjectUsage projectUsage : localDecompositionModel.getDecompositionProject().getProjectUsages()) {
                IProject iProject;
                if (!this.isProjectUsageAcceptable(projectUsage) || (iProject = iProjectUsageManager.getProject((AbstractProjectUsage)projectUsage)) == null) continue;
                list.add(iProject);
            }
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<IProject> getAttachingProjectSet() {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        IReverseProjectUsageManager iReverseProjectUsageManager = this.project.getService(IReverseProjectUsageManager.class);
        for (IProject iProject : iReverseProjectUsageManager.getUsedBy()) {
            if (iProject instanceof IAttachedProject) {
                IProjectUsageManager iProjectUsageManager;
                ProjectUsage projectUsage;
                IAttachedProject iAttachedProject = (IAttachedProject)iProject;
                if (!((IAttachedProjectStateService)iAttachedProject.getService(IAttachedProjectStateService.class)).isLoaded() || (projectUsage = (ProjectUsage)(iProjectUsageManager = (IProjectUsageManager)iAttachedProject.getService(IProjectUsageManager.class)).getProjectUsage((IProject)this.project)) == null || !projectUsage.isReshared()) continue;
                hashSet.add(iProject);
                continue;
            }
            hashSet.add(iProject);
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<IProject, AbstractProjectAttachmentConfiguration> getAttachedProjects() {
        Map<IProject, AbstractProjectAttachmentConfiguration> map = Collections.emptyMap();
        LocalDecompositionModel localDecompositionModel = this.getDecomposition();
        if (localDecompositionModel.isAvailable()) {
            IProjectUsageManager iProjectUsageManager = this.project.getService(IProjectUsageManager.class);
            map = new LinkedHashMap<IProject, AbstractProjectAttachmentConfiguration>();
            for (ProjectUsage projectUsage : localDecompositionModel.getDecompositionProject().getProjectUsages()) {
                IProject iProject;
                if (!this.isProjectUsageAcceptable(projectUsage) || (iProject = iProjectUsageManager.getProject((AbstractProjectUsage)projectUsage)) == null) continue;
                ProjectAttachmentConfiguration projectAttachmentConfiguration = this.createConfigurationFromUsage(projectUsage);
                map.put(iProject, (AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration);
            }
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<IProject, AbstractProjectAttachmentConfiguration> getAttachingProjects() {
        HashMap<IProject, AbstractProjectAttachmentConfiguration> hashMap = new HashMap<IProject, AbstractProjectAttachmentConfiguration>();
        for (IProject iProject : ProjectUtil.getProjects((IPrimaryProject)this.primary)) {
            IProjectDecompositionManager iProjectDecompositionManager = (IProjectDecompositionManager)iProject.getService(IProjectDecompositionManager.class);
            AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration = (AbstractProjectAttachmentConfiguration)iProjectDecompositionManager.getAttachedProjects().get(this.project);
            if (abstractProjectAttachmentConfiguration == null) continue;
            hashMap.put(iProject, abstractProjectAttachmentConfiguration);
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isProjectUsageAcceptable(ProjectUsage projectUsage) {
        return projectUsage != null && (!this.isAttachedProject || projectUsage.isReshared());
    }

    public IAttachedProject attachNew(Set<String> set, URI uRI, IProgressMonitor iProgressMonitor) throws PersistenceException {
        IAttachedProject iAttachedProject;
        this.checkDecomposition();
        IProjectRepositoryInternal iProjectRepositoryInternal = this.findResourceSupportingRepository(uRI);
        if (iProjectRepositoryInternal == null) {
            throw new ProjectAllocationException("Can not find project repository capable of loading attached project at: " + uRI);
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = this.getTicksTime();
        boolean bl = false;
        iProgressMonitor.beginTask("Attaching a new project...", 1100 + n2 * 4);
        IAttachedProject iAttachedProject2 = null;
        ProjectAttachmentConfiguration projectAttachmentConfiguration = new ProjectAttachmentConfiguration(uRI);
        try {
            boolean bl2 = false;
            try {
                this.fireEvent(ProjectDecompositionEventType.PRE_ATTACH_PROJECT, (IProject)iAttachedProject2, uRI, (AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                this.interceptAttachProject((AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration, false, true);
                iAttachedProject2 = iProjectRepositoryInternal.createAttachedProject(uRI, set, this.primary, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 900));
                if (iAttachedProject2 == null) {
                    throw new IllegalStateException("Could not create attached project: " + uRI);
                }
                iProgressMonitor.subTask("Setting attached project defaults");
                ProjectUsage projectUsage = com.nomagic.ci.persistence.local.internal.c.g.a();
                projectUsage.setUsedProjectURI(iAttachedProject2.getLocationURI());
                projectUsage.setReadonly(false);
                projectUsage.setReshared(this.isAttachedProject);
                projectUsage.setLoadedAutomatically(true);
                this.registerUsedProject(projectUsage, (IProject)iAttachedProject2);
                this.registerUsage(projectUsage, (IProject)iAttachedProject2);
                ProjectDecompositionManager.updateUsages(Collections.singleton(projectUsage), this.project);
                projectAttachmentConfiguration = this.createConfigurationFromUsage(projectUsage);
                iProgressMonitor.worked(100);
                bl2 = true;
            }
            finally {
                com.nomagic.ci.persistence.local.internal.f.a.d.a((IProject)this.project, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            this.fireEvent(ProjectDecompositionEventType.POST_ATTACH_PROJECT, (IProject)iAttachedProject2, iAttachedProject2.getLocationURI(), (AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
            iAttachedProject = iAttachedProject2;
        }
        catch (Throwable throwable) {
            try {
                if (!bl) {
                    this.fireEvent(ProjectDecompositionEventType.FAILED_ATTACH_PROJECT, (IProject)iAttachedProject2, uRI, (AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
            }
            finally {
                iProgressMonitor.done();
            }
            throw throwable;
        }
        try {
            if (!bl) {
                this.fireEvent(ProjectDecompositionEventType.FAILED_ATTACH_PROJECT, (IProject)iAttachedProject2, uRI, (AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return iAttachedProject;
    }

    @Deprecated
    public void attachProject(IProject iProject, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("", 1000);
            this.checkDecomposition();
            this.checkInputProject(iProject);
            this.checkSelf(iProject);
            this.checkIsAttached(iProject, false);
            this.checkAccess(iProject.getLocationURI());
            ProjectUsage projectUsage = com.nomagic.ci.persistence.local.internal.c.g.a();
            projectUsage.setUsedProjectURI(iProject.getLocationURI());
            projectUsage.setReadonly(iProject.isReadOnly());
            projectUsage.setReshared(this.isAttachedProject);
            projectUsage.setLoadedAutomatically(true);
            this.registerUsedProject(projectUsage, iProject);
            this.registerUsage(projectUsage, iProject);
            iProgressMonitor.worked(500);
            this.updateNonEffectiveMounting(iProject, projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProject attachProjectConfigured(@Nonnull IProject iProject, ProjectAttachmentConfiguration projectAttachmentConfiguration, @CheckForNull Set<DependencyInfo<?>> set, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            AutomaticUsageConfigurator automaticUsageConfigurator2;
            boolean bl;
            iProgressMonitor.beginTask("", 1000);
            this.checkDecomposition();
            this.checkInputProject(iProject);
            ProjectAttachmentConfiguration projectAttachmentConfiguration2 = new ProjectAttachmentConfiguration(iProject);
            projectAttachmentConfiguration2.setReadOnly(projectAttachmentConfiguration != null ? projectAttachmentConfiguration.isReadOnly() : true);
            projectAttachmentConfiguration2.setStickyVersion(projectAttachmentConfiguration != null ? projectAttachmentConfiguration.getStickyVersion() : null);
            IProjectAttachmentConfigurator iProjectAttachmentConfigurator = this.project.getService(IProjectAttachmentConfigurator.class);
            if (iProjectAttachmentConfigurator != null) {
                iProjectAttachmentConfigurator.updateProjectAttachmentConfiguration(projectAttachmentConfiguration2, IProjectAttachmentConfigurator.AttachedProjectState.IMPLICIT);
            }
            iProgressMonitor.worked(200);
            boolean bl2 = bl = projectAttachmentConfiguration == null || projectAttachmentConfiguration.getAttachmentType() == AttachmentType.AUTOMATIC;
            if (bl && (automaticUsageConfigurator2 = (AutomaticUsageConfigurator)this.primary.getService(AutomaticUsageConfigurator.class)) != null) {
                AutomaticUsageConfigurator.UsageOrResharingAction usageOrResharingAction = automaticUsageConfigurator2.handleAutomaticUsageCreation(this.getProject(), iProject, set != null ? set : Collections.emptySet());
                bl = (usageOrResharingAction = com.nomagic.ci.persistence.local.internal.a.b.a(usageOrResharingAction, AutomaticUsageConfigurator.UsageOrResharingAction.ADD_AUTOMATIC, AutomaticUsageConfigurator.UsageOrResharingAction.ADD_MANUAL)) == AutomaticUsageConfigurator.UsageOrResharingAction.ADD_AUTOMATIC ? true : (usageOrResharingAction == AutomaticUsageConfigurator.UsageOrResharingAction.ADD_MANUAL ? false : bl);
            }
            boolean bl6 = bl ? false : projectAttachmentConfiguration2.isLoadedAutomatically();
            projectAttachmentConfiguration2.setLoadAutomatically(projectAttachmentConfiguration != null ? projectAttachmentConfiguration.isLoadedAutomatically() : bl6);
            IProject iProject4 = this.checkAndAttach((AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration2, false, bl, iProgressMonitor);
            return iProject4;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void attach(List<ImportProjectAttachmentConfiguration> list, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Attaching projects...", 1000 + 500 * list.size());
        try {
            ArrayList<IProject> arrayList = new ArrayList<IProject>();
            for (ImportProjectAttachmentConfiguration importProjectAttachmentConfiguration : list) {
                IProject iProject = this.internalAttachProject((AbstractProjectAttachmentConfiguration)importProjectAttachmentConfiguration.getAttachmentConfiguration(), false, true, importProjectAttachmentConfiguration.getFireEvents(), false, false, false, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                arrayList.add(iProject);
            }
            g g2 = (g)this.primary.getService(g.class);
            g2.a(this.project, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            ImportedUsagesHandler importedUsagesHandler = (ImportedUsagesHandler)this.getProject().getService(ImportedUsagesHandler.class);
            for (IProject iProject : arrayList) {
                if (importedUsagesHandler != null) {
                    importedUsagesHandler.outgoingUsageImported(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                } else {
                    iProgressMonitor.worked(200);
                }
                ImportedUsagesHandler importedUsagesHandler2 = (ImportedUsagesHandler)iProject.getService(ImportedUsagesHandler.class);
                if (importedUsagesHandler2 != null) {
                    importedUsagesHandler2.incomingUsageImported(this.getProject(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                    continue;
                }
                iProgressMonitor.worked(200);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void interceptAttachProject(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, boolean bl, boolean bl2) {
    }

    public IProject attachProject(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, IProgressMonitor iProgressMonitor) throws PersistenceException {
        return this.checkAndAttach(abstractProjectAttachmentConfiguration, true, false, iProgressMonitor);
    }

    private IProject checkAndAttach(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkDecomposition();
        if (bl) {
            this.checkAccess(abstractProjectAttachmentConfiguration.getAttachedProjectURI());
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        boolean bl3 = !bl2;
        boolean bl4 = bl3;
        IProject iProject = this.internalAttachProject(abstractProjectAttachmentConfiguration, true, false, true, true, true, bl4, bl2, iProgressMonitor);
        return iProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IProject internalAttachProject(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, IProgressMonitor iProgressMonitor) throws ProjectAllocationException, PersistenceException {
        IProject iProject;
        int n3 = bl3 ? this.getTicksTime() : 0;
        iProgressMonitor.beginTask("Attaching a project...", 1500 + n3 * 2);
        IProject iProject2 = null;
        boolean bl8 = false;
        try {
            boolean bl9 = false;
            try {
                if (bl3) {
                    this.fireEvent(ProjectDecompositionEventType.PRE_ATTACH_PROJECT, iProject2, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), abstractProjectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                }
                this.interceptAttachProject(abstractProjectAttachmentConfiguration, bl7, bl5);
                IProjectRepositoryInternal iProjectRepositoryInternal = (IProjectRepositoryInternal)this.project.getProjectRepository();
                this.updateRelatedProjectsBeforeAttach(iProjectRepositoryInternal, abstractProjectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
                iProject2 = this.doAttachProject(abstractProjectAttachmentConfiguration, bl, bl2, bl5, bl6, bl7, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                bl9 = true;
            }
            finally {
                if (bl4) {
                    com.nomagic.ci.persistence.local.internal.f.a.d.a((IProject)this.project, bl9, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                }
            }
            if (bl3) {
                this.fireEvent(ProjectDecompositionEventType.POST_ATTACH_PROJECT, iProject2, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), abstractProjectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            }
            bl8 = true;
            iProject = iProject2;
        }
        catch (Throwable throwable) {
            try {
                if (!bl3) throw throwable;
                if (bl8) throw throwable;
                this.fireEvent(ProjectDecompositionEventType.FAILED_ATTACH_PROJECT, iProject2, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), abstractProjectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                throw throwable;
            }
            finally {
                iProgressMonitor.done();
            }
        }
        try {
            if (!bl3) return iProject;
            if (bl8) return iProject;
            this.fireEvent(ProjectDecompositionEventType.FAILED_ATTACH_PROJECT, iProject2, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), abstractProjectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            return iProject;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IProject doAttachProject(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, IProgressMonitor iProgressMonitor) throws ProjectAllocationException, PersistenceException {
        this.checkIsAttached(abstractProjectAttachmentConfiguration, false);
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Loading attached project...", 1000);
        try {
            boolean bl6;
            ProjectUsage projectUsage = this.createProjectUsageFromConfiguration(abstractProjectAttachmentConfiguration);
            projectUsage.setNew(bl3);
            IProject iProject = abstractProjectAttachmentConfiguration.getAttachedProject();
            if (iProject == null) {
                iProject = this.findProject(projectUsage);
            }
            boolean bl7 = bl6 = iProject == null;
            if (bl6) {
                iProject = this.createAttachedProject(projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            } else {
                this.checkIsAttached(iProject, false);
                if (!bl2) {
                    this.checkSelf(iProject);
                }
            }
            projectUsage.setAutomatic(bl5);
            if (bl5 && bl3 && projectUsage.isReshared()) {
                projectUsage.setResharedAutomatically(true);
            }
            this.registerUsage(projectUsage, iProject);
            if (iProject instanceof IAttachedProject) {
                IAttachedProject iAttachedProject = (IAttachedProject)iProject;
                if (bl6) {
                    com.nomagic.ci.persistence.local.internal.f.a.d.a(iAttachedProject, (ProjectAttachmentConfiguration)abstractProjectAttachmentConfiguration);
                }
                if (bl4) {
                    g g2 = (g)this.primary.getService(g.class);
                    g2.a((IProject)this.project, iAttachedProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 900));
                }
            } else {
                LOGGER.debug((Object)("Skipped loading project from: " + abstractProjectAttachmentConfiguration.getAttachedProjectURI() + " It's a primary project."));
                iProgressMonitor.worked(1000);
            }
            this.registerUsedProject(projectUsage, iProject);
            ProjectDecompositionManager.updateUsages(Collections.singleton(projectUsage), this.project);
            if (!bl6) {
                this.updateNonEffectiveMounting(iProject, projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            IProject iProject2 = iProject;
            return iProject2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void updateNonEffectiveMounting(IProject iProject, ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) {
        block2: {
            if (LocalVersioning.isOrWillBeHistorical(iProject) && !com.nomagic.ci.persistence.local.internal.f.a.d.a(iProject, this.getProject())) break block2;
            d d2 = this.project.getService(d.class);
            d2.a(iProject, projectUsage, iProgressMonitor);
        }
    }

    private IAttachedProject getAttachedProject(ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) throws PersistenceException {
        IProjectRepositoryInternal iProjectRepositoryInternal;
        URI uRI = this.getProjectURI(projectUsage);
        if (uRI == null) {
            uRI = projectUsage.getUsedProjectURI();
            projectUsage.setResolvedProjectURI(uRI);
        }
        if ((iProjectRepositoryInternal = this.findProjectRepository(uRI)) == null) {
            iProjectRepositoryInternal = this.findResourceSupportingRepository(uRI);
        }
        if (iProjectRepositoryInternal == null) {
            throw new ProjectAllocationException("Can not find project repository capable of loading project at: " + uRI);
        }
        ProjectAttachmentConfiguration projectAttachmentConfiguration = new ProjectAttachmentConfiguration(uRI);
        this.updateAttachementConfiguration(projectUsage, projectAttachmentConfiguration);
        IAttachedProject iAttachedProject = iProjectRepositoryInternal.getAttachedProject((AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration, this.primary, iProgressMonitor);
        if (iAttachedProject == null) {
            throw new PersistenceRuntimeException("Failed to open attached project from: " + projectAttachmentConfiguration.getAttachedProjectURI());
        }
        return iAttachedProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateRelatedProjectsBeforeAttach(IProjectRepositoryInternal iProjectRepositoryInternal, AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, IProgressMonitor iProgressMonitor) throws ProjectAllocationException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Calculating if projects have to be updated before attaching...", 300);
        try {
            Set<IProject> set = new HashSet<IProject>();
            for (IProject iProject : ProjectUtil.getProjects((IPrimaryProject)this.primary)) {
                IProjectRepositoryInternal iProjectRepositoryInternal2;
                AbstractProject abstractProject = (AbstractProject)iProject;
                if (!abstractProject.isProjectAvailable() || !(iProjectRepositoryInternal2 = (IProjectRepositoryInternal)abstractProject.getProjectRepository()).projectHasToBeUpdatedBeforeAttaching(abstractProject, abstractProjectAttachmentConfiguration, iProjectRepositoryInternal)) continue;
                set.add(abstractProject);
            }
            iProgressMonitor.worked(100);
            if (set != null && set.size() > 0) {
                iProgressMonitor.subTask("Updating required projects");
                set = com.nomagic.ci.persistence.local.internal.m.b.a(set, false);
                if (set == null) return;
                if (set.isEmpty()) return;
                try {
                    com.nomagic.ci.persistence.local.internal.m.b.a(set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                    return;
                }
                catch (Exception exception) {
                    throw new ProjectAllocationException("Failed to update required projects", (Throwable)exception);
                }
            }
            iProgressMonitor.worked(200);
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reattachProject(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkDecomposition();
        ProjectUsage projectUsage = this.checkIsAttached(abstractProjectAttachmentConfiguration, true);
        IProject iProject = this.checkIsAvailable(projectUsage);
        this.interceptProjectReattach(iProject);
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = this.getTicksTime();
        boolean bl = false;
        iProgressMonitor.beginTask("Re-attaching project...", 1100 + n2 * 2);
        try {
            boolean bl2 = false;
            try {
                IVersionableProjectRepositoryInternal iVersionableProjectRepositoryInternal;
                this.fireEvent(ProjectDecompositionEventType.PRE_REATTACH_PROJECT, iProject, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), abstractProjectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                ProjectAttachmentConfiguration projectAttachmentConfiguration = this.createConfigurationFromUsage(projectUsage);
                IProjectRepositoryInternal iProjectRepositoryInternal = (IProjectRepositoryInternal)iProject.getProjectRepository();
                if ((projectAttachmentConfiguration.getStickyVersion() != null && abstractProjectAttachmentConfiguration.getStickyVersion() == null || projectAttachmentConfiguration.getStickyVersion() == null && abstractProjectAttachmentConfiguration.getStickyVersion() != null) && iProjectRepositoryInternal instanceof IVersionableProjectRepository && !(iVersionableProjectRepositoryInternal = (IVersionableProjectRepositoryInternal)((Object)iProjectRepositoryInternal)).supportsStickyFlagChange()) {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder("Can not reattach previously ").append(projectAttachmentConfiguration.getStickyVersion() != null ? "sticky" : "non-sticky").append(" attachment as ");
                    if (abstractProjectAttachmentConfiguration.getStickyVersion() != null) {
                        string = "sticky";
                        throw new UnsupportedOperationException(stringBuilder.append(string).toString());
                    }
                    string = "non-sticky";
                    throw new UnsupportedOperationException(stringBuilder.append(string).toString());
                }
                ProjectDecompositionManager.updateProjectUsage(abstractProjectAttachmentConfiguration, projectUsage);
                iProgressMonitor.worked(200);
                if (iProject instanceof IAttachedProject) {
                    iVersionableProjectRepositoryInternal = (IAttachedProject)iProject;
                    g g2 = (g)this.primary.getService(g.class);
                    g2.a((IProject)this.project, (IAttachedProject)iVersionableProjectRepositoryInternal, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
                    this.updateMountPointsIfNeeded((IAttachedProject)iVersionableProjectRepositoryInternal, ((ProjectAttachmentConfiguration)abstractProjectAttachmentConfiguration).getMountOptions(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                }
                bl2 = true;
            }
            finally {
                com.nomagic.ci.persistence.local.internal.f.a.d.a((IProject)this.project, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            this.fireEvent(ProjectDecompositionEventType.POST_REATTACH_PROJECT, iProject, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), abstractProjectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
            return;
        }
        finally {
            try {
                if (!bl) {
                    this.fireEvent(ProjectDecompositionEventType.FAILED_REATTACH_PROJECT, iProject, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), abstractProjectAttachmentConfiguration, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    public void detachProject(IProject iProject, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.detachProject(iProject, null, AttachedProjectRemoveMethod.getDefaultMethod(), iProgressMonitor);
    }

    public void checkProjectTobeDetached(IProject iProject) throws PersistenceException {
        this.checkDecomposition();
        this.checkInputProject(iProject);
        this.checkIsAttached(iProject, true);
        this.interceptProjectDetach(iProject);
    }

    public void detachProject(IProject iProject, IAttachedProjectRemoverCallback iAttachedProjectRemoverCallback, AttachedProjectRemoveMethod attachedProjectRemoveMethod, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkProjectTobeDetached(iProject);
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = this.getTicksTime();
        iProgressMonitor.beginTask("", 1100 + 2 * n2);
        boolean bl = false;
        try {
            boolean bl2 = false;
            try {
                this.firePreDetach(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                Set<IProject> set = Collections.singleton(iProject);
                if (iAttachedProjectRemoverCallback != null) {
                    Map<IProject, Set<IProject>> map = this.getReverseDetachMap(set);
                    Set set2 = DecompositionUtil.calcProjectsToRemove(map);
                    if (!iAttachedProjectRemoverCallback.confirmRemove(set2, Collections.singleton(this.project))) {
                        throw new OperationCanceledException();
                    }
                }
                this.removeUsagesForAttachedProjects(set, attachedProjectRemoveMethod, iProgressMonitor);
                iProgressMonitor.worked(100);
                bl2 = true;
            }
            finally {
                com.nomagic.ci.persistence.local.internal.f.a.d.a((IProject)this.project, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            }
            this.firePostDetach(iProject, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
        }
        finally {
            try {
                if (!bl) {
                    this.firePostDetach(iProject, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    public void firePreDetach(IProject iProject, IProgressMonitor iProgressMonitor) {
        ProjectAttachmentConfiguration projectAttachmentConfiguration = new ProjectAttachmentConfiguration(iProject.getLocationURI());
        this.fireEvent(ProjectDecompositionEventType.PRE_DETACH_PROJECT, iProject, iProject.getLocationURI(), (AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration, iProgressMonitor);
    }

    public void firePostDetach(IProject iProject, boolean bl, IProgressMonitor iProgressMonitor) {
        ProjectAttachmentConfiguration projectAttachmentConfiguration = new ProjectAttachmentConfiguration(iProject.getLocationURI());
        ProjectDecompositionEventType projectDecompositionEventType = bl ? ProjectDecompositionEventType.POST_DETACH_PROJECT : ProjectDecompositionEventType.FAILED_DETACH_PROJECT;
        ProjectDecompositionEventType projectDecompositionEventType2 = projectDecompositionEventType;
        this.fireEvent(projectDecompositionEventType2, iProject, iProject.getLocationURI(), (AbstractProjectAttachmentConfiguration)projectAttachmentConfiguration, iProgressMonitor);
    }

    protected void interceptProjectDetach(IProject iProject) {
    }

    protected void interceptProjectReattach(IProject iProject) {
    }

    public void loadManualAndLoadableAttachedProjects(IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.createAttachedProjects(iProgressMonitor, projectUsage -> {
            boolean bl = projectUsage.getResolvedProjectURI() != null;
            return bl;
        });
    }

    public Set<IAttachedProject> createAllAttachedProjects(IProgressMonitor iProgressMonitor) throws PersistenceException {
        return this.createAttachedProjects(iProgressMonitor, projectUsage -> true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<IAttachedProject> createAttachedProjects(IProgressMonitor iProgressMonitor, Predicate<ProjectUsage> predicate) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("Loading attached projects...", 2000);
            LOGGER.debug((Object)("Loading attached projects for project: " + this.project));
            HashSet<IAttachedProject> hashSet = new HashSet<IAttachedProject>();
            LocalDecompositionModel localDecompositionModel = this.checkDecomposition();
            EList eList = localDecompositionModel.getDecompositionProject().getProjectUsages();
            if (!eList.isEmpty()) {
                int n2 = 1000 / eList.size();
                for (ProjectUsage projectUsage : eList) {
                    IProject iProject;
                    if (predicate.test(projectUsage) && (!this.isAttachedProject || projectUsage.isReshared()) && (iProject = this.findProject(projectUsage)) == null) {
                        IAttachedProject iAttachedProject = this.createAttachedProject(projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                        hashSet.add(iAttachedProject);
                    }
                    iProgressMonitor.worked(n2);
                }
                ProjectDecompositionManager.updateProjectUsages(this.project);
            }
            LOGGER.debug((Object)("DONE Loading attached projects for project: " + this.project));
            HashSet<IAttachedProject> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void unloadAttachedProjects(IProgressMonitor iProgressMonitor) throws PersistenceException {
        block12: {
            try {
                c.a a2;
                block11: {
                    iProgressMonitor.beginTask("", 1200);
                    List<IProject> list = this.getAvailableAttachedProjects();
                    Map<IProject, Set<IProject>> map = this.getReverseDetachMap(list);
                    iProgressMonitor.worked(100);
                    Set set = DecompositionUtil.calcProjectsToRemove(map);
                    iProgressMonitor.worked(100);
                    AttachedProjectRemoveMethod attachedProjectRemoveMethod = AttachedProjectRemoveMethod.NO_PHYSICAL_DETACH_FULL_UNMOUNT;
                    a2 = com.nomagic.ci.persistence.local.internal.f.a.d.a(this.primary, map, set, attachedProjectRemoveMethod);
                    a2.a((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                    boolean bl = false;
                    try {
                        this.remover.a(set, attachedProjectRemoveMethod, null, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            block9: {
                                if (!bl) break block9;
                                a2.b((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                                break block10;
                            }
                            a2.c((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                        }
                        throw throwable;
                    }
                    if (!bl) break block11;
                    a2.b((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                    break block12;
                }
                a2.c((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<IProject, Set<IProject>> getReverseDetachMap(Collection<? extends IProject> collection) {
        Set<AbstractProject> set = Collections.singleton(this.project);
        HashMap<IProject, Set<IProject>> hashMap = new HashMap<IProject, Set<IProject>>();
        for (IProject iProject : collection) {
            hashMap.put(iProject, set);
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAttachedProjects(ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkDecomposition();
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Updating attached projects...", 2100);
        try {
            Map<ProjectUsage, IAttachedProject> map = com.nomagic.ci.persistence.local.internal.m.b.c(this.project);
            iProgressMonitor.worked(100);
            if (map.isEmpty()) return;
            int n2 = 2000 / map.size();
            IProjectUsageManager iProjectUsageManager = this.project.getService(IProjectUsageManager.class);
            for (Map.Entry<ProjectUsage, IAttachedProject> entry : map.entrySet()) {
                ProjectUsage projectUsage = entry.getKey();
                IAttachedProject iAttachedProject = entry.getValue();
                if (iAttachedProject == null) {
                    IProject iProject = iProjectUsageManager.findProject((AbstractProjectUsage)projectUsage);
                    if (iProject != null) {
                        LOGGER.info((Object)String.format("Found attached project with projectID %s and location uri %s for usage with used project uri %s ( resolved %s ). Therefore attached project will not be created.", iProject.getProjectID(), iProject.getLocationURI(), projectUsage.getUsedProjectURI(), projectUsage.getResolvedProjectURI()));
                        iProgressMonitor.worked(n2);
                        continue;
                    }
                    this.createAttachedProject(projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                    continue;
                }
                iProgressMonitor.worked(n2);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeUsagesForAttachedProjects(Set<? extends IProject> set, AttachedProjectRemoveMethod attachedProjectRemoveMethod, IProgressMonitor iProgressMonitor) {
        if (!set.isEmpty()) {
            i i2 = i.a(ComplexOperationEventsUtil.getCurrentContext(this.primary), true);
            i2.a(attachedProjectRemoveMethod);
            IProjectUsageManager iProjectUsageManager = (IProjectUsageManager)this.getProject().getService(IProjectUsageManager.class);
            for (IProject iProject : set) {
                ProjectUsage projectUsage = (ProjectUsage)iProjectUsageManager.getProjectUsage(iProject);
                if (projectUsage == null) continue;
                i2.removeUsage((AbstractProjectUsage)projectUsage);
            }
        }
    }

    public IAttachedProject createAttachedProject(ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Create attached project...", 1000);
        try {
            LOGGER.info((Object)String.format("Creating attached project for usage %s (resolved %s)", projectUsage.getUsedProjectURI(), projectUsage.getResolvedProjectURI()));
            IAttachedProject iAttachedProject = this.getAttachedProject(projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
            AbstractAttachedProject abstractAttachedProject = (AbstractAttachedProject)iAttachedProject;
            abstractAttachedProject.create(this.getProject(), projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
            IAttachedProject iAttachedProject2 = iAttachedProject;
            return iAttachedProject2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private ProjectUsage findUsageByRelativeURI(Collection<ProjectUsage> collection, URI uRI) {
        for (ProjectUsage projectUsage : collection) {
            if (!uRI.equals((Object)projectUsage.getUsedProjectURI())) continue;
            return projectUsage;
        }
        return null;
    }

    protected ProjectUsage getProjectUsage(IProject iProject) {
        IProjectUsageManager iProjectUsageManager = this.project.getService(IProjectUsageManager.class);
        return (ProjectUsage)iProjectUsageManager.getProjectUsage(iProject);
    }

    private IProject getProject(ProjectUsage projectUsage) {
        return this.project.getService(IProjectUsageManager.class).getProject((AbstractProjectUsage)projectUsage);
    }

    private IProject findProject(ProjectUsage projectUsage) {
        return this.project.getService(IProjectUsageManager.class).findProject((AbstractProjectUsage)projectUsage);
    }

    public ProjectUsage findProjectUsageCompat(URI uRI) {
        IProject iProject;
        LocalProject localProject = this.getDecomposition().getDecompositionProject();
        ProjectUsage projectUsage = this.findUsageByRelativeURI((Collection<ProjectUsage>)localProject.getProjectUsages(), uRI);
        if (projectUsage == null && (iProject = this.findProject(uRI)) != null) {
            projectUsage = this.getProjectUsage(iProject);
        }
        return projectUsage;
    }

    private IProject findProject(URI uRI) {
        for (IProject iProject : ProjectUtil.getProjects((IPrimaryProject)this.primary)) {
            if (!I.a(iProject, uRI)) continue;
            return iProject;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerUsedProject(ProjectUsage projectUsage, IProject iProject) {
        LocalDecompositionModel localDecompositionModel = (LocalDecompositionModel)iProject.getService(IDecompositionModel.class);
        if (localDecompositionModel == null) return;
        if (!localDecompositionModel.isAvailable()) return;
        com.nomagic.ci.persistence.local.internal.c.g.a(this.getProject(), projectUsage, iProject, localDecompositionModel.getDecompositionProject());
    }

    private void registerUsage(ProjectUsage projectUsage, IProject iProject) {
        this.checkForPotentialDuplicates(projectUsage, iProject);
        this.project.getService(w.class).a(projectUsage, iProject);
        LocalProject localProject = this.checkDecomposition().getDecompositionProject();
        projectUsage.setProject(localProject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForPotentialDuplicates(ProjectUsage projectUsage, IProject iProject) {
        LocalProject localProject;
        LocalDecompositionModel localDecompositionModel;
        String string = this.getUsedFileName(projectUsage);
        if (string != null && (localDecompositionModel = this.getDecomposition()).isAvailable() && (localProject = localDecompositionModel.getDecompositionProject()) != null) {
            for (ProjectUsage projectUsage2 : localProject.getProjectUsages()) {
                String string2 = this.getUsedFileName(projectUsage2);
                if (!string.equals(string2)) continue;
                String string3 = "Potentially duplicating project usage injected into project " + this.projectToString(this.project) + ", used project: " + this.projectToString(iProject) + ". Already existing usage: " + this.usageToString(projectUsage2) + ", the newly injected usage: " + this.usageToString(projectUsage) + ". Please report bug and attach this error.";
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
                if (Boolean.getBoolean("ci.usageManager.throwPotentiallyDuplicateUsageException")) {
                    throw illegalArgumentException;
                }
                LOGGER.error((Object)string3, (Throwable)illegalArgumentException);
            }
        }
    }

    private String getUsedFileName(ProjectUsage projectUsage) {
        URI uRI = projectUsage.getUsedProjectURI();
        if (!uRI.isFile()) {
            return null;
        }
        File file = new File(uRI.toFileString());
        return file.getName();
    }

    private String projectToString(IProject iProject) {
        StringBuilder stringBuilder = new StringBuilder("{locationURI=").append(iProject.getLocationURI()).append(", type=");
        String string = iProject instanceof IPrimaryProject ? "primary" : "attached";
        return stringBuilder.append(string).append("}").toString();
    }

    private String usageToString(ProjectUsage projectUsage) {
        return "{usedProjectURI=" + projectUsage.getUsedProjectURI() + ", reshared=" + projectUsage.isReshared() + "}";
    }

    private LocalDecompositionModel getDecomposition() {
        return (LocalDecompositionModel)this.project.getService(IDecompositionModel.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LocalDecompositionModel checkDecomposition() {
        LocalDecompositionModel localDecompositionModel = this.getDecomposition();
        if (localDecompositionModel != null && localDecompositionModel.isAvailable()) {
            return localDecompositionModel;
        }
        throw new ProjectConfigurationException("Project must be loaded and decomposition model must be available in order to modify attached projects");
    }

    private void checkInputProject(IProject iProject) {
        if (iProject == null) {
            throw new IllegalArgumentException("Given project is null");
        }
        if (ProjectUtil.getPrimaryProject((IProject)iProject) != this.primary) {
            throw new IllegalArgumentException("Given project belongs to other primary project");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProjectUsage checkIsAttached(IProject iProject, boolean bl) throws IllegalProjectRelationshipException {
        ProjectUsage projectUsage = this.getProjectUsage(iProject);
        if (bl && projectUsage == null) {
            throw new IllegalProjectRelationshipException(iProject, (IProject)this.project, IllegalProjectRelationshipException.IllegalRelationship.NOT_ATTACHED);
        }
        if (!bl && projectUsage != null) {
            throw new IllegalProjectRelationshipException(iProject, (IProject)this.project, IllegalProjectRelationshipException.IllegalRelationship.ATTACHED);
        }
        return projectUsage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProjectUsage checkIsAttached(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, boolean bl) throws PersistenceException {
        ProjectUsage projectUsage = this.findProjectUsageCompat(abstractProjectAttachmentConfiguration.getAttachedProjectURI());
        if (bl && projectUsage == null) {
            throw new IllegalProjectRelationshipException(abstractProjectAttachmentConfiguration, (IProject)this.project, IllegalProjectRelationshipException.IllegalRelationship.NOT_ATTACHED);
        }
        if (!bl && projectUsage != null) {
            IProject iProject = this.getProject(projectUsage);
            if (iProject != null) {
                throw new IllegalProjectRelationshipException(iProject, (IProject)this.project, IllegalProjectRelationshipException.IllegalRelationship.ATTACHED);
            }
            throw new IllegalProjectRelationshipException(abstractProjectAttachmentConfiguration, (IProject)this.project, IllegalProjectRelationshipException.IllegalRelationship.ATTACHED);
        }
        return projectUsage;
    }

    private void checkSelf(IProject iProject) throws PersistenceException {
        if (this.project == iProject) {
            throw new IllegalProjectRelationshipException((IProject)this.project, (IProject)this.project, IllegalProjectRelationshipException.IllegalRelationship.SELF);
        }
    }

    private IProject checkIsAvailable(ProjectUsage projectUsage) throws ProjectAllocationException {
        IProject iProject = this.getProject(projectUsage);
        if (iProject == null) {
            throw new ProjectAllocationException("Project is not available: " + projectUsage.getUsedProjectURI());
        }
        return iProject;
    }

    private IProjectRepositoryInternal findProjectRepository(URI uRI) {
        if (this.project.getProjectRepository().canOpenProject(uRI)) {
            return (IProjectRepositoryInternal)this.project.getProjectRepository();
        }
        return (IProjectRepositoryInternal)ProjectRepositoryRegistry.getInstance().getProjectRepository(uRI);
    }

    public IProjectRepositoryInternal findResourceSupportingRepository(URI uRI) {
        if (this.project.getProjectRepository().getType().isResourceSupported(uRI)) {
            return (IProjectRepositoryInternal)this.project.getProjectRepository();
        }
        return (IProjectRepositoryInternal)ProjectRepositoryRegistry.getInstance().getLocationRepository(uRI);
    }

    private ProjectUsage createProjectUsageFromConfiguration(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration) {
        ProjectUsage projectUsage = com.nomagic.ci.persistence.local.internal.c.g.a();
        ProjectDecompositionManager.updateProjectUsage(abstractProjectAttachmentConfiguration, projectUsage);
        projectUsage.setReshared(this.isAttachedProject);
        return projectUsage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateProjectUsage(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, ProjectUsage projectUsage) {
        projectUsage.setUsedProjectURI(abstractProjectAttachmentConfiguration.getAttachedProjectURI());
        ProjectAttachmentConfiguration projectAttachmentConfiguration = (ProjectAttachmentConfiguration)abstractProjectAttachmentConfiguration;
        projectUsage.setPreferredProjectRepositoryType(projectAttachmentConfiguration.getPreferredProjectRepositoryType());
        projectUsage.setReadonly(abstractProjectAttachmentConfiguration.isReadOnly());
        IVersionDescriptor iVersionDescriptor = abstractProjectAttachmentConfiguration.getStickyVersion();
        projectUsage.setVersion(iVersionDescriptor != null ? iVersionDescriptor.getName() : null);
        projectUsage.setSticky(iVersionDescriptor != null);
        com.nomagic.ci.persistence.a.d d2 = new com.nomagic.ci.persistence.a.d();
        for (String string : abstractProjectAttachmentConfiguration.getCustomOptionNames()) {
            d2.put((Object)string, (Object)abstractProjectAttachmentConfiguration.getCustomOptionValue(string));
        }
        projectUsage.getProperties().putAll((EMap)d2);
        projectUsage.setLoadedAutomatically(projectAttachmentConfiguration.isLoadedAutomatically());
        projectUsage.setAutomatic(projectAttachmentConfiguration.getAttachmentType() == AttachmentType.AUTOMATIC);
    }

    private ProjectAttachmentConfiguration createConfigurationFromUsage(ProjectUsage projectUsage) {
        URI uRI = projectUsage.getUsedProjectURI();
        ProjectAttachmentConfiguration projectAttachmentConfiguration = new ProjectAttachmentConfiguration(uRI);
        this.updateAttachementConfiguration(projectUsage, projectAttachmentConfiguration);
        return projectAttachmentConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAttachementConfiguration(ProjectUsage projectUsage, ProjectAttachmentConfiguration projectAttachmentConfiguration) {
        HashMap<String, Map> hashMap2;
        projectAttachmentConfiguration.setPreferredProjectRepositoryType(projectUsage.getPreferredProjectRepositoryType());
        projectAttachmentConfiguration.setReadOnly(projectUsage.isReadonly());
        projectAttachmentConfiguration.setLoadAutomatically(projectUsage.isLoadedAutomatically());
        if (projectUsage.getProperties() != null) {
            for (HashMap<String, Map> hashMap2 : projectUsage.getProperties().entrySet()) {
                projectAttachmentConfiguration.setCustomOptionValue((String)hashMap2.getKey(), (String)hashMap2.getValue());
            }
        }
        if (projectAttachmentConfiguration.getCustomOptionValue("LOCAL_PROJECT_ID") == null && (hashMap2 = LocalProjectResolver.extractUsedProjectID(projectUsage)) != null) {
            projectAttachmentConfiguration.setCustomOptionValue("LOCAL_PROJECT_ID", (String)((Object)hashMap2));
        }
        if (projectUsage.isSticky() || Versioning.isHistorical((IProject)this.project)) {
            hashMap2 = this.getVersion(projectUsage);
            projectAttachmentConfiguration.setStickyVersion((IVersionDescriptor)hashMap2);
        }
        if (projectUsage.getMountPoints() != null && !projectUsage.getMountPoints().isEmpty()) {
            hashMap2 = new HashMap<String, Map>();
            for (MountPoint mountPoint : projectUsage.getMountPoints()) {
                hashMap2.put(mountPoint.getSharePointID(), EMFTypesUtil.getMapFromEMap((EMap)mountPoint.getOptions()));
            }
        }
        projectAttachmentConfiguration.setAttachmentType(projectUsage.isAutomatic() ? AttachmentType.AUTOMATIC : AttachmentType.MANUAL);
    }

    private IVersionDescriptor getVersion(ProjectUsage projectUsage) {
        return this.project.getService(IAttachedProjectResolver.class).getProjectVersion(projectUsage);
    }

    @CheckForNull
    private URI getProjectURI(ProjectUsage projectUsage) {
        return this.project.getService(IAttachedProjectResolver.class).getProjectURI(projectUsage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateMountPointsIfNeeded(IAttachedProject iAttachedProject, Map<String, Map<String, String>> map, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("Updating mount points...", 1000);
        if (map != null && !map.isEmpty()) {
            int n2 = 1000 / map.size();
            IProjectMountingService iProjectMountingService = this.project.getService(IProjectMountingService.class);
            for (IMountPoint iMountPoint : iProjectMountingService.getMountPointsForProject((IProject)iAttachedProject, null)) {
                b b2 = (b)iMountPoint;
                if (!map.containsKey(b2.d())) continue;
                iProjectMountingService.updateMountPoint(iMountPoint, map.get(b2.d()), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            }
        }
        iProgressMonitor.done();
    }

    protected void fireEvent(ProjectDecompositionEventType projectDecompositionEventType, IProject iProject, URI uRI, AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, IProgressMonitor iProgressMonitor) {
        block6: {
            try {
                SubProgressMonitor subProgressMonitor;
                SubProgressMonitor subProgressMonitor2;
                B b2;
                DecompositionEventImpl decompositionEventImpl;
                block5: {
                    iProgressMonitor.beginTask("", this.getTicksTime());
                    ProjectEventType projectEventType = this.getProjectEventType(projectDecompositionEventType);
                    decompositionEventImpl = new DecompositionEventImpl(this.primary, projectEventType, this.project, iProject, uRI, abstractProjectAttachmentConfiguration, this);
                    b2 = new B(this.primary, projectDecompositionEventType, this.project, iProject, uRI, abstractProjectAttachmentConfiguration, this);
                    subProgressMonitor2 = new SubProgressMonitor(iProgressMonitor, this.getProjectTicksTime());
                    subProgressMonitor = new SubProgressMonitor(iProgressMonitor, this.getDecompositionTicksTime());
                    if (!projectDecompositionEventType.isPreEvent()) break block5;
                    this.project.fireEvent(decompositionEventImpl, (IProgressMonitor)subProgressMonitor2);
                    this.eventSupport.fireEvent(b2, (IProgressMonitor)subProgressMonitor);
                    break block6;
                }
                this.eventSupport.fireEvent(b2, (IProgressMonitor)subProgressMonitor);
                this.project.fireEvent(decompositionEventImpl, (IProgressMonitor)subProgressMonitor2);
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    private ProjectEventType getProjectEventType(ProjectDecompositionEventType projectDecompositionEventType) {
        ProjectEventType projectEventType = null;
        switch (projectDecompositionEventType) {
            case PRE_ATTACH_PROJECT: {
                projectEventType = ProjectEventType.PRE_ATTACH_PROJECT;
                break;
            }
            case PRE_DETACH_PROJECT: {
                projectEventType = ProjectEventType.PRE_DETACH_PROJECT;
                break;
            }
            case PRE_REATTACH_PROJECT: {
                projectEventType = ProjectEventType.PRE_REATTACH_PROJECT;
                break;
            }
            case POST_ATTACH_PROJECT: {
                projectEventType = ProjectEventType.POST_ATTACH_PROJECT;
                break;
            }
            case POST_DETACH_PROJECT: {
                projectEventType = ProjectEventType.POST_DETACH_PROJECT;
                break;
            }
            case POST_REATTACH_PROJECT: {
                projectEventType = ProjectEventType.POST_REATTACH_PROJECT;
                break;
            }
            case FAILED_ATTACH_PROJECT: {
                projectEventType = ProjectEventType.FAILED_ATTACH_PROJECT;
                break;
            }
            case FAILED_DETACH_PROJECT: {
                projectEventType = ProjectEventType.FAILED_DETACH_PROJECT;
                break;
            }
            case FAILED_REATTACH_PROJECT: {
                projectEventType = ProjectEventType.FAILED_REATTACH_PROJECT;
                break;
            }
        }
        if (projectEventType == null) {
            throw new IllegalArgumentException("Unmapped ProjectDecompositionEventType: " + projectDecompositionEventType);
        }
        return projectEventType;
    }

    public void addListener(ProjectDecompositionListener projectDecompositionListener) {
        this.eventSupport.addListener(projectDecompositionListener);
    }

    public void removeListener(ProjectDecompositionListener projectDecompositionListener) {
        this.eventSupport.removeListener(projectDecompositionListener);
    }

    public List<ProjectDecompositionListener> getListeners() {
        return this.eventSupport.getListeners();
    }

    public boolean isManuallyReachable() {
        if (this.getProject() instanceof AbstractAttachedProject) {
            return ((AbstractAttachedProject)this.getProject()).isManuallyReachable();
        }
        return true;
    }

    private int getTicksTime() {
        return this.getProjectTicksTime() + this.getDecompositionTicksTime();
    }

    private int getProjectTicksTime() {
        return this.project.getListenerTicks() * 100;
    }

    private int getDecompositionTicksTime() {
        return this.eventSupport.getListenerCount() * 100;
    }
}

