/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.metamodel.local.project.LocalDataSection;
import com.nomagic.ci.metamodel.local.project.LocalProject;
import com.nomagic.ci.metamodel.local.project.LocalProjectFeature;
import com.nomagic.ci.metamodel.local.project.ProjectPackage;
import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.metamodel.local.project.SharePoint;
import com.nomagic.ci.persistence.ProjectDescriptor;
import com.nomagic.ci.persistence.local.decomposition.LocalDecompositionDescriptor;
import com.nomagic.ci.persistence.local.spi.decomposition.IProjectUsageResolver;
import com.nomagic.ci.persistence.util.EMFTypesUtil;
import com.nomagic.ci.persistence.versioning.IVersionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class LocalDescriptorFactory {
    public static final LocalDescriptorFactory DEFAULT = new LocalDescriptorFactory();

    public ProjectDescriptor createProjectDescriptor(URI uRI, String string, String string2) {
        return new ProjectDescriptor(uRI, string, string2);
    }

    protected Collection<LocalDecompositionDescriptor.LocalProjectFeatureDescriptor> createProjectFeatureDescriptors(LocalProject localProject) {
        if (localProject.getFeatures() == null) {
            return Collections.emptyList();
        }
        ArrayList<LocalDecompositionDescriptor.LocalProjectFeatureDescriptor> arrayList = new ArrayList<LocalDecompositionDescriptor.LocalProjectFeatureDescriptor>();
        for (LocalProjectFeature localProjectFeature : localProject.getFeatures()) {
            Collection<LocalDecompositionDescriptor.LocalResourceDescriptor> collection = this.createResourceDescriptors(localProjectFeature);
            LocalDecompositionDescriptor.LocalProjectFeatureDescriptor localProjectFeatureDescriptor = new LocalDecompositionDescriptor.LocalProjectFeatureDescriptor(localProjectFeature.getName(), localProjectFeature.getNamespace(), localProjectFeature.getVersion(), localProjectFeature.getInternalVersion(), collection);
            arrayList.add(localProjectFeatureDescriptor);
        }
        return arrayList;
    }

    public Collection<LocalDecompositionDescriptor.AttachedProjectDescriptor> createAttachedProjectDescriptor(LocalProject localProject, IProjectUsageResolver iProjectUsageResolver) {
        if (localProject.getProjectUsages() == null || iProjectUsageResolver == null) {
            return Collections.emptyList();
        }
        ArrayList<LocalDecompositionDescriptor.AttachedProjectDescriptor> arrayList = new ArrayList<LocalDecompositionDescriptor.AttachedProjectDescriptor>();
        for (ProjectUsage projectUsage : localProject.getProjectUsages()) {
            Object object2;
            URI uRI = null;
            IVersionDescriptor iVersionDescriptor = null;
            uRI = iProjectUsageResolver.getProjectURI(projectUsage);
            if (projectUsage.getVersion() != null && projectUsage.isSticky()) {
                iVersionDescriptor = iProjectUsageResolver.getProjectVersion(projectUsage);
            }
            ArrayList<LocalDecompositionDescriptor.MountPointDescriptor> arrayList2 = new ArrayList<LocalDecompositionDescriptor.MountPointDescriptor>();
            for (Object object2 : projectUsage.getMountPoints()) {
                Map map = EMFTypesUtil.getMapFromEMap((EMap)object2.getOptions());
                LocalDecompositionDescriptor.MountPointDescriptor mountPointDescriptor = new LocalDecompositionDescriptor.MountPointDescriptor(object2.getSharePointID(), map);
                arrayList2.add(mountPointDescriptor);
            }
            object2 = new LocalDecompositionDescriptor.AttachedProjectDescriptor(projectUsage.getUsedProjectURI(), uRI, projectUsage.isReadonly(), projectUsage.isReshared(), projectUsage.isResharedAutomatically(), projectUsage.isLoadedAutomatically(), projectUsage.isAutomatic(), EMFTypesUtil.getMapFromEMap((EMap)projectUsage.getProperties()), iVersionDescriptor, arrayList2);
            arrayList.add((LocalDecompositionDescriptor.AttachedProjectDescriptor)object2);
        }
        return arrayList;
    }

    protected Collection<LocalDecompositionDescriptor.LocalResourceDescriptor> createResourceDescriptors(LocalProjectFeature localProjectFeature) {
        if (localProjectFeature.getCommonSections() == null) {
            return Collections.emptyList();
        }
        ArrayList<LocalDecompositionDescriptor.LocalResourceDescriptor> arrayList = new ArrayList<LocalDecompositionDescriptor.LocalResourceDescriptor>();
        for (LocalDataSection localDataSection : localProjectFeature.getCommonSections()) {
            Map map = EMFTypesUtil.getMapFromEMap((EMap)localDataSection.getProperties());
            Collection<LocalDecompositionDescriptor.SharePointDescriptor> collection = this.createSharePointDescriptors(localDataSection);
            LocalDecompositionDescriptor.LocalResourceDescriptor localResourceDescriptor = new LocalDecompositionDescriptor.LocalResourceDescriptor(localDataSection.getName(), localDataSection.isShared(), map, collection);
            arrayList.add(localResourceDescriptor);
        }
        return arrayList;
    }

    protected Collection<LocalDecompositionDescriptor.SharePointDescriptor> createSharePointDescriptors(LocalDataSection localDataSection) {
        if (localDataSection.getSharePoints() == null) {
            return Collections.emptyList();
        }
        ArrayList<LocalDecompositionDescriptor.SharePointDescriptor> arrayList = new ArrayList<LocalDecompositionDescriptor.SharePointDescriptor>();
        for (SharePoint sharePoint : localDataSection.getSharePoints()) {
            Map map = EMFTypesUtil.getMapFromEMap((EMap)sharePoint.getOptions());
            EObject eObject = (EObject)sharePoint.eGet((EStructuralFeature)ProjectPackage.eINSTANCE.getSharePoint_Object(), false);
            String string = EcoreUtil.getURI((EObject)eObject).fragment();
            LocalDecompositionDescriptor.SharePointDescriptor sharePointDescriptor = new LocalDecompositionDescriptor.SharePointDescriptor(sharePoint.getID(), map, eObject, string);
            arrayList.add(sharePointDescriptor);
        }
        return arrayList;
    }

    public LocalDecompositionDescriptor createDecompositionDescriptor(ProjectDescriptor projectDescriptor, String string, Map<String, String> map, Collection<LocalDecompositionDescriptor.LocalProjectFeatureDescriptor> collection, Collection<LocalDecompositionDescriptor.AttachedProjectDescriptor> collection2) {
        return new LocalDecompositionDescriptor(projectDescriptor, string, map, collection, collection2);
    }

    public LocalDecompositionDescriptor createDecompositionDescriptor(ProjectDescriptor projectDescriptor, String string, Collection<LocalDecompositionDescriptor.LocalProjectFeatureDescriptor> collection) {
        return new LocalDecompositionDescriptor(projectDescriptor, string, Collections.emptyMap(), collection, null);
    }

    public LocalDecompositionDescriptor.LocalResourceDescriptor createResourceDescriptor(String string, boolean bl, Map<String, String> map, Collection<LocalDecompositionDescriptor.SharePointDescriptor> collection) {
        return new LocalDecompositionDescriptor.LocalResourceDescriptor(string, bl, map, collection);
    }

    public LocalDecompositionDescriptor createDecompositionDescriptor(URI uRI, String string, String string2, String string3, LocalProject localProject, IProjectUsageResolver iProjectUsageResolver) {
        Collection<LocalDecompositionDescriptor.LocalProjectFeatureDescriptor> collection = this.createProjectFeatureDescriptors(localProject);
        Collection<LocalDecompositionDescriptor.AttachedProjectDescriptor> collection2 = this.createAttachedProjectDescriptor(localProject, iProjectUsageResolver);
        return this.createDecompositionDescriptor(new ProjectDescriptor(uRI, string2, string3), string, EMFTypesUtil.getMapFromEMap((EMap)localProject.getProperties()), collection, collection2);
    }
}

