/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.IProjectRepositoryType;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.ProjectAllocationException;
import com.nomagic.ci.persistence.ProjectEventType;
import com.nomagic.ci.persistence.ProjectOptions;
import com.nomagic.ci.persistence.ProjectRepositoryEvent;
import com.nomagic.ci.persistence.ProjectRepositoryListener;
import com.nomagic.ci.persistence.local.ProjectRepositoryEventType;
import com.nomagic.ci.persistence.local.internal.E;
import com.nomagic.ci.persistence.local.spi.DefaultProjectAccessController;
import com.nomagic.ci.persistence.local.spi.DefaultProjectOpenUtil;
import com.nomagic.ci.persistence.local.spi.IPrimaryProjectInternal;
import com.nomagic.ci.persistence.local.spi.IProjectRepositoryInternal;
import com.nomagic.ci.persistence.local.spi.LocalDescriptorFactory;
import com.nomagic.ci.persistence.local.spi.ProjectAccessController;
import com.nomagic.ci.persistence.local.spi.ProjectAttachOrDettachEventImpl;
import com.nomagic.ci.persistence.local.spi.ProjectRepositoryEventSupport;
import com.nomagic.ci.persistence.local.spi.ProjectRepositoryServiceRegistry;
import com.nomagic.ci.persistence.local.spi.events.CompositeEventSupport;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;

public abstract class DefaultProjectRepository
implements IProjectRepository,
IProjectRepositoryInternal {
    private final IProjectRepositoryType type;
    private ProjectAccessController accessController = new DefaultProjectAccessController();
    private final ProjectRepositoryServiceRegistry serviceRegistry = new ProjectRepositoryServiceRegistry();
    CompositeEventSupport<ProjectRepositoryListener, ProjectRepositoryEvent, ProjectRepositoryEventSupport> eventSupport = new CompositeEventSupport(new ProjectRepositoryEventSupport(), new ProjectRepositoryEventSupport(), new ProjectRepositoryEventSupport());
    private LocalDescriptorFactory descriptorFactory = LocalDescriptorFactory.DEFAULT;

    public DefaultProjectRepository(IProjectRepositoryType iProjectRepositoryType) {
        this.type = iProjectRepositoryType;
    }

    public IProjectRepositoryType getType() {
        return this.type;
    }

    public String toString() {
        return "[" + this.type.getId() + "] ";
    }

    @Override
    public LocalDescriptorFactory getDescriptorFactory() {
        return this.descriptorFactory;
    }

    protected void setDescriptorFactory(LocalDescriptorFactory localDescriptorFactory) {
        this.descriptorFactory = localDescriptorFactory;
    }

    public void setProjectAccessController(ProjectAccessController projectAccessController) {
        this.accessController = projectAccessController;
    }

    @Override
    public ProjectAccessController getProjectAccessController() {
        return this.accessController;
    }

    public final IPrimaryProject createProject(URI uRI, Set<String> set, IProgressMonitor iProgressMonitor) throws PersistenceException {
        return this.createProject(uRI, set, this.createProjectOptions(), iProgressMonitor);
    }

    public final IPrimaryProject createProject(URI uRI, Set<String> set, ProjectOptions projectOptions, IProgressMonitor iProgressMonitor) throws ProjectAllocationException, PersistenceException {
        IPrimaryProject iPrimaryProject;
        int n2 = this.getListenerTicks();
        int n3 = this.getListenersCount();
        IPrimaryProject iPrimaryProject2 = null;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        boolean bl = false;
        try {
            iProgressMonitor.beginTask("", n2 * 10 + n3);
            iProgressMonitor.subTask("Creating a new project...");
            if (projectOptions == null) {
                throw new IllegalArgumentException("Options not provided");
            }
            projectOptions = projectOptions.createCopy();
            this.fireEvent((IProject)iPrimaryProject2, uRI, ProjectRepositoryEventType.PRE_CREATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            iPrimaryProject2 = this.doCreateProject(uRI, set, projectOptions, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2 * 8));
            this.fireEvent((IProject)iPrimaryProject2, uRI, ProjectRepositoryEventType.POST_CREATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
            iPrimaryProject = iPrimaryProject2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.fireEvent((IProject)iPrimaryProject2, uRI, ProjectRepositoryEventType.FAILED_TO_CREATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            }
            iProgressMonitor.done();
            throw throwable;
        }
        if (!bl) {
            this.fireEvent((IProject)iPrimaryProject2, uRI, ProjectRepositoryEventType.FAILED_TO_CREATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
        }
        iProgressMonitor.done();
        return iPrimaryProject;
    }

    protected abstract IPrimaryProject doCreateProject(URI var1, Set<String> var2, ProjectOptions var3, IProgressMonitor var4) throws ProjectAllocationException, PersistenceException;

    public final IPrimaryProject openProject(URI uRI, IProgressMonitor iProgressMonitor) throws PersistenceException {
        return this.openProject(uRI, this.createProjectOptions(), iProgressMonitor);
    }

    protected ProjectOptions createProjectOptions() {
        return new ProjectOptions();
    }

    public IPrimaryProject openProject(URI uRI, ProjectOptions projectOptions, IProgressMonitor iProgressMonitor) throws PersistenceException {
        return new DefaultProjectOpenUtil<DefaultProjectRepository>(this.getProjectAccessController()).defaultOpenProject(this, uRI, projectOptions, iProgressMonitor);
    }

    protected abstract IPrimaryProject doOpenProject(URI var1, ProjectOptions var2, IProgressMonitor var3) throws PersistenceException;

    @Override
    public final IAttachedProject getAttachedProject(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, IPrimaryProjectInternal iPrimaryProjectInternal, IProgressMonitor iProgressMonitor) throws PersistenceException {
        IAttachedProject iAttachedProject;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = this.getListenerTicks();
        int n3 = this.getListenersCount();
        IAttachedProject iAttachedProject2 = null;
        boolean bl = false;
        iProgressMonitor.beginTask("Getting attached project...", n2 * 20 + n3 * 2);
        try {
            ProjectAttachOrDettachEventImpl projectAttachOrDettachEventImpl = new ProjectAttachOrDettachEventImpl(ProjectEventType.PRE_ADD_PROJECT, iPrimaryProjectInternal, null);
            iPrimaryProjectInternal.fireEvent(projectAttachOrDettachEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            this.fireEvent((IProject)iAttachedProject2, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), ProjectRepositoryEventType.PRE_OPEN, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            iAttachedProject2 = this.doGetAttachedProject(abstractProjectAttachmentConfiguration, iPrimaryProjectInternal, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2 * 16));
            this.fireEvent((IProject)iAttachedProject2, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), ProjectRepositoryEventType.POST_OPEN, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            ProjectAttachOrDettachEventImpl projectAttachOrDettachEventImpl2 = new ProjectAttachOrDettachEventImpl(ProjectEventType.POST_ADD_PROJECT, iPrimaryProjectInternal, iAttachedProject2);
            iPrimaryProjectInternal.fireEvent(projectAttachOrDettachEventImpl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
            iAttachedProject = iAttachedProject2;
        }
        catch (Throwable throwable) {
            try {
                if (!bl) {
                    ProjectAttachOrDettachEventImpl projectAttachOrDettachEventImpl = new ProjectAttachOrDettachEventImpl(ProjectEventType.FAILED_ADD_PROJECT, iPrimaryProjectInternal, iAttachedProject2);
                    iPrimaryProjectInternal.fireEvent(projectAttachOrDettachEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                    this.fireEvent((IProject)iAttachedProject2, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), ProjectRepositoryEventType.FAILED_TO_OPEN, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                }
            }
            finally {
                iProgressMonitor.done();
            }
            throw throwable;
        }
        try {
            if (!bl) {
                ProjectAttachOrDettachEventImpl projectAttachOrDettachEventImpl = new ProjectAttachOrDettachEventImpl(ProjectEventType.FAILED_ADD_PROJECT, iPrimaryProjectInternal, iAttachedProject2);
                iPrimaryProjectInternal.fireEvent(projectAttachOrDettachEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                this.fireEvent((IProject)iAttachedProject2, abstractProjectAttachmentConfiguration.getAttachedProjectURI(), ProjectRepositoryEventType.FAILED_TO_OPEN, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return iAttachedProject;
    }

    protected abstract IAttachedProject doGetAttachedProject(AbstractProjectAttachmentConfiguration var1, IPrimaryProjectInternal var2, IProgressMonitor var3) throws PersistenceException;

    @Override
    public final IAttachedProject createAttachedProject(URI uRI, Set<String> set, IPrimaryProjectInternal iPrimaryProjectInternal, IProgressMonitor iProgressMonitor) throws PersistenceException {
        IAttachedProject iAttachedProject;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        IAttachedProject iAttachedProject2 = null;
        int n2 = this.getListenerTicks();
        int n3 = this.getListenersCount();
        iProgressMonitor.beginTask("Creating Attached Project...", n2 * 20 + n3 * 2);
        boolean bl = false;
        try {
            this.fireEvent((IProject)iAttachedProject2, uRI, ProjectRepositoryEventType.PRE_CREATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            ProjectAttachOrDettachEventImpl projectAttachOrDettachEventImpl = new ProjectAttachOrDettachEventImpl(ProjectEventType.PRE_ADD_PROJECT, iPrimaryProjectInternal, iAttachedProject2);
            iPrimaryProjectInternal.fireEvent(projectAttachOrDettachEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            iAttachedProject2 = this.doCreateAttachedProject(uRI, set, iPrimaryProjectInternal, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 16 * n2));
            projectAttachOrDettachEventImpl = new ProjectAttachOrDettachEventImpl(ProjectEventType.POST_ADD_PROJECT, iPrimaryProjectInternal, iAttachedProject2);
            iPrimaryProjectInternal.fireEvent(projectAttachOrDettachEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            this.fireEvent((IProject)iAttachedProject2, uRI, ProjectRepositoryEventType.POST_CREATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
            iAttachedProject = iAttachedProject2;
        }
        catch (Throwable throwable) {
            try {
                if (!bl) {
                    ProjectAttachOrDettachEventImpl projectAttachOrDettachEventImpl = new ProjectAttachOrDettachEventImpl(ProjectEventType.FAILED_ADD_PROJECT, iPrimaryProjectInternal, iAttachedProject2);
                    iPrimaryProjectInternal.fireEvent(projectAttachOrDettachEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                    this.fireEvent((IProject)iAttachedProject2, uRI, ProjectRepositoryEventType.FAILED_TO_CREATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                }
            }
            finally {
                iProgressMonitor.done();
            }
            throw throwable;
        }
        try {
            if (!bl) {
                ProjectAttachOrDettachEventImpl projectAttachOrDettachEventImpl = new ProjectAttachOrDettachEventImpl(ProjectEventType.FAILED_ADD_PROJECT, iPrimaryProjectInternal, iAttachedProject2);
                iPrimaryProjectInternal.fireEvent(projectAttachOrDettachEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                this.fireEvent((IProject)iAttachedProject2, uRI, ProjectRepositoryEventType.FAILED_TO_CREATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return iAttachedProject;
    }

    protected abstract IAttachedProject doCreateAttachedProject(URI var1, Set<String> var2, IPrimaryProjectInternal var3, IProgressMonitor var4) throws PersistenceException;

    @Override
    public boolean projectHasToBeUpdatedBeforeAttaching(IProject iProject, AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, IProjectRepository iProjectRepository) {
        return false;
    }

    @Override
    @CheckForNull
    public Set<IProject> collectNonChildrenProjectsInvolvedInUpdateOfProject(IProject iProject) {
        return null;
    }

    @Override
    @CheckForNull
    public Set<IProject> collectTopLevelProjectsThatHaveToBeUpdatedToLoadProject(IAttachedProject iAttachedProject) {
        return null;
    }

    public void addListener(ProjectRepositoryListener projectRepositoryListener) {
        this.eventSupport.getEventSupport().addListener(projectRepositoryListener);
    }

    public void addPostListener(ProjectRepositoryListener projectRepositoryListener) {
        this.eventSupport.getPostEventSupport().addListener(projectRepositoryListener);
    }

    public void addPreListener(ProjectRepositoryListener projectRepositoryListener) {
        this.eventSupport.getPreEventSupport().addListener(projectRepositoryListener);
    }

    public void removeListener(ProjectRepositoryListener projectRepositoryListener) {
        this.eventSupport.getEventSupport().removeListener(projectRepositoryListener);
    }

    public void fireEvent(IProject iProject, URI uRI, ProjectRepositoryEventType projectRepositoryEventType, IProgressMonitor iProgressMonitor) {
        E e2 = new E(iProject, uRI, projectRepositoryEventType);
        this.fireEvent(e2, iProgressMonitor);
    }

    @Override
    public final void fireEvent(ProjectRepositoryEvent projectRepositoryEvent, IProgressMonitor iProgressMonitor) {
        this.eventSupport.fireEvent(projectRepositoryEvent, iProgressMonitor);
    }

    public List<ProjectRepositoryListener> getListeners() {
        return this.eventSupport.getEventSupport().getListeners();
    }

    public List<ProjectRepositoryListener> getPostListeners() {
        return this.eventSupport.getPostEventSupport().getListeners();
    }

    public List<ProjectRepositoryListener> getPreListeners() {
        return this.eventSupport.getPreEventSupport().getListeners();
    }

    @Override
    public int getListenerTicks() {
        int n2 = this.getListenersCount();
        if (n2 == 0) {
            n2 = 1;
        }
        return this.getListenersCount() * 100;
    }

    protected int getListenersCount() {
        return this.eventSupport.getEventSupport().getListenerCount();
    }

    @CheckForNull
    public <T> T getService(Class<T> clazz) {
        return this.serviceRegistry.a(clazz);
    }

    public <T> void registerRepositoryService(Class<T> clazz, T t2) {
        this.serviceRegistry.a(clazz, t2);
    }
}

